/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class XorEncoderUtil {
    public static String encodeXor(String expression) {
        if (!XorEncoderUtil.isWellFormed(expression)) {
            return expression;
        }
        expression = expression.replace("XOR(", "xor(");
        while (expression.contains("xor(")) {
            expression = XorEncoderUtil.eliminateFirstXor(expression);
        }
        return expression;
    }

    public static boolean isWellFormed(String expression) {
        Stack<Character> stack = new Stack<Character>();
        char[] cArray = expression.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (c.equals(Character.valueOf('('))) {
                stack.push(c);
            } else if (c.equals(Character.valueOf(')'))) {
                if (stack.empty()) {
                    return false;
                }
                stack.pop();
            }
            ++n2;
        }
        return stack.isEmpty();
    }

    private static String eliminateFirstXor(String expression) {
        ArrayList<String> arguments = new ArrayList<String>();
        int startIndex = expression.indexOf("xor(") + 4;
        int endIndex = -1;
        int index = expression.indexOf("xor(") + 4;
        int offsetCurrentArgument = expression.indexOf("xor(") + 4;
        int bracketDepth = 0;
        while (endIndex == -1 && index < expression.length()) {
            int nextRelevantPos = XorEncoderUtil.findNextRelevantChar(expression, index);
            if (nextRelevantPos > -1) {
                String argument;
                char nextRelevant = expression.charAt(nextRelevantPos);
                if (nextRelevant == '(') {
                    ++bracketDepth;
                } else if (nextRelevant == ')' && bracketDepth > 0) {
                    --bracketDepth;
                } else if (nextRelevant == ')' && bracketDepth == 0) {
                    argument = expression.substring(offsetCurrentArgument, nextRelevantPos).trim();
                    arguments.add(argument);
                    endIndex = nextRelevantPos;
                } else if (nextRelevant == ',' && bracketDepth == 0) {
                    argument = expression.substring(offsetCurrentArgument, nextRelevantPos).trim();
                    arguments.add(argument);
                    offsetCurrentArgument = nextRelevantPos + 1;
                }
                index = nextRelevantPos + 1;
                continue;
            }
            throw new RuntimeException("Error in expression " + expression);
        }
        String prefix = expression.substring(0, startIndex - 4);
        String suffix = expression.substring(endIndex + 1, expression.length());
        return String.valueOf(prefix) + XorEncoderUtil.createEncoding(arguments) + suffix;
    }

    private static int findNextRelevantChar(String expression, int offset) {
        String substring = expression.substring(offset);
        int indexOpenBracket = substring.indexOf(40);
        int indexClosedBracket = substring.indexOf(41);
        int indexComma = substring.indexOf(44);
        int result = -1;
        if (indexOpenBracket >= 0) {
            if (indexClosedBracket >= 0) {
                result = Math.min(indexOpenBracket, indexClosedBracket);
                if (indexComma >= 0) {
                    result = Math.min(indexComma, result);
                }
            } else if (indexComma >= 0) {
                result = Math.min(indexComma, indexOpenBracket);
            }
        } else {
            result = indexClosedBracket >= 0 ? (indexComma >= 0 ? Math.min(indexComma, indexClosedBracket) : indexClosedBracket) : indexComma;
        }
        if (result > -1) {
            result += offset;
        }
        return result;
    }

    private static String createEncoding(List<String> literals) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < literals.size()) {
            sb.append('(');
            int j = 0;
            while (j < literals.size()) {
                if (i == j) {
                    sb.append(literals.get(i));
                } else {
                    sb.append("!(");
                    sb.append(literals.get(j));
                    sb.append(")");
                }
                if (j + 1 < literals.size()) {
                    sb.append(" and ");
                }
                ++j;
            }
            sb.append(')');
            if (i + 1 < literals.size()) {
                sb.append(" or ");
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(XorEncoderUtil.encodeXor("xor(A, B, C)"));
        System.out.println(XorEncoderUtil.encodeXor("xor(A, !B, D)"));
        System.out.println(XorEncoderUtil.encodeXor("xor(A, xor(B,C))"));
        System.out.println(XorEncoderUtil.encodeXor("xor(def(tr_e_04_argument),def(tr_e_04_source))"));
    }
}

