/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.csp;

import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.csp.BinaryConstraint;
import agg.util.csp.InstantiationHook;
import agg.util.csp.Variable;
import agg.xt_basis.GraphObject;
import java.util.Vector;

public class Constraint_Attribute
extends BinaryConstraint
implements InstantiationHook {
    private GraphObject itsGraphObj;
    private AttrContext itsAttrContext;
    private AttrManager itsAttrManager;
    private AttrMapping itsAttrMapping;
    private boolean attributed = true;
    private int state = -1;
    private static final int NOTHING = -1;
    private static final int INSTANTIATE = 0;
    private static final int UNINSTANTIATE = 1;
    private Variable instantiateVariable = null;

    public Constraint_Attribute(GraphObject graphobj, Variable var, AttrContext ac, AttrManager man) {
        super(var, 0);
        var.addInstantiationHook(this);
        this.itsGraphObj = graphobj;
        this.itsAttrContext = ac;
        this.itsAttrManager = man;
        int fact = this.getWeightFactor();
        if (fact > 0) {
            this.itsWeight += fact;
            var.addWeight(this.itsWeight);
        }
    }

    @Override
    public void clear() {
        this.itsVar1 = null;
        this.itsGraphObj = null;
    }

    private int getWeightFactor() {
        if (this.itsGraphObj == null || this.itsGraphObj.getAttribute() == null) {
            return 0;
        }
        VarTuple vars = null;
        if (this.itsAttrContext != null) {
            vars = (VarTuple)this.itsAttrContext.getVariables();
        }
        ValueTuple vt = (ValueTuple)this.itsGraphObj.getAttribute();
        int i = 0;
        while (i < vt.getSize()) {
            ValueMember vm = vt.getValueMemberAt(i);
            if (vm.isSet()) {
                VarMember var;
                if (vm.getExpr().isConstant()) {
                    return 2;
                }
                if (vm.getExpr().isVariable() && vars != null && (var = vars.getVarMemberAt(vm.getExprAsText())) != null && var.isInputParameter()) {
                    return 3;
                }
            }
            ++i;
        }
        return 1;
    }

    @Override
    public final boolean execute() {
        if (this.state == 0) {
            this.instantiate_intern(this.instantiateVariable);
            this.state = 1;
        }
        return !this.attributed && this.itsAttrMapping == null || this.attributed && this.itsAttrMapping != null;
    }

    @Override
    public final void instantiate(Variable var) {
        this.state = 0;
        this.instantiateVariable = var;
    }

    @Override
    public final void uninstantiate(Variable var) {
        if (this.state == 1) {
            this.uninstantiate_intern(var);
        }
        this.state = -1;
        this.instantiateVariable = null;
    }

    public final void instantiate_intern(Variable var) {
        block5: {
            if (!(var.getInstance() instanceof GraphObject)) {
                return;
            }
            if (!this.itsGraphObj.attrExists()) {
                this.attributed = false;
                return;
            }
            AttrInstance origAttr = this.itsGraphObj.getAttribute();
            AttrInstance instAttr = ((GraphObject)var.getInstance()).getAttribute();
            try {
                if (origAttr != null && instAttr != null) {
                    this.itsAttrMapping = this.itsAttrManager.newMapping(this.itsAttrContext, this.itsGraphObj.getAttribute(), ((GraphObject)var.getInstance()).getAttribute());
                    this.itsAttrMapping.remove();
                }
            }
            catch (AttrException exc) {
                if (this.itsAttrMapping == null) break block5;
                this.itsAttrMapping.remove();
                this.itsAttrMapping = null;
            }
        }
    }

    public final void uninstantiate_intern(Variable var) {
        if (var.getInstance() instanceof GraphObject) {
            GraphObject go = (GraphObject)var.getInstance();
            if (this.itsAttrContext != null && go.getAttribute() != null) {
                this.unsetUsedVariable(go);
            }
            if (this.itsAttrMapping != null) {
                this.itsAttrMapping.remove();
                this.itsAttrMapping = null;
            }
        }
    }

    public GraphObject getGraphObject() {
        return this.itsGraphObj;
    }

    private void unsetUsedVariable(GraphObject go) {
        Vector<String> attrVars = ((ValueTuple)go.getAttribute()).getAllVariableNames();
        if (attrVars.size() > 0) {
            VarTuple varTup = (VarTuple)this.itsAttrContext.getVariables();
            int i = 0;
            while (i < attrVars.size()) {
                String name = attrVars.elementAt(i);
                VarMember vm = varTup.getVarMemberAt(name);
                if (vm != null) {
                    vm.setExpr(null);
                }
                ++i;
            }
        }
    }
}

