/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.csp;

import agg.attribute.AttrContext;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Pair;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Solution_Backjump;
import agg.util.csp.Variable;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.csp.ALR_InheritCSP;
import java.util.BitSet;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Completion_InheritCSP
extends MorphCompletionStrategy {
    private ALR_InheritCSP itsCSP;
    private Morphism itsMorph;
    private Dictionary<Object, Variable> relatedVarMap;
    private HashMap<String, String> mapInputParameter = new HashMap(1);
    private String errorMsg;
    private static final BitSet itsSupportedProperties = new BitSet(6);

    static {
        itsSupportedProperties.set(0);
        itsSupportedProperties.set(1);
        itsSupportedProperties.set(2);
    }

    public Completion_InheritCSP() {
        super(itsSupportedProperties);
        this.randomDomain = true;
        this.itsName = "CSP NTI";
    }

    @Override
    public void dispose() {
        super.dispose();
        itsSupportedProperties.clear();
        this.mapInputParameter.clear();
        this.relatedVarMap = null;
        this.itsMorph = null;
        this.itsCSP = null;
    }

    public void setProperties(MorphCompletionStrategy fromStrategy) {
        this.initialize(itsSupportedProperties, (BitSet)fromStrategy.getProperties().clone());
    }

    @Override
    public final void initialize(OrdinaryMorphism morph) throws BadMappingException {
        this.itsMorph = morph;
        AttrContext aContext = this.initializeAttrContext(morph);
        this.itsCSP = new ALR_InheritCSP(morph.getOriginal(), aContext);
        if (morph.getImage().getTypeObjectsMap().isEmpty()) {
            morph.getImage().fillTypeObjectsMap();
        }
        this.itsCSP.setRequester(morph);
        this.itsCSP.setDomain(morph.getImage());
    }

    private AttrContext initializeAttrContext(OrdinaryMorphism morph) {
        if (morph instanceof Match) {
            ContextView c = (ContextView)morph.getAttrManager().newContext(((ContextView)morph.getAttrContext()).getAllowedMapping(), ((Match)morph).getRule().getAttrContext());
            c.setIgnoreOfConstContext(((ContextView)morph.getAttrContext()).isIgnoreConstContext());
            return c;
        }
        return morph.getAttrManager().newContext(0);
    }

    protected SolutionStrategy createSolutionStrategy() {
        return new Solution_Backjump(this.getProperties().get(0));
    }

    @Override
    public final void reset() {
        if (this.itsCSP != null) {
            this.itsCSP.reset();
        }
    }

    @Override
    public void resetSolverQuery_Type() {
        if (this.itsCSP != null) {
            this.itsCSP.resetQuery_Type();
        }
    }

    @Override
    public void enableParallelSearch(boolean b) {
        this.parallel = b;
        if (this.itsCSP != null) {
            this.itsCSP.getSolutionSolver().enableParallelSearch(b);
        }
    }

    @Override
    public void setStartParallelSearchByFirst(boolean b) {
        this.startParallelMatchByFirstCSPVar = b;
        if (this.itsCSP != null) {
            this.itsCSP.getSolutionSolver().setStartParallelSearchByFirst(b);
        }
    }

    @Override
    public AttrContext getAttrContext() {
        return this.itsCSP != null ? this.itsCSP.getAttrContext() : null;
    }

    @Override
    public void resetSolver(boolean doUpdateQueries) {
        if (this.itsCSP != null) {
            this.itsCSP.resetSolver(doUpdateQueries);
        }
    }

    @Override
    public void reinitializeSolver(boolean doUpdateQueries) {
        if (this.itsCSP != null) {
            this.itsCSP.reinitializeSolver(doUpdateQueries);
        }
    }

    @Override
    public void resetSolverVariables() {
        if (this.itsCSP != null) {
            this.itsCSP.resetSolverVariables();
        }
    }

    @Override
    public boolean isDomainOfTypeEmpty(Type t) {
        return this.itsCSP.isDomainOfTypeEmpty(t);
    }

    @Override
    public boolean isDomainOfTypeEmpty(Type t, Type src, Type tar) {
        return this.itsCSP.isDomainOfTypeEmpty(t, src, tar);
    }

    @Override
    public void setRelatedInstanceVarMap(Dictionary<Object, Variable> relVarMap) {
        this.relatedVarMap = relVarMap;
    }

    @Override
    public boolean hasRelatedInstanceVarMap() {
        return this.relatedVarMap != null;
    }

    @Override
    public Dictionary<Object, Variable> getInstanceVarMap() {
        if (this.itsCSP != null) {
            return this.itsCSP.getInstanceVarMap();
        }
        return null;
    }

    @Override
    public void resetTypeMap(Hashtable<String, HashSet<GraphObject>> typeMap) {
        if (this.itsCSP != null) {
            this.itsCSP.resetTypeMap(typeMap);
        }
    }

    @Override
    public void resetTypeMap(Graph g) {
        if (this.itsCSP != null) {
            this.itsCSP.resetTypeMap(g);
        }
    }

    @Override
    public void resetVariableDomain(boolean initInstanceByNull) {
        if (this.itsCSP != null) {
            this.itsCSP.resetVariableDomain(initInstanceByNull);
        }
    }

    @Override
    public void resetVariableDomain(GraphObject go) {
        if (this.itsCSP != null) {
            this.itsCSP.resetVariableDomain(go);
        }
    }

    @Override
    protected void unsetAttrContextVariable() {
        this.itsCSP.unsetAttrContextVariable();
    }

    @Override
    public final boolean next(OrdinaryMorphism morph) {
        if (morph != this.itsMorph) {
            try {
                this.initialize(morph);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        return this.doNext((OrdinaryMorphism)this.itsMorph);
    }

    private boolean doNext(OrdinaryMorphism morph) {
        this.itsCSP.setRelatedInstanceVarMap(this.relatedVarMap);
        boolean flag = false;
        this.errorMsg = "";
        if (morph.getAttrContext() != null) {
            ((VarTuple)morph.getAttrContext().getVariables()).unsetNotInputVariables();
        }
        while (this.itsCSP.nextSolution()) {
            GraphObject anImage;
            GraphObject anOrig;
            flag = true;
            this.errorMsg = "";
            Iterator<Node> anNodeIter = morph.getOriginal().getNodesSet().iterator();
            while (flag && anNodeIter.hasNext()) {
                anOrig = anNodeIter.next();
                Variable lhsVariable = this.itsCSP.getVariable(anOrig);
                if (lhsVariable == null || (anImage = (GraphObject)lhsVariable.getInstance()) == null) continue;
                try {
                    morph.addChild2ParentMapping(anOrig, anImage);
                    if (morph.getImage(anOrig) != null) continue;
                    flag = false;
                }
                catch (BadMappingException ex) {
                    flag = false;
                }
            }
            Iterator<Arc> anArcIter = morph.getOriginal().getArcsSet().iterator();
            while (flag && anArcIter.hasNext()) {
                anOrig = anArcIter.next();
                Variable lhsVariable = this.itsCSP.getVariable(anOrig);
                if (lhsVariable == null || (anImage = (GraphObject)lhsVariable.getInstance()) == null) continue;
                try {
                    morph.addChild2ParentMapping(anOrig, anImage);
                    if (morph.getImage(anOrig) != null) continue;
                    flag = false;
                }
                catch (BadMappingException ex) {
                    flag = false;
                }
            }
            if (!flag) continue;
            if (morph.getAttrContext() != null) {
                boolean bl = flag = flag && this.checkObjectsWithSameVariable(morph);
            }
            if (flag) break;
            morph.setErrorMsg(this.errorMsg);
        }
        return flag;
    }

    private boolean checkObjectsWithSameVariable(OrdinaryMorphism morph) {
        VarTuple variables = (VarTuple)morph.getAttrContext().getVariables();
        int i = 0;
        while (i < variables.getSize()) {
            ValueMember mem;
            int k;
            ValueTuple origVal;
            VarMember var = variables.getVarMemberAt(i);
            Vector<Pair<GraphObject, String>> v = new Vector<Pair<GraphObject, String>>();
            for (GraphObject graphObject : morph.getOriginal().getNodesSet()) {
                if (graphObject.getAttribute() == null) continue;
                origVal = (ValueTuple)graphObject.getAttribute();
                k = 0;
                while (k < origVal.getSize()) {
                    mem = origVal.getValueMemberAt(k);
                    if (mem.isSet() && mem.getExpr().isVariable() && mem.getExprAsText().equals(var.getName()) && mem.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) {
                        v.add(new Pair<GraphObject, String>(graphObject, mem.getName()));
                    }
                    ++k;
                }
            }
            for (GraphObject graphObject : morph.getOriginal().getArcsSet()) {
                if (graphObject.getAttribute() == null) continue;
                origVal = (ValueTuple)graphObject.getAttribute();
                k = 0;
                while (k < origVal.getSize()) {
                    mem = origVal.getValueMemberAt(k);
                    if (mem.isSet() && mem.getExpr().isVariable() && mem.getExprAsText().equals(var.getName()) && mem.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName())) {
                        v.add(new Pair<GraphObject, String>(graphObject, mem.getName()));
                    }
                    ++k;
                }
            }
            if (v.size() > 1) {
                Pair pair = (Pair)v.elementAt(0);
                GraphObject img = morph.getImage((GraphObject)pair.first);
                ValueTuple val = (ValueTuple)img.getAttribute();
                mem = val.getValueMemberAt((String)pair.second);
                int j = 1;
                while (j < v.size()) {
                    Pair pj = (Pair)v.elementAt(j);
                    GraphObject imgj = morph.getImage((GraphObject)pj.first);
                    ValueTuple valj = (ValueTuple)imgj.getAttribute();
                    ValueMember memj = valj.getValueMemberAt((String)pj.second);
                    if (mem.isSet() && memj.isSet()) {
                        if (mem.getExpr().isConstant() && memj.getExpr().isConstant()) {
                            if (!mem.getExprAsText().equals(memj.getExprAsText())) {
                                this.errorMsg = "Attribute check: equal value by equal variable - failed!.";
                                return false;
                            }
                        } else if (mem.getExpr().isVariable() && memj.getExpr().isVariable()) {
                            if (!mem.getExprAsText().equals(memj.getExprAsText())) {
                                this.errorMsg = "Attribute check: equal value by equal variable - failed!.";
                                return false;
                            }
                        } else {
                            this.errorMsg = "Attribute check: equal value by equal variable - failed!";
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public void addObjectNameConstraint(GraphObject anObj) {
        this.itsCSP.addObjectNameConstraint(anObj);
    }

    @Override
    public void removeObjectNameConstraint(GraphObject anObj) {
        this.itsCSP.removeObjectNameConstraint(anObj);
    }
}

