/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.MatchHelper;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.PACStarMorphism;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class NestedApplCond
extends OrdinaryMorphism
implements Evaluable {
    NestedApplCond itsParent;
    String varTag = "";
    private boolean evaluable = true;
    final List<NestedApplCond> itsACs = new Vector<NestedApplCond>(0, 1);
    String formulaStr = "true";
    Formula itsFormula = new Formula(true);
    OrdinaryMorphism relatedMorph;
    public boolean forall;
    public boolean exist;

    public NestedApplCond(Graph orig, Graph img, AttrContext ac) {
        super(orig, img, ac);
    }

    public void setParent(NestedApplCond ac) {
        this.itsParent = ac;
    }

    public NestedApplCond getParent() {
        return this.itsParent;
    }

    @Override
    public void setName(String n) {
        this.itsName = n;
        this.itsFormula.setName(n.concat(".formula"));
    }

    @Override
    public String getName() {
        return this.itsName;
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).clear();
            ++i;
        }
        super.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        this.itsACs.clear();
        super.dispose();
    }

    public boolean isValid() {
        if (this.isEnabled()) {
            for (Node x : this.itsOrig.getNodesSet()) {
                Node y;
                if (this.getImage(x) != null || (y = (Node)this.getImage(x)) == null || x.getNumberOfArcs() == y.getNumberOfArcs()) continue;
                this.setErrorMsg(String.valueOf(this.getName()) + "  -  General AC failed (dangling edge)");
                return false;
            }
            int i = 0;
            while (i < this.itsACs.size()) {
                NestedApplCond ac = this.itsACs.get(i);
                if (!ac.isValid()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void disposeResults() {
        this.relatedMorph = null;
        int i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).disposeResults();
            ++i;
        }
        if (this.itsCoMorph != null) {
            this.itsCoMorph.dispose();
            this.itsCoMorph = null;
        }
    }

    public NestedApplCond createNestedAC() {
        NestedApplCond ac = new NestedApplCond(this.itsImag, BaseFactory.theFactory().createGraph(this.itsImag.getTypeSet()), this.itsImag.getAttrContext());
        ac.setParent(this);
        this.itsACs.add(ac);
        AttrContext acContext = ac.getAttrContext();
        ac.getImage().setAttrContext(acContext);
        ac.getImage().setKind("AC");
        return ac;
    }

    public boolean addNestedAC(NestedApplCond cond) {
        if (cond.getSource() == this.itsImag && !this.itsACs.contains(cond)) {
            this.itsACs.add(cond);
            cond.setParent(this);
            return true;
        }
        return false;
    }

    public boolean addNestedAC(int indx, NestedApplCond ac) {
        if (ac.getSource() == this.itsImag && !this.itsACs.contains(ac)) {
            ac.getTarget().setKind("AC");
            if (indx >= 0 && indx < this.itsACs.size()) {
                this.itsACs.add(indx, ac);
            } else {
                this.itsACs.add(ac);
            }
            ac.setParent(this);
            return true;
        }
        return false;
    }

    public void removeNestedAC(NestedApplCond ac) {
        if (this.itsACs.remove(ac)) {
            this.itsFormula.patchOutEvaluable(ac, true);
            this.refreshFormula(new Vector<Evaluable>(this.getEnabledACs()));
        }
    }

    public int getSizeOfNestedAC() {
        return this.itsACs.size();
    }

    public List<NestedApplCond> getNestedACs() {
        return this.itsACs;
    }

    public List<Evaluable> getEnabledGeneralACsAsEvaluable() {
        Vector<Evaluable> list = new Vector<Evaluable>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            if (ac.isEnabled()) {
                list.add(ac);
            }
            ++i;
        }
        return list;
    }

    public NestedApplCond getNestedACAt(int indx) {
        if (indx >= 0 && indx < this.itsACs.size()) {
            return this.itsACs.get(indx);
        }
        return null;
    }

    public boolean setDefaultFormulaTrue() {
        Vector<Evaluable> vars = new Vector<Evaluable>(this.itsACs.size());
        if (this.itsACs.size() == 0) {
            this.formulaStr = "true";
            return true;
        }
        String tmp = "";
        int indx = -1;
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
                tmp = ++indx == 0 ? tmp.concat(String.valueOf(indx + 1)) : tmp.concat("&").concat(String.valueOf(indx + 1));
            }
            ++i;
        }
        if ("".equals(tmp)) {
            this.formulaStr = "true";
            return true;
        }
        if (this.itsFormula.setFormula(vars, tmp)) {
            this.formulaStr = this.itsFormula.getAsString(vars);
            return true;
        }
        return false;
    }

    public boolean setDefaultFormulaFalse() {
        Vector<Evaluable> vars = new Vector<Evaluable>(this.itsACs.size());
        if (this.itsACs.size() == 0) {
            this.formulaStr = "true";
            return true;
        }
        String tmp = "";
        int indx = -1;
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
                tmp = ++indx == 0 ? tmp.concat(String.valueOf(indx + 1)) : tmp.concat("&").concat(String.valueOf(indx + 1));
            }
            ++i;
        }
        if ("".equals(tmp)) {
            this.formulaStr = "true";
            return true;
        }
        if (this.itsFormula.setFormula(vars, tmp = "!(".concat(tmp).concat(")"))) {
            this.formulaStr = this.itsFormula.getAsString(vars);
            return true;
        }
        return false;
    }

    public boolean refreshFormula(List<Evaluable> vars) {
        String bnf = this.formulaStr;
        if (this.itsFormula.setFormula(vars, bnf)) {
            this.formulaStr = this.itsFormula.getAsString(vars);
            this.setTextualComment("Formula: ".concat(this.formulaStr));
            return true;
        }
        this.formulaStr = "true";
        return false;
    }

    public boolean setFormula(String formStr) {
        return this.setFormula(formStr, this.getEnabledACs());
    }

    public boolean setFormula(String formStr, List<NestedApplCond> list) {
        if (formStr.equals("true")) {
            this.formulaStr = formStr;
            return true;
        }
        if (formStr.equals("false")) {
            return this.setDefaultFormulaFalse();
        }
        int n = 0;
        Vector<Evaluable> vars = new Vector<Evaluable>(n);
        int i = 0;
        while (i < list.size()) {
            NestedApplCond ac = list.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
                ++n;
            }
            ++i;
        }
        if (n == 0) {
            this.formulaStr = "true";
            return true;
        }
        if (this.itsFormula.setFormula(vars, formStr)) {
            this.formulaStr = this.itsFormula.getAsString(vars);
            this.setTextualComment("Formula: ".concat(this.formulaStr));
            this.interpretForallOperator();
            return true;
        }
        return false;
    }

    public void setFormula(Formula f) {
        this.itsFormula = f;
        this.formulaStr = this.itsFormula.getAsString(this.getEnabledGeneralACsAsEvaluable());
        this.setTextualComment("Formula: ".concat(this.formulaStr));
    }

    private void interpretForallOperator() {
        this.forall = this.formulaStr.contains("A");
    }

    public void setRelatedMorphism(OrdinaryMorphism morph) {
        this.relatedMorph = morph;
    }

    public OrdinaryMorphism getRelatedMorphism() {
        return this.relatedMorph;
    }

    public boolean evaluate(Graph g) {
        if (!this.enabled) {
            return true;
        }
        if (this.relatedMorph == null || this.relatedMorph.getTarget() != g) {
            return false;
        }
        PACStarMorphism comorph = MatchHelper.createNestedACstar(this, this.relatedMorph);
        boolean result = MatchHelper.checkGACStar(comorph, this, this.relatedMorph, false) != null;
        this.disposeResults();
        return result;
    }

    @Override
    public void setCoMorphism(OrdinaryMorphism aCoMorph) {
        this.itsCoMorph = aCoMorph;
    }

    @Override
    public boolean eval(Object o) {
        return this.evaluate((Graph)o);
    }

    @Override
    public boolean eval(Object o, int tick) {
        return this.evaluate((Graph)o);
    }

    @Override
    public boolean eval(Object o, boolean negation) {
        return this.evaluate((Graph)o);
    }

    @Override
    public boolean eval(Object o, int tick, boolean negation) {
        return this.evaluate((Graph)o);
    }

    public boolean isEvaluable() {
        return this.evaluable;
    }

    public String getFormulaStr() {
        return this.formulaStr;
    }

    public String getFormulaText() {
        return this.formulaStr;
    }

    public Formula getFormula() {
        return this.itsFormula;
    }

    public boolean evalFormulaAtGraph(Object g) {
        return this.evalFormula((Graph)g);
    }

    public boolean evalFormula(Graph g) {
        if (this.itsACs.size() != 0) {
            if (this.itsCoMorph != null) {
                int i = 0;
                while (i < this.itsACs.size()) {
                    NestedApplCond ac = this.itsACs.get(i);
                    ac.setRelatedMorphism(this.itsCoMorph);
                    ++i;
                }
                if (this.formulaStr.equals("true")) {
                    this.setDefaultFormulaTrue();
                } else if (this.formulaStr.equals("false")) {
                    this.setDefaultFormulaFalse();
                }
                return this.itsFormula.eval(g);
            }
            return false;
        }
        return true;
    }

    public List<NestedApplCond> getEnabledNestedACs() {
        Vector<NestedApplCond> vars = new Vector<NestedApplCond>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
            }
            vars.addAll(ac.getEnabledNestedACs());
            ++i;
        }
        return vars;
    }

    public List<NestedApplCond> getEnabledACs() {
        Vector<NestedApplCond> vars = new Vector<NestedApplCond>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
            }
            ++i;
        }
        return vars;
    }

    public List<String> getNameOfEnabledACs() {
        Vector<String> vars = new Vector<String>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac.getName());
            }
            ++i;
        }
        return vars;
    }

    public List<String> getNameOfEnabledNestedACs() {
        Vector<String> vars = new Vector<String>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac.getName());
            }
            vars.addAll(ac.getNameOfEnabledNestedACs());
            ++i;
        }
        return vars;
    }

    public List<String> getNameOfNestedACs() {
        Vector<String> vars = new Vector<String>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = this.itsACs.get(i);
            vars.add(ac.getName());
            vars.addAll(ac.getNameOfEnabledNestedACs());
            ++i;
        }
        return vars;
    }

    public void setVarTagInFormula(String n) {
        this.varTag = n;
    }

    public String getVarTagInFormula() {
        return this.varTag;
    }

    public void readNestedApplConds(XMLHelper h) {
        if (h.readSubTag("ApplCondition")) {
            while (h.readSubTag("NestedAC")) {
                String attrStr = h.readAttr("formula");
                this.formulaStr = !"".equals(attrStr) ? attrStr : "true";
                this.setTextualComment("Formula: ".concat(this.formulaStr));
                boolean acEnabled = true;
                String acattr_enabled = h.readAttr("enabled");
                if (acattr_enabled != null && acattr_enabled.equals("false")) {
                    acEnabled = false;
                }
                NestedApplCond ac = this.createNestedAC();
                ac.getTarget().setHelpInfo(this.getName());
                ac.getTarget().xyAttr = this.getTarget().xyAttr;
                h.getObject("", ac.getTarget(), true);
                ac.readMorphism(h);
                ac.readNestedApplConds(h);
                h.close();
                ac.setEnabled(acEnabled);
                ac.getTarget().setHelpInfo("");
            }
            if (h.readSubTag("AttrCondition")) {
                AttrConditionTuple condt = this.getAttrContext().getConditions();
                if (condt != null) {
                    h.enrichObject(condt);
                }
                h.close();
            }
            h.close();
            this.setFormula(this.formulaStr);
        }
    }

    public void writeNestedApplConds(XMLHelper h) {
        AttrConditionTuple condt = this.getAttrContext().getConditions();
        int num = condt.getNumberOfEntries();
        Enumeration<NestedApplCond> nested = new Vector<NestedApplCond>(this.itsACs).elements();
        if (nested.hasMoreElements()) {
            h.openSubTag("ApplCondition");
            while (nested.hasMoreElements()) {
                OrdinaryMorphism m = nested.nextElement();
                m.getTarget().setKind("AC");
                h.openSubTag("NestedAC");
                if (!"".equals(this.formulaStr)) {
                    h.addAttr("formula", this.formulaStr);
                }
                if (!m.isEnabled()) {
                    h.addAttr("enabled", "false");
                }
                h.addObject("", m.getTarget(), true);
                m.writeMorphism(h);
                ((NestedApplCond)m).writeNestedApplConds(h);
                h.close();
            }
            if (num > 0) {
                h.openSubTag("AttrCondition");
                h.addObject("", condt, true);
                h.close();
            }
            h.close();
        }
    }

    @Override
    public boolean evalForall(Object o, int tick) {
        return false;
    }
}

