/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.xt_basis.Rule;
import agg.xt_basis.RulePriority;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class GraGraPriorityDialog
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private JPanel rulePanel;
    private JPanel buttonPanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JButton closeButton;
    private JButton cancelButton;
    private boolean isCancelled;
    private RulePriority priority;
    boolean changed = false;

    public GraGraPriorityDialog(JFrame parent, RulePriority priority) {
        super((Frame)parent, true);
        this.setTitle("Rule Priority");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GraGraPriorityDialog.this.exitForm(evt);
            }
        });
        this.priority = priority;
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        JPanel help = new JPanel(new GridBagLayout());
        JLabel l1 = new JLabel(" Only priority > 0 allowed.");
        JLabel l2 = new JLabel(" The  smallest  priority is");
        JLabel l3 = new JLabel(" the highest.");
        this.constrainBuild(help, l1, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 10, 20, 0, 10);
        this.constrainBuild(help, l2, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 0, 20, 0, 10);
        this.constrainBuild(help, l3, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 0, 20, 10, 10);
        this.rulePanel = new JPanel(new BorderLayout());
        this.rulePanel.setBackground(Color.orange);
        this.rulePanel.setBorder(new TitledBorder("Set Rule Priority"));
        this.ruleTable = new JTable(new HashTableModel(this.priority, new String[]{"Rule", "Priority"}));
        TableColumn priorityColumn = this.ruleTable.getColumn("Priority");
        priorityColumn.setMaxWidth(50);
        int hght = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight()) + 10;
        this.ruleTable.doLayout();
        this.ruleScrollPane = new JScrollPane(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(200, hght));
        this.rulePanel.add(this.ruleScrollPane);
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept entries and close dialog.");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCancelled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Reject entries and close dialog.");
        this.cancelButton.addActionListener(this);
        this.constrainBuild(this.buttonPanel, this.closeButton, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 10, 10, 5);
        this.constrainBuild(this.buttonPanel, this.cancelButton, 1, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 10);
        this.contentPane.add((Component)help, "North");
        this.contentPane.add((Component)this.rulePanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    private boolean accept() {
        Hashtable<Rule, Integer> table = ((HashTableModel)this.ruleTable.getModel()).getTable();
        Enumeration<Rule> e = table.keys();
        while (e.hasMoreElements()) {
            Rule key = e.nextElement();
            Integer value = table.get(key);
            if (value <= 0) {
                return false;
            }
            if (value.intValue() == key.getPriority()) continue;
            key.setPriority(value);
            this.changed = true;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            if (!this.accept()) {
                JOptionPane.showMessageDialog(this, "Please check priorities.\nOnly priority > 0 allowed.\nThe smalles priority is the highest.");
                return;
            }
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable<Rule, Integer> table;
        RulePriority rulePriority;

        public HashTableModel(Hashtable<Rule, Integer> table, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            this.table = table;
            Enumeration<Rule> keys = this.table.keys();
            while (keys.hasMoreElements()) {
                Rule key = keys.nextElement();
                Integer value = this.table.get(key);
                Vector<Object> tmpVector = new Vector<Object>();
                tmpVector.addElement(key);
                tmpVector.addElement(value);
                this.addRow(tmpVector);
            }
        }

        public HashTableModel(RulePriority priority, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            this.table = priority.getRulePriority();
            this.rulePriority = priority;
            Integer startPriority = priority.getStartPriority();
            Hashtable<Integer, HashSet<Rule>> invertedRulePriority = priority.invertPriority();
            OrderedSet<Integer> rulePrioritySet = new OrderedSet<Integer>(new IntComparator());
            Enumeration<Integer> en = invertedRulePriority.keys();
            while (en.hasMoreElements()) {
                rulePrioritySet.add(en.nextElement());
            }
            int i2 = 0;
            Integer currentPriority = startPriority;
            boolean nextPriorityExists = true;
            while (nextPriorityExists && currentPriority != null) {
                HashSet<Rule> rulesForPriority = invertedRulePriority.get(currentPriority);
                for (Rule rule : rulesForPriority) {
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(rule.getPriority());
                    this.addRow(tmpVector);
                }
                if (++i2 < rulePrioritySet.size()) {
                    currentPriority = (Integer)rulePrioritySet.get(i2);
                    continue;
                }
                nextPriorityExists = false;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                Integer i = Integer.valueOf((String)aValue);
                super.setValueAt(i, row, column);
                if (key instanceof Rule) {
                    this.table.put((Rule)key, i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public Hashtable<Rule, Integer> getTable() {
            return this.table;
        }
    }
}

