/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.trafo;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.gui.trafo.GraGraTransform;
import agg.ruleappl.RuleSequence;
import agg.xt_basis.ApplRuleSequencesGraTraImpl;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleSequencesGraTraImpl;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TransformRuleSequences
extends Thread
implements GraTraEventListener,
EditEventListener {
    private GraGraTransform gragraTransform;
    private GraTra gratra;
    private int msgGraTra;
    private GraTraEvent event;
    private EdGraGra gragra;
    private Rule currentRule;
    private Match currentMatch;
    private boolean inputParameterOK = false;
    private int steps;
    private boolean cancelled = false;
    private boolean stopped = false;
    private boolean showGraphAfterStep;
    private boolean gragraAnimated;

    public TransformRuleSequences(GraGraTransform transform, boolean useApplRuleSequence) {
        this.gragraTransform = transform;
        this.gratra = useApplRuleSequence ? new ApplRuleSequencesGraTraImpl() : new RuleSequencesGraTraImpl();
        this.gratra.enableWriteLogFile(true);
        this.gratra.addGraTraListener(this);
    }

    public void dispose() {
        this.gratra.removeGraTraListener(this);
        ((RuleSequencesGraTraImpl)this.gratra).dispose();
        this.currentMatch = null;
        this.currentRule = null;
        this.event = null;
        this.gragra = null;
    }

    public GraTra getGraTra() {
        return this.gratra;
    }

    public void setGraGra(EdGraGra gra, RuleSequence ruleSequence) {
        this.gragra = gra;
        this.gratra.setGraGra(this.gragra.getBasisGraGra());
        ((RuleSequencesGraTraImpl)this.gratra).setRuleSequence(ruleSequence);
        this.gratra.setHostGraph(this.gragra.getBasisGraGra().getGraph());
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.gratra.setCompletionStrategy(strat);
    }

    public void setParentFrame(JFrame f) {
    }

    public void setEachRuleToApplyOfRuleSequence(boolean b) {
        ((RuleSequencesGraTraImpl)this.gratra).setEachRuleToApply(b);
    }

    public void setShowGraphAfterStep(boolean show) {
        this.showGraphAfterStep = show;
    }

    @Override
    public void run() {
        this.steps = 0;
        this.cancelled = false;
        this.stopped = false;
        if (this.gratra.getHostGraph() != this.gragra.getBasisGraGra().getGraph()) {
            this.gratra.setHostGraph(this.gragra.getBasisGraGra().getGraph());
        }
        ((RuleSequencesGraTraImpl)this.gratra).setEachRuleToApply(this.gragra.getBasisGraGra().getGraTraOptions().contains("eachRuleToApply"));
        this.gragraAnimated = this.gragra.isAnimated();
        this.gratra.transform();
    }

    public void stopping() {
        this.stopped = true;
        this.gratra.stop();
    }

    @Override
    public void graTraEventOccurred(GraTraEvent e) {
        String ruleName = "";
        this.event = e;
        this.msgGraTra = e.getMessage();
        if (this.msgGraTra == 22) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 27, e.getRule()));
        } else if (this.msgGraTra == 8) {
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            if (this.gragraTransform.selectMatchObjectsEnabled()) {
                this.gragra.getGraph().updateAlongMorph(e.getMatch());
            }
            this.gragra.getGraph().unsetNodeNumberChanged();
            this.gragraTransform.fireTransform(new TransformEvent(this, 17, this.event.getMatch(), "  match of  <" + ruleName + ">  is valid"));
        } else if (this.msgGraTra == 2) {
            ++this.steps;
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            if (this.showGraphAfterStep) {
                this.gragra.getGraph().setXYofNewNode(this.gragra.getRule(this.currentRule), this.currentMatch, this.currentMatch.getCoMorphism());
                if (this.gragra.isRuleAnimated(this.currentRule)) {
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 25, this.currentMatch));
                } else if (!this.gragraAnimated) {
                    this.gragraTransform.getEditor().doStepLayoutProc();
                    if (this.gragraTransform.selectNewAfterStepEnabled()) {
                        this.gragra.getGraph().updateAlongMorph(this.event.getCoMatch(), this.currentRule);
                    }
                }
                this.disposeMatch();
            }
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 2, "  <" + ruleName + ">  is applied"));
        } else if (this.msgGraTra == 5) {
            this.gratra.stop();
            this.gragra.getGraph().clearMarks();
            if (!this.showGraphAfterStep) {
                this.gragraTransform.getEditor().doStandardLayoutProc();
            }
            if (this.steps == 0 && !this.cancelled || ((RuleSequencesGraTraImpl)this.gratra).isTrafoSequenceBroken()) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, e.getMessageText()));
            }
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 10, "  finished.  "));
            System.out.println("*** Rule sequence transformation - finished.");
        } else if (this.msgGraTra == 1) {
            this.inputParameterOK = false;
            String rulename = "";
            if (this.event.getMatch() != null) {
                rulename = this.event.getMatch().getRule().getName();
            } else if (this.event.getRule() != null) {
                rulename = this.event.getRule().getName();
            }
            int answer = this.parameterWarning(rulename);
            if (answer == 0) {
                if (this.event.getMatch() != null) {
                    this.currentMatch = this.event.getMatch();
                    this.currentRule = this.currentMatch.getRule();
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.currentMatch));
                } else if (this.event.getRule() != null) {
                    this.currentRule = this.event.getRule();
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.currentRule));
                }
                while (!this.inputParameterOK) {
                    try {
                        TransformRuleSequences.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } else if (answer == 1) {
                this.gratra.stopRule();
            } else if (answer == 2) {
                this.gratra.stop();
                this.cancelled = true;
                this.gragraTransform.fireTransform(new TransformEvent(this, 8));
            }
        } else if (this.msgGraTra == 6) {
            ruleName = this.event.getMessageText();
            String s = "Please check variables of the rule:  " + ruleName;
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, s));
        } else if (this.msgGraTra == 15 || this.msgGraTra == 9 || this.msgGraTra == 14 || this.msgGraTra == 10) {
            String s = e.getMessageText();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, s));
        } else if (this.msgGraTra != 7 && this.msgGraTra != 3 && this.msgGraTra == 11 && this.gragraTransform.consistencyCheckAfterGraphTrafoEnabled()) {
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 19, this.event.getMessageText()));
        }
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -3) {
            this.inputParameterOK = true;
        }
    }

    public boolean isSuccessful() {
        return this.steps != 0;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void disposeMatch() {
        EdRule r = this.gragra.getRule(this.currentRule);
        if (r != null) {
            r.updateRule();
        }
    }

    private int parameterWarning(String ruleName) {
        Object[] options = new Object[]{"Set", "Continue", "Cancel"};
        int answer = JOptionPane.showOptionDialog(null, "Input parameter of the rule  \" " + ruleName + " \"  not set!\nDo you want to set parameter?", "Warning", -1, 2, null, options, options[0]);
        return answer;
    }
}

