/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.attribute.impl.ContextView;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.gui.editor.GraphCanvas;
import agg.gui.editor.GraphMorphismEditorMouseAdapter;
import agg.gui.editor.GraphMorphismEditorMouseMotionAdapter;
import agg.gui.editor.GraphPanel;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.ruleappl.ObjectFlow;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class GraphMorphismEditor
extends JPanel {
    private final GraphMorphismEditorMouseAdapter mouseAdapter;
    private final GraphMorphismEditorMouseMotionAdapter mouseMotionAdapter;
    private final JFrame applFrame;
    final JPanel mainPanel;
    private final JLabel title;
    private final JSplitPane splitPane;
    private int dividerLocation;
    private final GraphPanel leftPanel;
    private final GraphPanel rightPanel;
    private GraphPanel activePanel;
    private EdGraph leftGraph;
    private EdGraph rightGraph;
    private OrdinaryMorphism morphism;
    private OrdinaryMorphism isoLeft;
    private OrdinaryMorphism isoRight;
    private ObjectFlow objFlow;
    GraphicsExportJPEG exportJPEG;
    private final JButton exportJPEGButton;

    public GraphMorphismEditor(JFrame parentFrame) {
        super(new BorderLayout());
        this.applFrame = parentFrame;
        this.mainPanel = this;
        this.mouseAdapter = new GraphMorphismEditorMouseAdapter(this);
        this.mouseMotionAdapter = new GraphMorphismEditorMouseMotionAdapter(this);
        this.leftPanel = new GraphPanel(this);
        this.leftPanel.setName("Source Graph");
        JPanel lPanel = new JPanel(new BorderLayout());
        lPanel.setPreferredSize(new Dimension(250, 150));
        lPanel.add((Component)this.leftPanel, "Center");
        this.rightPanel = new GraphPanel(this);
        this.rightPanel.setName("Target Graph");
        JPanel rPanel = new JPanel(new BorderLayout());
        rPanel.setPreferredSize(new Dimension(500, 150));
        rPanel.add((Component)this.rightPanel, "Center");
        this.splitPane = new JSplitPane(1, lPanel, rPanel);
        this.splitPane.setDividerSize(10);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.dividerLocation = 250;
        this.splitPane.setDividerLocation(this.dividerLocation);
        JPanel morphPanel = new JPanel(new BorderLayout());
        morphPanel.setPreferredSize(new Dimension(500, 150));
        this.title = new JLabel("    ");
        this.exportJPEGButton = this.createExportJPEGButton();
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)this.title, "Center");
        if (this.exportJPEGButton != null) {
            titlePanel.add((Component)this.exportJPEGButton, "East");
        }
        morphPanel.add((Component)titlePanel, "North");
        morphPanel.add((Component)this.splitPane, "Center");
        this.add((Component)morphPanel, "Center");
        this.leftPanel.getCanvas().addMouseListener(this.mouseAdapter);
        this.rightPanel.getCanvas().addMouseListener(this.mouseAdapter);
        this.leftPanel.getCanvas().addMouseMotionListener(this.mouseMotionAdapter);
        this.rightPanel.getCanvas().addMouseMotionListener(this.mouseMotionAdapter);
        String tooltipLeft = "Connect: click object left and object right.";
        String tooltipRight = "Disconnect: click object left and background right.";
        this.leftPanel.getCanvas().setToolTipText(tooltipLeft);
        this.rightPanel.getCanvas().setToolTipText(tooltipRight);
    }

    private JButton createExportJPEGButton() {
        URL url = ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/print.gif");
        if (url != null) {
            ImageIcon image = new ImageIcon(url);
            JButton b = new JButton(image);
            b.setToolTipText("Export JPEG");
            b.setMargin(new Insets(-5, 0, -5, 0));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GraphMorphismEditor.this.exportJPEG != null) {
                        GraphMorphismEditor.this.exportJPEG.save(GraphMorphismEditor.this.mainPanel);
                    }
                }
            });
            b.setEnabled(false);
            return b;
        }
        return null;
    }

    public void setMorphism(OrdinaryMorphism morph) {
        this.morphism = morph;
    }

    public void setIsoMorphismLeft(OrdinaryMorphism isoLeft) {
        this.isoLeft = isoLeft;
    }

    public void setIsoMorphismRight(OrdinaryMorphism isoRight) {
        this.isoRight = isoRight;
    }

    public void setObjectFlow(ObjectFlow objFlow) {
        this.objFlow = objFlow;
    }

    public ObjectFlow getObjectFlow() {
        return this.objFlow;
    }

    public boolean addMapping(GraphObject leftobj, GraphObject rightobj) {
        if (this.morphism.getInverseImage(rightobj).hasMoreElements()) {
            if (this.morphism.getInverseImage(rightobj).nextElement() != leftobj) {
                this.removeMapping(this.morphism.getInverseImage(rightobj).nextElement());
            } else {
                return true;
            }
        }
        boolean mapOK = false;
        if (leftobj != null && rightobj != null) {
            int currentlyAllowedMapping = ((ContextView)this.morphism.getAttrContext()).getAllowedMapping();
            try {
                if (leftobj.getType().isParentOf(rightobj.getType()) && !rightobj.isAttrMemConstantValDifferent(leftobj)) {
                    this.morphism.addMapping(leftobj, rightobj);
                    mapOK = true;
                } else if (leftobj.getType().isChildOf(rightobj.getType()) && !rightobj.isAttrMemConstantValDifferent(leftobj)) {
                    this.morphism.addChild2ParentMapping(leftobj, rightobj);
                    mapOK = true;
                }
            }
            catch (BadMappingException ex) {
                System.out.println("add mapping of object flow:  FAILED!  " + ex.getMessage());
                mapOK = false;
            }
            if (mapOK) {
                if (this.isoLeft != null && this.isoRight != null) {
                    this.objFlow.addMapping(this.isoLeft.getInverseImage(leftobj).nextElement(), this.isoRight.getInverseImage(rightobj).nextElement());
                } else {
                    this.objFlow.addMapping(leftobj, rightobj);
                }
                if (((ContextView)this.morphism.getAttrContext()).getAllowedMapping() != currentlyAllowedMapping) {
                    ((ContextView)this.morphism.getAttrContext()).changeAllowedMapping(currentlyAllowedMapping);
                }
            }
        }
        return mapOK;
    }

    private void removeNodeMapping(GraphObject obj) {
        Iterator<Arc> arcs = ((Node)obj).getOutgoingArcs();
        while (arcs.hasNext()) {
            this.removeArcMapping(arcs.next());
        }
        arcs = ((Node)obj).getIncomingArcs();
        while (arcs.hasNext()) {
            this.removeArcMapping(arcs.next());
        }
        this.morphism.removeMapping(obj);
        if (this.isoLeft != null && this.isoRight != null) {
            this.objFlow.removeMapping(this.isoLeft.getInverseImage(obj).nextElement());
        } else {
            this.objFlow.removeMapping(obj);
        }
    }

    private void removeArcMapping(GraphObject obj) {
        this.morphism.removeMapping(obj);
        if (this.isoLeft != null && this.isoRight != null) {
            this.objFlow.removeMapping(this.isoLeft.getInverseImage(obj).nextElement());
        } else {
            this.objFlow.removeMapping(obj);
        }
    }

    public boolean removeMapping(GraphObject obj) {
        if (obj != null) {
            if (obj.isNode()) {
                this.removeNodeMapping(obj);
            } else {
                this.removeArcMapping(obj);
            }
            return true;
        }
        return false;
    }

    public void removeAllMappings() {
        this.morphism.removeAllMappings();
        this.objFlow.getMapping().clear();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 200);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String str) {
        this.title.setText("  " + str);
    }

    public void setLeftTitle(String str) {
        this.leftPanel.setName("  " + str);
        this.leftPanel.getCanvas().setName("  " + str);
    }

    public void setRightTitle(String str) {
        this.rightPanel.setName("  " + str);
    }

    public GraphPanel getLeftPanel() {
        return this.leftPanel;
    }

    public GraphPanel getRightPanel() {
        return this.rightPanel;
    }

    public GraphPanel getActivePanel() {
        return this.activePanel;
    }

    public int getEditMode() {
        return this.leftPanel.getEditMode();
    }

    public EdGraph getLeftGraph() {
        return this.leftGraph;
    }

    public EdGraph getRightGraph() {
        return this.rightGraph;
    }

    public void setLeftGraph(EdGraph g) {
        this.leftGraph = g;
        if (this.leftGraph == null) {
            this.setLeftTitle("    ");
            this.leftPanel.setGraph(null);
            return;
        }
        this.leftPanel.setGraph(g, true);
    }

    public void setRightGraph(EdGraph g) {
        this.rightGraph = g;
        if (this.rightGraph == null) {
            this.setRightTitle("    ");
            this.rightPanel.setGraph(null);
            return;
        }
        this.rightPanel.setGraph(g, true);
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int i) {
        this.splitPane.setDividerLocation(i);
    }

    public void updateGraphs() {
        this.getLeftGraph().clearMarks();
        this.getRightGraph().clearMarks();
        EdNode enL = null;
        EdNode enR = null;
        EdArc eaL = null;
        EdArc eaR = null;
        if (this.morphism == null) {
            return;
        }
        Enumeration<GraphObject> domain = this.morphism.getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = this.morphism.getImage(bOrig);
            enL = this.getLeftGraph().findNode(bOrig);
            if (enL != null) {
                if (enL.isMorphismMarkEmpty()) {
                    enL.addMorphismMark(enL.getMyKey());
                }
                if ((enR = this.getRightGraph().findNode(bImage)) != null) {
                    enR.addMorphismMark(enL.getMorphismMark());
                } else {
                    enL.clearMorphismMark();
                }
            }
            if ((eaL = this.getLeftGraph().findArc(bOrig)) == null) continue;
            if (eaL.isMorphismMarkEmpty()) {
                eaL.addMorphismMark(eaL.getMyKey());
            }
            if ((eaR = this.getRightGraph().findArc(bImage)) != null) {
                eaR.addMorphismMark(eaL.getMorphismMark());
                continue;
            }
            eaL.clearMorphismMark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphics() {
        GraphMorphismEditor graphMorphismEditor = this;
        synchronized (graphMorphismEditor) {
            this.leftPanel.updateGraphics();
            this.rightPanel.updateGraphics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphics(boolean graphDimensionCheck) {
        GraphMorphismEditor graphMorphismEditor = this;
        synchronized (graphMorphismEditor) {
            this.leftPanel.updateGraphics(graphDimensionCheck);
            this.rightPanel.updateGraphics(graphDimensionCheck);
        }
    }

    public void clear() {
        this.setLeftGraph(null);
        this.setRightGraph(null);
        this.updateGraphics();
    }

    public void setEditMode(int mode) {
        switch (mode) {
            case 115: {
                this.mapModeProc();
                break;
            }
            case 116: {
                this.unmapModeProc();
                break;
            }
            case 9: {
                this.viewModeProc();
                break;
            }
        }
    }

    public int getMode() {
        return this.leftPanel.getEditMode();
    }

    public void setEditCursor(Cursor cur) {
        this.leftPanel.setEditCursor(cur);
        this.rightPanel.setEditCursor(cur);
    }

    private void mapModeProc() {
        this.setPanelEditMode(115);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void unmapModeProc() {
        this.setPanelEditMode(116);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
    }

    private void viewModeProc() {
        this.leftPanel.setEditMode(9);
        this.rightPanel.setEditMode(9);
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    public GraphPanel setActivePanel(Object src) {
        this.activePanel = src instanceof GraphCanvas ? ((GraphCanvas)src).getViewport() : null;
        return this.activePanel;
    }

    private void setPanelEditMode(int mode) {
        this.leftPanel.setEditMode(mode);
        this.rightPanel.setEditMode(mode);
    }
}

