/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterKind;

public class ParameterConfig {
    public static final int CLEAR = 0;
    public static final int NULL = 1;
    public static final int STRING = 2;
    public static final int BOOLEAN = 3;
    public static final int INT = 4;
    public static final int FLOAT = 5;
    public static final int LONG = 6;
    public static final int DOUBLE = 7;
    private static Map<Integer, String> supportedTypes;
    protected String name;
    protected Object value;
    protected int type;
    protected ParameterKind kind;

    public static Map<Integer, String> getSupportedTypes() {
        if (supportedTypes == null) {
            supportedTypes = new HashMap<Integer, String>();
            supportedTypes.put(0, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Clear"));
            supportedTypes.put(1, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Null"));
            supportedTypes.put(2, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_String"));
            supportedTypes.put(3, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Boolean"));
            supportedTypes.put(4, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Int"));
            supportedTypes.put(6, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Long"));
            supportedTypes.put(5, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Float"));
            supportedTypes.put(7, HenshinInterpreterUIPlugin.LL("_UI_ParameterType_Double"));
        }
        return supportedTypes;
    }

    public ParameterConfig() {
    }

    public ParameterConfig(Parameter param) {
        this.name = param.getName();
        if (param.getType() instanceof EDataType && param.getType().getEPackage() == EcorePackage.eINSTANCE) {
            switch (param.getType().getClassifierID()) {
                case 50: {
                    this.type = 2;
                    break;
                }
                case 22: {
                    this.type = 3;
                    break;
                }
                case 39: {
                    this.type = 4;
                    break;
                }
                case 43: {
                    this.type = 6;
                    break;
                }
                case 37: {
                    this.type = 5;
                    break;
                }
                case 31: {
                    this.type = 7;
                }
            }
        }
        this.kind = param.getKind();
        this.initValue();
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeLabel() {
        return ParameterConfig.getSupportedTypes().get(this.type);
    }

    public ParameterKind getKind() {
        return this.kind;
    }

    public boolean isClear() {
        return this.type == 0;
    }

    public void setType(int type) {
        if (!ParameterConfig.getSupportedTypes().containsKey(type)) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not a valid type!");
        }
        if (type == this.type) {
            return;
        }
        this.type = type;
        this.initValue();
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected void initValue() {
        switch (this.getType()) {
            case 1: {
                this.setValue(null);
                return;
            }
            case 2: {
                this.setValue("");
                return;
            }
            case 3: {
                this.setValue(false);
                return;
            }
            case 7: {
                this.setValue(0.0);
                return;
            }
            case 6: {
                this.setValue(0L);
                return;
            }
            case 4: {
                this.setValue(0);
                return;
            }
            case 5: {
                this.setValue(Float.valueOf(0.0f));
                return;
            }
        }
    }
}

