/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.bank;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class BankExample {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/bank";

    public static void run(String path, boolean saveResult) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("bank.henshin", false);
        EGraphImpl graph = new EGraphImpl(resourceSet.getResource("example-bank.xmi"));
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl createAccountApp = new UnitApplicationImpl((Engine)engine);
        createAccountApp.setEGraph((EGraph)graph);
        createAccountApp.setUnit(module.getUnit("createAccount"));
        createAccountApp.setParameterValue("client", (Object)"Alice");
        createAccountApp.setParameterValue("accountId", (Object)5);
        if (!createAccountApp.execute(null)) {
            throw new RuntimeException("Error creating account for Alice");
        }
        UnitApplicationImpl transferMoneyApp = new UnitApplicationImpl((Engine)engine);
        transferMoneyApp.setEGraph((EGraph)graph);
        transferMoneyApp.setUnit(module.getUnit("transferMoney"));
        transferMoneyApp.setParameterValue("client", (Object)"Alice");
        transferMoneyApp.setParameterValue("fromId", (Object)1);
        transferMoneyApp.setParameterValue("toId", (Object)2);
        transferMoneyApp.setParameterValue("amount", (Object)50.0);
        if (!transferMoneyApp.execute(null)) {
            throw new RuntimeException("Error transferring money");
        }
        UnitApplicationImpl deleteAccountsApp = new UnitApplicationImpl((Engine)engine);
        deleteAccountsApp.setEGraph((EGraph)graph);
        deleteAccountsApp.setUnit(module.getUnit("deleteAllAccounts"));
        deleteAccountsApp.setParameterValue("client", (Object)"Charles");
        if (!deleteAccountsApp.execute(null)) {
            throw new RuntimeException("Error deleting Charles' accounts");
        }
        if (saveResult) {
            resourceSet.saveEObject((EObject)graph.getRoots().get(0), "example-result.xmi");
        }
    }

    public static void main(String[] args) {
        BankExample.run(PATH, true);
    }
}

