/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RuleEditHelper;
import org.eclipse.emf.henshin.diagram.edit.policies.HenshinBaseItemSemanticEditPolicy;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinModelCleaner;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;

public class EdgeCreateCommand
extends EditElementCommand {
    public static final String TYPE_PARAMETER_KEY = "henshin_edge_type";
    private final EObject source;
    private final EObject target;
    private final Graph container;

    public EdgeCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = EdgeCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecuteGen() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Node)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Node)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return HenshinBaseItemSemanticEditPolicy.getLinkConstraints().canCreateEdge_4001(this.getContainer(), this.getSource(), this.getTarget());
    }

    public boolean canExecute() {
        if (!this.canExecuteGen()) {
            return false;
        }
        if (this.source != null && this.target != null) {
            EReference type = (EReference)this.getRequest().getParameter(TYPE_PARAMETER_KEY);
            Rule rule = this.getSource().getGraph().getRule();
            return rule.canCreateEdge(this.getSource(), this.getTarget(), type);
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        EReference type = (EReference)this.getRequest().getParameter(TYPE_PARAMETER_KEY);
        Rule rule = this.getSource().getGraph().getRule();
        Edge edge = rule.createEdge(this.getSource(), this.getTarget(), type);
        if (type.isContainment() || type.isContainer()) {
            View ruleView = RuleEditHelper.findRuleView(rule);
            RootObjectEditHelper.updateRootContainment(ruleView, this.getSource());
            RootObjectEditHelper.updateRootContainment(ruleView, this.getTarget());
        }
        HenshinModelCleaner.completeMultiRules((Rule)rule.getRootRule());
        HenshinModelCleaner.cleanRule((Rule)rule.getRootRule());
        this.doConfigure(edge, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)edge);
        return CommandResult.newOKCommandResult((Object)edge);
    }

    protected void doConfigure(Edge newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected Node getSource() {
        return (Node)this.source;
    }

    protected Node getTarget() {
        return (Node)this.target;
    }

    public Graph getContainer() {
        return this.container;
    }

    private static Graph deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Graph) {
                return (Graph)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

