/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrInstance;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import java.util.List;
import java.util.Vector;

public class UndirectedArc
extends Arc {
    protected String keyStr2 = null;

    public UndirectedArc(AttrInstance attr, Type type, GraphObject src, GraphObject tar, Graph context) {
        super(attr, type, src, tar, context);
        this.directed = false;
    }

    protected UndirectedArc(Type type, GraphObject src, GraphObject tar, Graph context) {
        super(type, src, tar, context);
        this.directed = false;
    }

    protected UndirectedArc(Arc orig, GraphObject src, GraphObject tar, Graph context) {
        super(orig.getType(), src, tar, context);
        this.directed = false;
    }

    @Override
    protected void addToSrcTar(GraphObject src, GraphObject tar) {
        if (src != null && tar != null) {
            ((Node)src).addOut(this);
            ((Node)tar).addOut(this);
        }
    }

    @Override
    public void dispose() {
        ((Node)this.itsTarget).removeOut(this);
        ((Node)this.itsSource).removeOut(this);
        super.dispose();
    }

    @Override
    public void setDirected(boolean b) {
        this.directed = false;
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    public String convertToInverseKey() {
        if (this.keyStr2 == null) {
            this.keyStr2 = this.itsTarget.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsSource.getType().convertToKey());
        }
        return this.keyStr2;
    }

    public List<String> convertToInverseKeyParentExtended() {
        Vector<String> list = new Vector<String>();
        Vector<Type> mySrcParents = this.getSource().getType().getAllParents();
        Vector<Type> myTarParents = this.getTarget().getType().getAllParents();
        int i = 0;
        while (i < mySrcParents.size()) {
            int j = 0;
            while (j < myTarParents.size()) {
                String keystr = String.valueOf(myTarParents.get(i).convertToKey()) + this.getType().convertToKey() + mySrcParents.get(j).convertToKey();
                list.add(keystr);
                ++j;
            }
            ++i;
        }
        return list;
    }

    @Override
    public boolean compareTo(GraphObject o) {
        if (o == null || !o.isArc()) {
            return false;
        }
        Arc a = (Arc)o;
        if (!this.itsType.isParentOf(a.getType())) {
            return false;
        }
        if (!(this.itsAttr == null && a.getAttribute() == null || this.attrExists() && a.attrExists() && this.itsAttr.compareTo(a.getAttribute()))) {
            return false;
        }
        if (!this.compareSrcTarTo(a)) {
            return false;
        }
        return this.compareMultiplicityTo(a);
    }

    @Override
    protected boolean compareSrcTarTo(Arc a) {
        return ((Node)this.getSource()).compareTo(a.getSource()) && ((Node)this.getTarget()).compareTo(a.getTarget()) || ((Node)this.getSource()).compareTo(a.getTarget()) && ((Node)this.getTarget()).compareTo(a.getSource());
    }

    @Override
    protected boolean compareMultiplicityTo(Arc a) {
        if (this.itsContext.isTypeGraph()) {
            int a_minmax;
            Type srcType = this.getSource().getType();
            Type tarType = this.getTarget().getType();
            Type a_srcType = a.getSource().getType();
            Type a_tarType = a.getTarget().getType();
            int minmax = this.itsType.getSourceMin(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getSourceMin(a_srcType, a_tarType))) {
                return false;
            }
            minmax = this.itsType.getTargetMin(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getTargetMin(a_srcType, a_tarType))) {
                return false;
            }
            minmax = this.itsType.getSourceMax(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getSourceMax(a_srcType, a_tarType))) {
                return false;
            }
            minmax = this.itsType.getTargetMax(srcType, tarType);
            if (minmax != (a_minmax = a.getType().getTargetMax(a_srcType, a_tarType))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setSource(Node n) {
        ((Node)this.itsSource).removeOut(this);
        this.itsSource = n;
        n.addOut(this);
        this.keyStr = this.itsSource.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsTarget.getType().convertToKey());
        this.keyStr2 = this.itsTarget.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsSource.getType().convertToKey());
    }

    @Override
    public void setTarget(Node n) {
        ((Node)this.itsTarget).removeIn(this);
        this.itsTarget = n;
        n.addOut(this);
        this.keyStr = this.itsSource.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsTarget.getType().convertToKey());
        this.keyStr2 = this.itsTarget.getType().convertToKey().concat(this.itsType.convertToKey()).concat(this.itsSource.getType().convertToKey());
    }

    @Override
    public String toString() {
        String tTrg;
        String tSrc;
        String result = "";
        String t = this.itsType.getStringRepr();
        if (t.equals("")) {
            t = "[unnamed]";
        }
        if ((tSrc = this.getSource().getType().getStringRepr()).equals("")) {
            tSrc = "[unnamed]";
        }
        if ((tTrg = this.getTarget().getType().getStringRepr()).equals("")) {
            tTrg = "[unnamed]";
        }
        result = " ([" + this.hashCode() + "] " + "Arc: " + tSrc + "---" + t + "---" + tTrg + ") ";
        if (this.itsAttr != null) {
            result = String.valueOf(result) + this.itsAttr.toString();
        }
        return result;
    }
}

