/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.cons.AtomConstraint;
import agg.xt_basis.GraGra;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RuleModel
implements TreeModel {
    private Vector<TreeModelListener> treeModelListeners = new Vector();
    private TreeData rootNode;
    private GraGra grammar;
    private boolean withNACs;

    public RuleModel(GraGra gragra, boolean atomics, boolean nacs) {
        this.rootNode = gragra != null ? new TreeData(String.valueOf(atomics ? "Atomics of" : "Rules of ") + gragra.getName()) : new TreeData("--EMPTY--");
        this.grammar = gragra;
        this.withNACs = nacs;
    }

    private Vector<TreeData> getRules() {
        Vector<TreeData> tmpVector = new Vector<TreeData>();
        if (this.grammar != null) {
            Iterator<Rule> en = this.grammar.getListOfRules().iterator();
            while (en.hasNext()) {
                tmpVector.add(new TreeData(en.next()));
            }
        }
        return tmpVector;
    }

    private Vector<TreeData> getNACs(Rule r) {
        Vector<TreeData> tmpVector = new Vector<TreeData>();
        List<OrdinaryMorphism> nacs = r.getNACsList();
        int l = 0;
        while (l < nacs.size()) {
            tmpVector.addElement(new TreeData(nacs.get(l)));
            ++l;
        }
        return tmpVector;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (!this.treeModelListeners.contains(l)) {
            this.treeModelListeners.addElement(l);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.getRoot()) {
            return this.getRules().elementAt(index);
        }
        TreeData td = (TreeData)parent;
        OrdinaryMorphism morph = td.getData();
        if (morph != null && this.withNACs && morph instanceof Rule) {
            return this.getNACs((Rule)morph).elementAt(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.getRoot()) {
            return this.getRules().size();
        }
        TreeData td = (TreeData)parent;
        OrdinaryMorphism morph = td.getData();
        if (morph != null && this.withNACs && morph instanceof Rule) {
            int result = this.getNACs((Rule)morph).size();
            return result;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.getRoot()) {
            return this.getRules().indexOf(child);
        }
        TreeData td = (TreeData)parent;
        OrdinaryMorphism morph = td.getData();
        if (morph != null && this.withNACs && morph instanceof Rule) {
            return this.getNACs((Rule)morph).indexOf(child);
        }
        return 0;
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.getRoot()) {
            return false;
        }
        return this.getChildCount(node) == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("*** valueForPathChanged : " + path + " --> " + newValue);
    }

    public class TreeData
    extends DefaultMutableTreeNode {
        boolean atomic;
        boolean rule;
        boolean nac;
        boolean root;

        TreeData(Object o) {
            super(o);
            this.rule = false;
            this.nac = false;
            this.root = false;
            if (o instanceof String) {
                this.root = true;
            } else if (o instanceof AtomConstraint) {
                this.atomic = true;
            } else if (o instanceof Rule) {
                this.rule = true;
            } else if (o instanceof OrdinaryMorphism) {
                this.nac = true;
            }
        }

        public OrdinaryMorphism getData() {
            Object tmpObj = this.getUserObject();
            if (this.isRule() || this.isNAC() || this.isAtomic()) {
                return (OrdinaryMorphism)tmpObj;
            }
            return null;
        }

        @Override
        public String toString() {
            Object tmpObj = this.getUserObject();
            if (this.isRule() || this.isNAC() || this.isAtomic()) {
                return ((OrdinaryMorphism)tmpObj).getName();
            }
            return tmpObj.toString();
        }

        public boolean isAtomic() {
            return this.atomic;
        }

        public boolean isNAC() {
            return this.nac;
        }

        public boolean isRule() {
            return this.rule;
        }

        @Override
        public boolean isRoot() {
            return this.root;
        }
    }
}

