/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstanceMember;
import agg.attribute.AttrTuple;
import agg.attribute.AttrTypeMember;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.Member;
import agg.attribute.impl.NoSuchVariableException;
import agg.attribute.impl.ValueTuple;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.util.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ValueMember
extends Member
implements AttrInstanceMember,
AttrMsgCode {
    public static final String EMPTY_VALUE_SYMBOL = "";
    protected DeclMember decl;
    protected ValueTuple tuple;
    protected HandlerExpr expression;
    protected String expressionText;
    protected Object expressionObject;
    protected transient Exception currentException;
    protected transient String errorMsg;
    protected boolean isTransient;

    public ValueMember(ValueTuple tuple, DeclMember decl) {
        this.tuple = tuple;
        this.decl = decl;
        this.rawSetExpr(null);
        this.checkValidity();
        this.errorMsg = EMPTY_VALUE_SYMBOL;
        this.isTransient = false;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isValid() {
        return this.currentException == null;
    }

    @Override
    public String getValidityReport() {
        if (this.isValid() && this.getDeclaration().isValid()) {
            return null;
        }
        String report = this.getDeclaration().getValidityReport();
        if (this.isValid()) {
            return report;
        }
        if (report == null) {
            report = EMPTY_VALUE_SYMBOL;
        }
        if (this.currentException != null) {
            report = String.valueOf(report) + this.currentException.getMessage();
        }
        return report;
    }

    @Override
    public AttrTypeMember getDeclaration() {
        return this.getDecl();
    }

    @Override
    public Object getExprAsObject() {
        if (this.getExpr() != null) {
            return this.getExpr().getValue();
        }
        return null;
    }

    @Override
    public HandlerExpr getExpr() {
        return this.rawGetExpr();
    }

    @Override
    public String getExprAsText() {
        if (this.getExpr() == null) {
            return this.expressionText;
        }
        return this.getExpr().toString();
    }

    @Override
    public void setExpr(HandlerExpr expr) {
        if (expr == null) {
            this.expressionText = null;
            this.expressionObject = null;
            this.expression = null;
            this.errorMsg = EMPTY_VALUE_SYMBOL;
            this.currentException = null;
        } else {
            this.setCheckedExpr(expr);
        }
        this.fireChanged(70);
    }

    @Override
    public void setExprAsObject(Object obj) {
        this.rawSetExprAsObject(obj);
        this.fireChanged(70);
    }

    protected void rawSetExprAsObject(Object obj) {
        try {
            this.expressionText = null;
            this.expressionObject = obj;
            if (this.getType() != null && obj != null) {
                this.expression = this.getHandler().newHandlerValue(this.getType(), obj);
            }
            this.checkValidity();
        }
        catch (AttrHandlerException ex) {
            this.currentException = ex;
        }
    }

    public void setExprAsText(String exprText, boolean initialize) throws AttrImplException {
        this.setExprAsText(exprText);
        if (initialize && this.getExpr() != null && this.getExpr().isComplex() && exprText.indexOf("new ") == 0) {
            this.apply(this.getExpr());
        }
    }

    @Override
    public void setExprAsText(String exprText) {
        ContextView context;
        String s = exprText;
        if (exprText == null) {
            s = new String();
        }
        if (s.length() == 0 && ((context = this.getContext()) == null || context.doesAllowEmptyValues())) {
            this.setExpr(null);
            return;
        }
        if (s.length() != 0 && s.charAt(0) == '(') {
            s.charAt(0);
            int i = 1;
            while (i < s.length()) {
                if (s.charAt(i) == ')') {
                    if (i == s.length() - 1) {
                        String ss;
                        s = ss = s.substring(1, s.length() - 1);
                        i = s.length() + 1;
                    } else {
                        i = s.length() + 1;
                    }
                }
                ++i;
            }
        }
        if (!s.equals(exprText)) {
            this.rawSetExprAsText(s);
        } else {
            this.rawSetExprAsText(exprText);
        }
        if (this.currentException == null) {
            this.fireChanged(70);
        }
    }

    protected void rawSetExprAsText(String exprText) {
        String lastExpressionText = this.expressionText;
        HandlerExpr lastExpression = this.expression;
        Object lastExpressionObject = this.expressionObject;
        this.currentException = null;
        try {
            this.expressionText = exprText;
            this.expressionObject = null;
            HandlerExpr test = null;
            if (exprText != null && exprText.length() != 0) {
                test = this.getHandler().newHandlerExpr(this.getType(), exprText);
                this.checkValidity(test);
                if (this.currentException == null) {
                    this.expression = test;
                    this.expressionText = exprText;
                } else {
                    this.fireChanged(80);
                    this.expression = test;
                    return;
                }
            }
            this.checkValidity();
            if (this.currentException == null && this.getContext().getAllowedMapping() == 2 && test != null) {
                this.apply(test);
                if (this.currentException != null) {
                    this.expression = null;
                    this.expressionText = EMPTY_VALUE_SYMBOL;
                    this.expressionObject = null;
                    this.fireChanged(80);
                }
            }
        }
        catch (AttrImplException aiex) {
            this.currentException = aiex;
            this.errorMsg = aiex.getMessage();
            this.expressionText = lastExpressionText;
            this.expressionObject = lastExpressionObject;
            this.expression = lastExpression;
        }
        catch (AttrHandlerException ex) {
            this.currentException = ex;
            this.errorMsg = ex.getMessage();
            this.expressionText = lastExpressionText;
            this.expressionObject = lastExpressionObject;
            this.expression = lastExpression;
        }
    }

    @Override
    public void setExprAsEvaluatedText(String exprText) {
        try {
            this.expressionText = exprText;
            this.expressionObject = null;
            this.expression = this.getHandler().newHandlerExpr(this.getType(), exprText);
            this.expression.evaluate(this.getContext());
            this.expressionText = null;
            this.expressionObject = this.expression.getValue();
            this.checkValidity();
            this.fireChanged(70);
        }
        catch (AttrHandlerException ex) {
            this.currentException = ex;
            this.expression = null;
        }
    }

    public void trySetExprAsText(String exprText) throws AttrHandlerException {
        String newText = AttrTupleManager.getDefaultManager().getStaticMethodCall(exprText);
        HandlerExpr exprssn = this.getHandler().newHandlerExpr(this.getDeclaration().getType(), newText);
        this.checkValidity(exprssn);
        if (!this.isValid()) {
            if (this.currentException != null) {
                throw new AttrHandlerException(this.currentException.getLocalizedMessage());
            }
            throw new AttrHandlerException("Not valid expression: " + exprText);
        }
        this.setExprAsText(newText);
    }

    public void typeChanged() {
        boolean prevValidity = this.isValid();
        this.expression = null;
        try {
            if (this.expressionText != null) {
                this.expression = this.getHandler().newHandlerExpr(this.getType(), this.expressionText);
            } else if (this.expressionObject != null) {
                this.expression = this.getHandler().newHandlerValue(this.getType(), this.expressionObject);
            }
        }
        catch (Exception ex) {
            this.currentException = ex;
            this.expressionText = null;
            this.expressionObject = null;
        }
        this.checkValidity();
        if (prevValidity != this.isValid()) {
            this.fireChanged(80);
        }
    }

    public boolean isEmpty() {
        return this.getExpr() == null;
    }

    @Override
    public boolean isSet() {
        return this.getExpr() != null;
    }

    protected void apply(HandlerExpr expr) {
        if (expr != null && !expr.toString().equals("null")) {
            HandlerExpr oldExpr = this.getExpr();
            this.expression = expr.getCopy();
            HandlerExpr exp = null;
            try {
                exp = this.getExpr();
                if (exp != null) {
                    exp.evaluate(this.getContext());
                    if (exp.getValue() == null) {
                        this.expressionText = EMPTY_VALUE_SYMBOL;
                        this.expression = null;
                        this.expressionObject = null;
                    } else {
                        this.fireChanged(70);
                    }
                }
            }
            catch (AttrHandlerException ex1) {
                this.currentException = ex1;
                this.expression = oldExpr;
                throw new AttrImplException(8, String.valueOf(ex1.getMessage()) + "\n" + expr + "  don't match to  " + this.expression);
            }
            catch (Exception ex) {
                this.currentException = ex;
                this.expression = oldExpr;
                throw new AttrImplException(8, String.valueOf(ex.getMessage()) + "\n" + expr + "  don't match to  " + this.expression);
            }
        }
    }

    public void apply(ValueMember rightSide, AttrContext context) {
        if (rightSide != null && rightSide.getExpr() != null) {
            HandlerExpr oldExpr = this.getExpr();
            this.expression = rightSide.getExpr().getCopy();
            HandlerExpr exp = null;
            try {
                exp = this.getExpr();
                if (exp != null) {
                    exp.evaluate(context);
                    if (exp.getValue() == null) {
                        this.setExprAsText(exp.getString());
                    } else {
                        this.fireChanged(70);
                    }
                }
            }
            catch (AttrHandlerException ex1) {
                this.expression = oldExpr;
                throw new AttrImplException(8, String.valueOf(ex1.getMessage()) + "\n" + rightSide.getExpr() + "  don't match to  " + this.expression);
            }
            catch (Exception ex) {
                this.expression = oldExpr;
                throw new AttrImplException(8, String.valueOf(ex.getMessage()) + "\n" + rightSide.getExpr() + "  don't match to  " + this.expression);
            }
        }
    }

    public void apply(ValueMember rightSide, AttrContext context, boolean allowVariableWithoutValue) {
        this.apply(rightSide, context, allowVariableWithoutValue, false);
    }

    public void apply(ValueMember rightSide, AttrContext context, boolean allowVarWithoutValue, boolean equalVarName) {
        if (!allowVarWithoutValue) {
            this.apply(rightSide, context);
            return;
        }
        if (rightSide != null && rightSide.getExpr() != null) {
            if (equalVarName && this.getExpr() != null && this.getExpr().isVariable() && rightSide.getExpr().isVariable()) {
                if (this.getExprAsText().equals(rightSide.getExprAsText())) {
                    return;
                }
                if (!this.isTransient && !rightSide.isTransient()) {
                    throw new AttrImplException(8, rightSide.getExpr() + "  don't match to  " + this.expression);
                }
            }
            if (rightSide.getExpr().isVariable() && (rightSide.isTransient() || context.getExpr(rightSide.getExprAsText()) != null)) {
                if (this.getExpr() == null) {
                    this.expression = rightSide.getExpr().getCopy();
                    this.isTransient = rightSide.isTransient();
                }
                return;
            }
            if (this.getExpr() == null || this.getExpr().isConstant() && rightSide.getExpr().isConstant() || this.isTransient) {
                HandlerExpr oldExpr = this.getExpr();
                HandlerExpr exp = null;
                this.expression = rightSide.getExpr().getCopy();
                try {
                    exp = this.getExpr();
                    if (exp != null) {
                        exp.evaluate(context);
                        if (exp.getValue() == null) {
                            this.setExprAsText(exp.getString());
                            if (!this.isTransient) {
                                this.setTransient(rightSide.isTransient());
                            }
                        } else if (exp.getValue() != null) {
                            this.fireChanged(70);
                        }
                    }
                }
                catch (AttrHandlerException ex1) {
                    if (exp != null && exp.getValue() == null) {
                        this.setExprAsText(exp.getString());
                        if (!this.isTransient) {
                            this.setTransient(rightSide.isTransient());
                        }
                    }
                }
                catch (Exception ex) {
                    if (exp != null && exp.getValue() == null) {
                        this.setExprAsText(exp.getString());
                        if (!this.isTransient) {
                            this.setTransient(rightSide.isTransient());
                        }
                    }
                    this.expression = oldExpr;
                }
            }
        }
    }

    public boolean canMatchTo(ValueMember target, ContextView context) {
        this.errorMsg = EMPTY_VALUE_SYMBOL;
        HandlerExpr tar = null;
        if (target != null) {
            tar = target.getExpr();
        }
        if (tar != null) {
            HandlerExpr src = this.getExpr();
            if (src == null) {
                return true;
            }
            boolean result = false;
            result = result || tar.isVariable();
            boolean bl = result = result || tar.isComplex();
            if (!result) {
                boolean r4 = true;
                boolean r3 = !src.isVariable();
                boolean bl2 = r3 = r3 || context.canSetValue(src.toString(), target);
                if (r3 && !(r4 = src.isUnifiableWith(tar, context))) {
                    if (src.getString().equals(tar.getString()) && context.isVariableContext()) {
                        r4 = true;
                    } else if (src.isConstant() && tar.isConstant() && context.isIgnoreConstContext()) {
                        r4 = true;
                    }
                }
                boolean r2 = r3 && r4;
                boolean bl3 = result = result || r2;
            }
            if (result) {
                return true;
            }
            this.errorMsg = this.errorMsg.concat(context.getErrorMsg());
            return false;
        }
        if (context.getAllowedMapping() == 1) {
            this.errorMsg = "Source attribute: <" + this.getName() + "> cannot match to its target attribute because it is not set!";
            return false;
        }
        return true;
    }

    public String matchTo(ValueMember target, ContextView context) {
        HandlerExpr srcExpr = this.getExpr();
        String varName = null;
        if (srcExpr != null && srcExpr.isVariable()) {
            varName = srcExpr.toString();
            try {
                context.setValue(varName, target);
            }
            catch (NoSuchVariableException noSuchVariableException) {
                // empty catch block
            }
        }
        return varName;
    }

    public void copy(ValueMember fromInstance) {
        HandlerExpr srcExpr = fromInstance.getExpr();
        HandlerExpr tarExpr = null;
        if (srcExpr != null) {
            tarExpr = srcExpr.getCopy();
            if (tarExpr != null) {
                this.expression = tarExpr;
                this.expressionText = fromInstance.expressionText != null ? fromInstance.expressionText.toString() : null;
                this.expressionObject = this.expression.getValue();
                this.checkValidity();
                this.setTransient(fromInstance.isTransient());
                this.fireChanged(70);
            }
        } else {
            this.setExpr(null);
        }
    }

    public boolean equals(ValueMember testObject) {
        if (this.getName().equals("HASHCODE")) {
            return true;
        }
        if (testObject == null) {
            return false;
        }
        if (this.getExpr() != null) {
            return this.getExpr().equals(testObject.getExpr());
        }
        if (this.expressionText != null) {
            return this.expressionText.equals(testObject.expressionText);
        }
        if (this.expressionObject != null) {
            return this.expressionObject.equals(testObject.expressionObject);
        }
        return testObject.expressionText == null && testObject.expressionObject == null && testObject.getExpr() == null;
    }

    public boolean compareTo(ValueMember member) {
        if (this.getName().equals("HASHCODE")) {
            return true;
        }
        if (member == null) {
            return false;
        }
        if (this.getExpr() != null) {
            if (member.getExpr() != null) {
                return this.getExpr().toString().equals(member.getExpr().toString());
            }
            return false;
        }
        if (this.expressionText != null) {
            return this.expressionText.equals(member.expressionText);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.getExpr() != null) {
            return this.getExpr().toString();
        }
        if (this.expressionText != null) {
            return this.expressionText;
        }
        if (this.expressionObject != null) {
            return this.expressionObject.toString();
        }
        return EMPTY_VALUE_SYMBOL;
    }

    @Override
    public AttrTuple getHoldingTuple() {
        return this.tuple;
    }

    protected ValueTuple getTuple() {
        return this.tuple;
    }

    protected ContextView getContext() {
        return (ContextView)this.getTuple().getContext();
    }

    protected DeclMember getDecl() {
        return this.decl;
    }

    public AttrHandler getHandler() {
        return this.getDecl().getHandler();
    }

    protected HandlerType getType() {
        return this.getDecl().getType();
    }

    @Override
    public String getName() {
        return this.getDecl().getName();
    }

    public Vector<String> getAllVariableNamesOfExpression() {
        Vector<String> resultVector = new Vector<String>();
        if (this.getExpr() != null) {
            this.getExpr().getAllVariables(resultVector);
        }
        return resultVector;
    }

    public Vector<Node> getChildrenOfExpression() {
        Vector<Node> resultVector = new Vector<Node>();
        if (this.getExpr() != null && this.getExpr().getAST() != null) {
            SimpleNode node = (SimpleNode)this.getExpr().getAST();
            int i = 0;
            while (i < node.jjtGetNumChildren()) {
                resultVector.addElement(node.jjtGetChild(i));
                ++i;
            }
        }
        return resultVector;
    }

    protected HandlerExpr rawGetExpr() {
        return this.expression;
    }

    protected void rawSetExpr(HandlerExpr expr) {
        this.expression = expr;
    }

    protected void setCheckedExpr(HandlerExpr expr) {
        this.rawSetExpr(expr);
        this.checkValidity();
    }

    public void checkValidity() {
        try {
            this.checkInContext(this.getExpr(), this.getContext());
            this.currentException = null;
        }
        catch (Exception ex) {
            this.currentException = ex;
            this.errorMsg = ex.getMessage();
        }
    }

    public void checkValidity(HandlerExpr hExpr) {
        try {
            this.checkInContext(hExpr, this.getContext());
            this.errorMsg = EMPTY_VALUE_SYMBOL;
            this.currentException = null;
        }
        catch (Exception ex) {
            this.currentException = ex;
            this.errorMsg = ex.getMessage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkInContext(HandlerExpr hExpr, AttrContext ctx) {
        ContextView context = (ContextView)ctx;
        if (hExpr == null) {
            if (context != null && context.doesAllowEmptyValues()) return;
            throw new AttrImplException(13);
        }
        String exprText = hExpr.toString();
        AttrHandler handler = this.getHandler();
        HandlerType type = this.getType();
        if (context == null) {
            if (!hExpr.isConstant()) {
                this.errorMsg = "Expression must be a constant: ".concat(hExpr.toString());
                this.currentException = new AttrImplException(4, this.errorMsg);
                throw (AttrImplException)this.currentException;
            }
        } else if (!context.doesAllowComplexExpressions()) {
            if (hExpr.isComplex()) {
                this.errorMsg = "Complex expression is not allowed: ".concat(hExpr.toString());
                this.currentException = new AttrImplException(5, this.errorMsg);
                throw (AttrImplException)this.currentException;
            }
        } else {
            context.getAllowedMapping();
        }
        if (hExpr.isConstant()) {
            try {
                hExpr.checkConstant(context);
                return;
            }
            catch (AttrHandlerException ex) {
                this.errorMsg = ex.getMessage();
                this.currentException = ex;
                throw new AttrImplException(7, this.errorMsg);
            }
        }
        if (hExpr.isVariable()) {
            if (context == null) return;
            if (context.isDeclared(exprText)) {
                try {
                    hExpr.check(context);
                    return;
                }
                catch (AttrHandlerException ex) {
                    this.errorMsg = ex.getMessage();
                    this.currentException = ex;
                    throw new AttrImplException(7, ex.getMessage());
                }
            }
            if (context.doesAllowNewVariables()) {
                context.addDecl(handler, type.toString(), exprText);
                return;
            }
            this.errorMsg = "undeclared variable found: ".concat(hExpr.toString());
            this.currentException = new AttrImplException(6, this.errorMsg);
            throw (AttrImplException)this.currentException;
        }
        if (!hExpr.isComplex()) return;
        if (context.isVariableContext() && this.expressionObject == null) {
            return;
        }
        try {
            hExpr.check(context);
            return;
        }
        catch (AttrHandlerException ex) {
            this.errorMsg = ex.getMessage();
            this.currentException = ex;
            throw new AttrImplException(7, this.errorMsg);
        }
    }

    public String getAttrHandlerExceptionMsg() {
        if (this.currentException != null) {
            return this.currentException.getMessage();
        }
        return EMPTY_VALUE_SYMBOL;
    }

    public void setTransient(boolean trans) {
        this.isTransient = trans;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        if (this.decl == null || this.decl.getType() == null) {
            return;
        }
        h.openSubTag("Attribute");
        h.addObject("type", this.decl, false);
        HandlerExpr ex = this.getExpr();
        if (h.getDocumentVersion().equals("1.0")) {
            if (ex.isConstant()) {
                Object v = ex.getValue();
                h.openSubTag("Value");
                if (this.decl.getType().toString().equals("String")) {
                    while (v instanceof HandlerExpr) {
                        v = ((HandlerExpr)v).getValue();
                    }
                    if (v instanceof String) {
                        h.addAttrValue("string", v);
                    }
                } else {
                    h.addAttrValue(this.decl.getType().toString(), v);
                }
                h.close();
                h.addAttr("constant", "true");
            } else if (ex.isVariable()) {
                String v = ex.getString();
                h.openSubTag("Value");
                h.addAttrValue("string", v);
                h.close();
                h.addAttr("variable", "true");
            } else {
                String v = ex.getString();
                h.openSubTag("Value");
                h.addAttrValue("string", v);
                h.close();
            }
        } else if (ex.isConstant()) {
            Object v = ex.getValue();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(v);
                h.addAttr("value", h.escapeString(os.toString()));
            }
            catch (IOException e) {
                h.addAttr("value", h.escapeString(v.toString()));
            }
            h.addAttr("constant", "true");
        } else {
            h.addAttr("value", ex.getString());
        }
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        block50: {
            if (this.decl == null || this.decl.getType() == null) {
                System.out.println("ValueMember.XreadObject: WARNING!\n\t Attribute  \"" + this.decl.getName() + "\" :  type declaration of attribute value is null.");
                return;
            }
            if (h.getDocumentVersion().equals("1.0")) {
                if (h.readAttr("constant") != EMPTY_VALUE_SYMBOL) {
                    if (h.readSubTag("Value")) {
                        Object obj = null;
                        if (this.decl.getType().toString().equals("String")) {
                            String javaTag = h.readSubTag();
                            if (javaTag.equals("java") && (obj = h.getAttrValue("String")) == null) {
                                obj = h.getAttrValue("string");
                            }
                            if (javaTag.equals("string") || javaTag.equals("String")) {
                                obj = h.getElementData(h.top());
                            }
                            h.close();
                            if (obj == null) {
                                obj = new String();
                            } else if (obj instanceof String) {
                                String objStr = this.formString((String)obj);
                                obj = objStr;
                            }
                        } else {
                            obj = h.getAttrValue(this.decl.getType().toString());
                        }
                        if (obj == null) {
                            h.close();
                            return;
                        }
                        if (obj instanceof String && ((String)obj).equals("null")) {
                            this.setExprAsText((String)obj);
                            h.close();
                            return;
                        }
                        String valueAsString = EMPTY_VALUE_SYMBOL;
                        if (this.decl.getType().toString().equals("String")) {
                            this.setExprAsObject(obj);
                        } else if (this.decl.getType().toString().equals("int")) {
                            valueAsString = ((Integer)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (this.decl.getType().toString().equals("boolean")) {
                            valueAsString = ((Boolean)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (this.decl.getType().toString().equals("float")) {
                            valueAsString = ((Float)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (this.decl.getType().toString().equals("double")) {
                            valueAsString = ((Double)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (this.decl.getType().toString().equals("long")) {
                            valueAsString = ((Long)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (this.decl.getType().toString().equals("short")) {
                            valueAsString = ((Short)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (this.decl.getType().toString().equals("byte")) {
                            valueAsString = ((Byte)obj).toString();
                            this.setExprAsEvaluatedText(valueAsString);
                        } else if (this.decl.getType().toString().equals("char")) {
                            valueAsString = ((Character)obj).toString();
                            this.setExprAsText("'" + valueAsString.charAt(0) + "'");
                        } else {
                            this.setExprAsObject(obj);
                        }
                        h.close();
                    } else {
                        System.out.println("ValueMember.XreadObject:  Tag  <Value>  of  '" + this.getName() + "'  not found");
                    }
                } else if (h.readAttr("variable") != EMPTY_VALUE_SYMBOL) {
                    if (h.readSubTag("Value")) {
                        Object obj = h.getAttrValue("String");
                        if (obj == null) {
                            obj = h.getAttrValue("string");
                        }
                        if (obj == null) {
                            h.close();
                            return;
                        }
                        if (obj instanceof String) {
                            this.setExprAsText((String)obj);
                        }
                        h.close();
                    }
                } else if (h.readSubTag("Value")) {
                    Object obj = null;
                    String javaTag = h.readSubTag();
                    if (javaTag.equals("java") && (obj = h.getAttrValue("String")) == null) {
                        obj = h.getAttrValue("string");
                    }
                    if (javaTag.equals("string") || javaTag.equals("String")) {
                        obj = h.getElementData(h.top());
                    }
                    h.close();
                    if (obj == null) {
                        h.close();
                        return;
                    }
                    if (obj instanceof String) {
                        String objStr = this.formString((String)obj);
                        this.setExprAsText(objStr);
                    }
                    h.close();
                }
            } else {
                String val = h.readAttr("value");
                if (h.readAttr("constant") != EMPTY_VALUE_SYMBOL) {
                    String v = h.unescapeString(val);
                    byte[] buf = v.getBytes();
                    ByteArrayInputStream is = new ByteArrayInputStream(buf);
                    try {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        Object vo = ois.readObject();
                        if (this.decl.getType().toString().equals("int") || this.decl.getType().toString().equals("boolean") || this.decl.getType().toString().equals("float") || this.decl.getType().toString().equals("double") || this.decl.getType().toString().equals("long") || this.decl.getType().toString().equals("short")) {
                            this.setExprAsEvaluatedText(vo.toString());
                            break block50;
                        }
                        this.setExprAsObject(vo);
                    }
                    catch (Exception exception) {}
                } else {
                    this.setExprAsText(val);
                }
            }
        }
    }

    private String formString(String s) {
        String s1 = s.toString();
        String s2 = s1.replaceAll("\n", EMPTY_VALUE_SYMBOL);
        while (s2.indexOf("  ") != -1) {
            s1 = s2.replaceAll("  ", " ");
            s2 = s1.toString();
        }
        return s1;
    }

    public void removeErrorMsg() {
        this.errorMsg = EMPTY_VALUE_SYMBOL;
        this.currentException = null;
    }
}

