/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.diagram.edit.helpers.ModuleEditHelper;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.util.HenshinModelCleaner;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.parsers.AbstractAttributeParser;

public class UnitNameParser
extends AbstractAttributeParser {
    private static final Pattern UNIT_NAME_PATTERN = Pattern.compile("^\\s*(\\w*?)\\s*(?:\\s*\\(([\\w,\\:\\s]*)\\s*\\))?$");
    private static final String PARAMETER_SEPARATOR = ",";
    protected View unitView;

    public UnitNameParser(View view) {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
        this.unitView = view;
    }

    protected boolean isUnitEmpty(Unit unit) {
        return unit.getSubUnits(false).isEmpty() && unit.getParameters().isEmpty();
    }

    public String getEditString(IAdaptable element, int flags) {
        Unit unit = (Unit)this.unitView.getElement();
        String result = this.getPrintString(element, flags);
        if (result.startsWith(unit.eClass().getName())) {
            result = result.replaceFirst(unit.eClass().getName(), "").trim();
        }
        return result;
    }

    public String getPrintString(IAdaptable element, int flags) {
        Unit unit = (Unit)this.unitView.getElement();
        return unit.toString();
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        View view = (View)element.getAdapter(View.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)view.getElement());
        if (domain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(domain, "Parse Unit Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return UnitNameParser.this.doParsing(value);
            }
        };
        return command;
    }

    protected CommandResult doParsing(String value) throws ExecutionException {
        Matcher matcher;
        int index;
        Unit unit = (Unit)this.unitView.getElement();
        if (unit instanceof IteratedUnit && (index = value.indexOf(91)) >= 0) {
            String it = value.substring(index + 1);
            value = value.substring(0, index);
            index = it.indexOf(93);
            if (index >= 0) {
                if ((it = it.substring(0, index).trim()).length() == 0 || it.equals("?")) {
                    it = null;
                }
                ((IteratedUnit)unit).setIterations(it);
            }
        }
        if (!(matcher = UNIT_NAME_PATTERN.matcher(value = value.trim())).matches()) {
            return CommandResult.newErrorCommandResult((String)"Error parsing unit name");
        }
        String name = matcher.group(1).trim();
        String parametersString = matcher.group(2);
        if (parametersString != null && !parametersString.trim().isEmpty()) {
            String[] paramStrings = parametersString.split(PARAMETER_SEPARATOR);
            String[] names = new String[paramStrings.length];
            String[] types = new String[paramStrings.length];
            int i = 0;
            while (i < paramStrings.length) {
                String[] split = paramStrings[i].split(":");
                names[i] = split[0].trim();
                if (split.length > 1) {
                    types[i] = split[1].trim();
                }
                ++i;
            }
            i = 1;
            while (i < names.length) {
                int j = 0;
                while (j < i) {
                    if (names[i] != null && names[j] != null && names[i].equals(names[j])) {
                        names[i] = null;
                        types[i] = null;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            EList params = unit.getParameters();
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Parameter p = (Parameter)it.next();
                if (p.getName() == null) {
                    it.remove();
                    continue;
                }
                p.setName(p.getName().trim());
            }
            int i2 = 1;
            while (i2 < params.size()) {
                Parameter p = (Parameter)params.get(i2);
                int j = 0;
                while (j < i2) {
                    if (p.getName().equals(((Parameter)params.get(j)).getName())) {
                        params.remove(i2--);
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            it = params.iterator();
            while (it.hasNext()) {
                String n = ((Parameter)it.next()).getName();
                boolean found = false;
                int i3 = 0;
                while (i3 < names.length) {
                    if (names[i3] != null && names[i3].equals(n)) {
                        found = true;
                        break;
                    }
                    ++i3;
                }
                if (found) continue;
                it.remove();
            }
            i = 0;
            while (i < names.length) {
                if (names[i] != null && unit.getParameter(names[i]) == null) {
                    unit.getParameters().add((Object)HenshinFactory.eINSTANCE.createParameter(names[i]));
                }
                ++i;
            }
            int index2 = 0;
            int i4 = 0;
            while (i4 < names.length) {
                if (names[i4] != null) {
                    Parameter p = unit.getParameter(names[i4]);
                    unit.getParameters().move(index2++, (Object)p);
                }
                ++i4;
            }
            Module module = unit.getModule();
            int i5 = 0;
            while (i5 < names.length) {
                if (names[i5] != null && types[i5] != null) {
                    EClassifier type = null;
                    EClassifier[] classifiers = ModuleEditHelper.getEClassifiers(module, types[i5]);
                    if (classifiers != null && classifiers.length > 0) {
                        type = classifiers[0];
                    }
                    unit.getParameter(names[i5]).setType(type);
                }
                ++i5;
            }
        } else {
            unit.getParameters().clear();
        }
        this.handleParametersChange(unit);
        HenshinModelCleaner.cleanModule((Module)unit.getModule());
        unit.setName(String.valueOf(name) + "_");
        unit.setName(name);
        return CommandResult.newOKCommandResult();
    }

    protected void handleParametersChange(Unit unit) {
    }

    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getNamedElement_Name()) {
            return true;
        }
        if (feature == HenshinPackage.eINSTANCE.getUnit_Parameters()) {
            return true;
        }
        if (feature == HenshinPackage.eINSTANCE.getParameter_Type()) {
            return true;
        }
        if (feature == HenshinPackage.eINSTANCE.getIteratedUnit_Iterations()) {
            return true;
        }
        if (feature == EcorePackage.eINSTANCE.getEModelElement_EAnnotations()) {
            return true;
        }
        return feature == EcorePackage.eINSTANCE.getEAnnotation_References();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

