/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.info;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class RuleChangeInfo {
    private final List<Node> createdNodes = new ArrayList<Node>();
    private final List<Node> deletedNodes = new ArrayList<Node>();
    private final List<Node> preservedNodes = new ArrayList<Node>();
    private final List<Edge> createdEdges = new ArrayList<Edge>();
    private final List<Edge> deletedEdges = new ArrayList<Edge>();
    private final List<Attribute> attributeChanges = new ArrayList<Attribute>();
    private final List<Edge> indexChanges = new ArrayList<Edge>();

    public RuleChangeInfo(Rule rule) {
        for (Node node : rule.getLhs().getNodes()) {
            if (rule.getMultiMappings().getOrigin(node) != null || rule.getMappings().getImage(node, rule.getRhs()) != null) continue;
            this.deletedNodes.add(node);
        }
        for (Node node : rule.getRhs().getNodes()) {
            if (rule.getMultiMappings().getOrigin(node) != null) continue;
            if (rule.getMappings().getOrigin(node) == null) {
                this.createdNodes.add(node);
            } else {
                this.preservedNodes.add(node);
            }
            for (Attribute attribute : node.getAttributes()) {
                this.attributeChanges.add(attribute);
            }
        }
        for (Edge edge : rule.getLhs().getEdges()) {
            if (rule.getMultiMappings().getOrigin(edge) != null || rule.getMappings().getImage(edge, rule.getRhs()) != null) continue;
            this.deletedEdges.add(edge);
        }
        for (Edge edge : rule.getRhs().getEdges()) {
            if (rule.getMultiMappings().getOrigin(edge) != null) continue;
            if (rule.getMappings().getOrigin(edge) == null) {
                this.createdEdges.add(edge);
            }
            if (edge.getIndex() == null || edge.getIndex().trim().length() <= 0) continue;
            this.indexChanges.add(edge);
        }
    }

    public List<Node> getCreatedNodes() {
        return this.createdNodes;
    }

    public List<Node> getPreservedNodes() {
        return this.preservedNodes;
    }

    public List<Edge> getCreatedEdges() {
        return this.createdEdges;
    }

    public List<Edge> getDeletedEdges() {
        return this.deletedEdges;
    }

    public List<Attribute> getAttributeChanges() {
        return this.attributeChanges;
    }

    public List<Node> getDeletedNodes() {
        return this.deletedNodes;
    }

    public List<Edge> getIndexChanges() {
        return this.indexChanges;
    }
}

