/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.List;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptEngineWrapper {
    private ScriptEngine engine;

    public ScriptEngineWrapper(ScriptEngine engine) {
        this.engine = engine;
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public Object eval(String script, List<String> imports) throws ScriptException {
        if (!imports.isEmpty()) {
            script = "(function() { with (new JavaImporter(" + this.toImportString(imports) + ")) { return " + script + " ; }}).call(this);";
        }
        return this.engine.eval(script);
    }

    private String toImportString(List<String> imports) {
        StringBuffer out = new StringBuffer();
        String delim = "";
        for (String i : imports) {
            out.append(delim).append(this.stripWildcard(i));
            delim = ", ";
        }
        return out.toString();
    }

    private String stripWildcard(String imp) {
        return this.isWildcard(imp) ? imp.substring(0, imp.length() - 2) : imp;
    }

    private boolean isWildcard(String imp) {
        return Pattern.matches("(.*)\\.\\*$", imp);
    }

    public static ScriptEngineWrapper newInstance() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        if (engine == null) {
            System.err.println("Warning: cannot find JavaScript engine");
        } else {
            try {
                engine.eval("importPackage(java.lang)");
            }
            catch (Throwable throwable) {
                try {
                    engine.eval("load(\"nashorn:mozilla_compat.js\");\n importPackage(java.lang)");
                }
                catch (Throwable throwable2) {
                    System.err.println("Warning: error importing java.lang package in JavaScript engine");
                }
            }
        }
        return new ScriptEngineWrapper(engine);
    }
}

