/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.giraph;

import java.util.Map;

public class HenshinUtilTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "/*" + this.NL + " * Licensed to the Apache Software Foundation (ASF) under one" + this.NL + " * or more contributor license agreements.  See the NOTICE file" + this.NL + " * distributed with this work for additional information" + this.NL + " * regarding copyright ownership.  The ASF licenses this file" + this.NL + " * to you under the Apache License, Version 2.0 (the" + this.NL + " * \"License\"); you may not use this file except in compliance" + this.NL + " * with the License.  You may obtain a copy of the License at" + this.NL + " *" + this.NL + " *     http://www.apache.org/licenses/LICENSE-2.0" + this.NL + " *" + this.NL + " * Unless required by applicable law or agreed to in writing, software" + this.NL + " * distributed under the License is distributed on an \"AS IS\" BASIS," + this.NL + " * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied." + this.NL + " * See the License for the specific language governing permissions and" + this.NL + " * limitations under the License." + this.NL + " */" + this.NL + "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import java.io.ByteArrayOutputStream;" + this.NL + "import java.io.IOException;" + this.NL + "import java.nio.ByteBuffer;" + this.NL + "import java.nio.IntBuffer;" + this.NL + "import java.nio.LongBuffer;" + this.NL + "import java.util.Arrays;" + this.NL + "import java.util.ArrayList;" + this.NL + "import java.util.HashSet;" + this.NL + "import java.util.List;" + this.NL + "import java.util.LinkedHashSet;" + this.NL + "import java.util.Set;" + this.NL + "import java.util.UUID;" + this.NL + this.NL + "import org.apache.giraph.aggregators.BasicAggregator;" + this.NL + "import org.apache.giraph.edge.Edge;" + this.NL + "import org.apache.giraph.edge.EdgeFactory;" + this.NL + "import org.apache.giraph.graph.Vertex;" + this.NL + "import org.apache.giraph.io.formats.TextVertexInputFormat;" + this.NL + "import org.apache.giraph.io.formats.TextVertexOutputFormat;" + this.NL + "import org.apache.hadoop.io.BytesWritable;" + this.NL + "import org.apache.hadoop.io.ByteWritable;" + this.NL + "import org.apache.hadoop.io.Text;" + this.NL + "import org.apache.hadoop.mapreduce.InputSplit;" + this.NL + "import org.apache.hadoop.mapreduce.TaskAttemptContext;" + this.NL + "import org.json.JSONArray;" + this.NL + "import org.json.JSONException;" + this.NL + this.NL + "import com.google.common.collect.Lists;" + this.NL + this.NL + "/**" + this.NL + " * Henshin utility classes and methods." + this.NL + " */" + this.NL + "public class HenshinUtil {" + this.NL + this.NL + "  /**" + this.NL + "   * Length of integers in bytes." + this.NL + "   */" + this.NL + "  private static final int INT_LENGTH = Integer.SIZE / Byte.SIZE;" + this.NL + this.NL + "  /**" + this.NL + "   * Private constructor." + this.NL + "   */" + this.NL + "  private HenshinUtil() {" + this.NL + "    // Prevent instantiation" + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Remove duplicate matches." + this.NL + "   * @param matches List of matches." + this.NL + "   * @return Filtered list." + this.NL + "   */" + this.NL + "  public static List<Match> removeDuplicateMatches(Iterable<Match> matches) {" + this.NL + "    Set<Match> result = new LinkedHashSet<Match>();" + this.NL + "    for (Match m : matches) {" + this.NL + "      result.add(m);" + this.NL + "    }" + this.NL + "    return new ArrayList<Match>(result);" + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Remove non-injective matches." + this.NL + "   * @param matches List of matches." + this.NL + "   * @return Filtered list." + this.NL + "   */" + this.NL + "  public static List<Match> removeNonInjectiveMatches(Iterable<Match> matches) {" + this.NL + "    List<Match> result = new ArrayList<Match>();" + this.NL + "    for (Match m : matches) {" + this.NL + "      if (m.isInjective()) {" + this.NL + "        result.add(m);" + this.NL + "      }" + this.NL + "    }" + this.NL + "    return result;" + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Henshin data." + this.NL + "   */" + this.NL + "  public abstract static class Bytes extends BytesWritable {" + this.NL + this.NL + "    /**" + this.NL + "     * Default constructor." + this.NL + "     */" + this.NL + "    public Bytes() {" + this.NL + "      super();" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Extra constructor." + this.NL + "     * @param data The data." + this.NL + "     */" + this.NL + "    public Bytes(byte[] data) {" + this.NL + "      super(data);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Set the size." + this.NL + "     * @param size The new size." + this.NL + "     */" + this.NL + "    @Override" + this.NL + "    public void setSize(int size) {" + this.NL + "      if (size != getCapacity()) {" + this.NL + "        setCapacity(size);" + this.NL + "      }" + this.NL + "      super.setSize(size);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Pretty-print this bytes object." + this.NL + "     * @return The printed string." + this.NL + "     */" + this.NL + "    @Override" + this.NL + "    public String toString() {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      StringBuffer result = new StringBuffer();" + this.NL + "      for (int i = 0; i < bytes.length; i++) {" + this.NL + "        result.append(bytes[i]);" + this.NL + "        if (i < bytes.length - 1) {" + this.NL + "          result.append(\",\");" + this.NL + "        }" + this.NL + "      }" + this.NL + "      return \"[\" + result + \"]\";" + this.NL + "    }" + this.NL + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Henshin vertex ID." + this.NL + "   */" + this.NL + "  public static class VertexId extends Bytes {" + this.NL + this.NL + "    /**" + this.NL + "     * Default constructor." + this.NL + "     */" + this.NL + "    public VertexId() {" + this.NL + "      super();" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Extra constructor." + this.NL + "     * @param data The data." + this.NL + "     */" + this.NL + "    public VertexId(byte[] data) {" + this.NL + "      super(data);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Create a new random vertex ID." + this.NL + "     * The vertex ID is derived from a random UUID." + this.NL + "     * @return The new vertex ID." + this.NL + "     */" + this.NL + "    public static VertexId randomVertexId() {" + this.NL + "      UUID uuid = UUID.randomUUID();" + this.NL + "      byte[] bytes = new byte[(Long.SIZE / Byte.SIZE) * 2];" + this.NL + "      ByteBuffer buffer = ByteBuffer.wrap(bytes);" + this.NL + "      LongBuffer longBuffer = buffer.asLongBuffer();" + this.NL + "      longBuffer.put(new long[] {" + this.NL + "        uuid.getMostSignificantBits()," + this.NL + "        uuid.getLeastSignificantBits()" + this.NL + "      });" + this.NL + "      return new VertexId(bytes);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Create an extended version of this vertex ID." + this.NL + "     * @param value The value to be appended to this vertex ID." + this.NL + "     * @return The extended version of this vertex ID." + this.NL + "     */" + this.NL + "    public VertexId append(byte value) {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      bytes = Arrays.copyOf(bytes, bytes.length + 1);" + this.NL + "      bytes[bytes.length - 1] = value;" + this.NL + "      return new VertexId(bytes);" + this.NL + "    }" + this.NL + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Henshin match object." + this.NL + "   */" + this.NL + "  public static class Match extends Bytes {" + this.NL + this.NL + "    /**" + this.NL + "     * Empty match." + this.NL + "     */" + this.NL + "    public static final Match EMPTY = new Match();" + this.NL + this.NL + "    /**" + this.NL + "     * Default constructor." + this.NL + "     */" + this.NL + "    public Match() {" + this.NL + "      super();" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Extra constructor." + this.NL + "     * @param segment The segment of this match." + this.NL + "     */" + this.NL + "    public Match(int segment) {" + this.NL + "      super(new byte[] {" + this.NL + "        (byte) (segment >>> 24)," + this.NL + "        (byte) (segment >>> 16)," + this.NL + "        (byte) (segment >>> 8)," + this.NL + "        (byte) segment });" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Extra constructor." + this.NL + "     * @param data The data." + this.NL + "     */" + this.NL + "    public Match(byte[] data) {" + this.NL + "      super(data);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the segment of this match." + this.NL + "     * @return The segment." + this.NL + "     */" + this.NL + "    public int getSegment() {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      return bytes[0] << 24 |" + this.NL + "        (bytes[1] & 0xFF) << 16 |" + this.NL + "        (bytes[2] & 0xFF) << 8 |" + this.NL + "        (bytes[3] & 0xFF);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the size of this match." + this.NL + "     * @return The match size." + this.NL + "     */" + this.NL + "    public int getMatchSize() {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      int d = 4;" + this.NL + "      int size = 0;" + this.NL + "      while (d < bytes.length) {" + this.NL + "        d += bytes[d] + 1;" + this.NL + "        size++;" + this.NL + "      }" + this.NL + "      return size;" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the vertex ID of a matched node." + this.NL + "     * @param vertexIndex Index of the next vertex." + this.NL + "     * @return The vertex ID." + this.NL + "     */" + this.NL + "    public VertexId getVertexId(int vertexIndex) {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      int d = 4;" + this.NL + "      for (int i = 0; i < vertexIndex; i++) {" + this.NL + "        if (d >= bytes.length) {" + this.NL + "          return null;" + this.NL + "        }" + this.NL + "        d += bytes[d] + 1;" + this.NL + "      }" + this.NL + "      if (d >= bytes.length) {" + this.NL + "        return null;" + this.NL + "      }" + this.NL + "      return new VertexId(" + this.NL + "        Arrays.copyOfRange(bytes, d + 1, d + 1 + bytes[d]));" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the index of a vertex ID of a matched node." + this.NL + "     * @param vertexId A vertex ID." + this.NL + "     * @return The index of the vertex ID or -1." + this.NL + "     */" + this.NL + "    public int indexOf(VertexId vertexId) {" + this.NL + "      int i = 0;" + this.NL + "      VertexId id;" + this.NL + "      do {" + this.NL + "        id = getVertexId(i);" + this.NL + "        if (vertexId.equals(id)) {" + this.NL + "          return i;" + this.NL + "        }" + this.NL + "        i++;" + this.NL + "      } while (id != null);" + this.NL + "      return -1;" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Returns true if this match is injective." + this.NL + "     * @return true if this match is injective." + this.NL + "     */" + this.NL + "    public boolean isInjective() {" + this.NL + "      Set<VertexId> ids = new HashSet<VertexId>();" + this.NL + "      int i = 0;" + this.NL + "      VertexId id;" + this.NL + "      do {" + this.NL + "        id = getVertexId(i++);" + this.NL + "        if (id != null && !ids.add(id)) {" + this.NL + "          return false;" + this.NL + "        }" + this.NL + "      } while (id != null);" + this.NL + "      return true;" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Create an extended version of this (partial) match." + this.NL + "     * @param vertexId The ID of the next matched vertex." + this.NL + "     * @return The extended match object." + this.NL + "     */" + this.NL + "    public Match append(VertexId vertexId) {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      byte[] id = vertexId.getBytes();" + this.NL + "      byte[] result = Arrays.copyOf(bytes, bytes.length + 1 + id.length);" + this.NL + "      result[bytes.length] = (byte) id.length;" + this.NL + "      System.arraycopy(id, 0, result, bytes.length + 1, id.length);" + this.NL + "      return new Match(result);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Create an extended version of this (partial) match." + this.NL + "     * @param match Another partial match for the next matched vertices." + this.NL + "     * @return The extended match object." + this.NL + "     */" + this.NL + "    public Match append(Match match) {" + this.NL + "      byte[] bytes1 = getBytes();" + this.NL + "      byte[] bytes2 = match.getBytes();" + this.NL + "      bytes1 = Arrays.copyOf(bytes1, bytes1.length + bytes2.length - 4);" + this.NL + "      System.arraycopy(bytes2, 4," + this.NL + "        bytes1, bytes1.length - bytes2.length + 4, bytes2.length - 4);" + this.NL + "      return new Match(bytes1);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Remove a vertex ID of a matched node." + this.NL + "     * @param vertexIndex Index of the vertex ID." + this.NL + "     * @return The new match." + this.NL + "     */" + this.NL + "    public Match remove(int vertexIndex) {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      int d = 4;" + this.NL + "      for (int i = 0; i < vertexIndex; i++) {" + this.NL + "        if (d >= bytes.length) {" + this.NL + "          return null;" + this.NL + "        }" + this.NL + "        d += bytes[d] + 1;" + this.NL + "      }" + this.NL + "      if (d >= bytes.length) {" + this.NL + "        return null;" + this.NL + "      }" + this.NL + "      byte[] result = Arrays.copyOf(bytes, bytes.length - bytes[d] - 1);" + this.NL + "      if (d < result.length) {" + this.NL + "        System.arraycopy(bytes, d + 1 + bytes[d]," + this.NL + "          result, d, result.length - d);" + this.NL + "      }" + this.NL + "      return new Match(result);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Create a copy of this match." + this.NL + "     * @return The copy." + this.NL + "     */" + this.NL + "    public Match copy() {" + this.NL + "      return new Match(getBytes());" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Pretty-print this match." + this.NL + "     * @return The printed string." + this.NL + "     */" + this.NL + "    @Override" + this.NL + "    public String toString() {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      StringBuffer result = new StringBuffer();" + this.NL + "      int i = 4;" + this.NL + "      while (i < bytes.length) {" + this.NL + "        int len = bytes[i++];" + this.NL + "        result.append(\"[\");" + this.NL + "        for (int j = 0; j < len; j++) {" + this.NL + "          result.append(bytes[i + j]);" + this.NL + "          if (j < len - 1) {" + this.NL + "            result.append(\",\");" + this.NL + "          }" + this.NL + "        }" + this.NL + "        result.append(\"]\");" + this.NL + "        i += len;" + this.NL + "        if (i < bytes.length - 1) {" + this.NL + "          result.append(\",\");" + this.NL + "        }" + this.NL + "      }" + this.NL + "      if (bytes.length > 0) {" + this.NL + "        return getSegment() + \":[\" + result + \"]\";" + this.NL + "      } else {" + this.NL + "        return \"[\" + result + \"]\";" + this.NL + "      }" + this.NL + "    }" + this.NL + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Henshin application stack." + this.NL + "   */" + this.NL + "  public static class ApplicationStack extends Bytes {" + this.NL + this.NL + "    /**" + this.NL + "     * Default constructor." + this.NL + "     */" + this.NL + "    public ApplicationStack() {" + this.NL;
    protected final String TEXT_3 = "      super();" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Extra constructor." + this.NL + "     * @param data The data." + this.NL + "     */" + this.NL + "    public ApplicationStack(byte[] data) {" + this.NL + "      super(data);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the size of this application stack." + this.NL + "     * @return the size of this application stack." + this.NL + "     */" + this.NL + "    public int getStackSize() {" + this.NL + "      return (getBytes().length / INT_LENGTH) / 3;" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the unit index at an absolute position." + this.NL + "     * @param position An absolute position in the stack." + this.NL + "     * @return the unit index or -1." + this.NL + "     */" + this.NL + "    public int getUnit(int position) {" + this.NL + "      IntBuffer intBuf = ByteBuffer.wrap(getBytes()).asIntBuffer();" + this.NL + "      if (position < 0 || position * 3 >= intBuf.limit()) {" + this.NL + "        return -1;" + this.NL + "      }" + this.NL + "      return intBuf.get(position * 3);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the segment index at an absolute position." + this.NL + "     * @param position An absolute position in the stack." + this.NL + "     * @return the segment index or -1." + this.NL + "     */" + this.NL + "    public int getSegment(int position) {" + this.NL + "      IntBuffer intBuf = ByteBuffer.wrap(getBytes()).asIntBuffer();" + this.NL + "      if (position < 0 || (position * 3) + 1 >= intBuf.limit()) {" + this.NL + "        return -1;" + this.NL + "      }" + this.NL + "      return intBuf.get((position * 3) + 1);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the microstep at an absolute position." + this.NL + "     * @param position An absolute position in the stack." + this.NL + "     * @return the microstp or -1." + this.NL + "     */" + this.NL + "    public int getMicrostep(int position) {" + this.NL + "      IntBuffer intBuf = ByteBuffer.wrap(getBytes()).asIntBuffer();" + this.NL + "      if (position < 0 || (position * 3) + 2 >= intBuf.limit()) {" + this.NL + "        return -1;" + this.NL + "      }" + this.NL + "      return intBuf.get((position * 3) + 2);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the unit index at the last position." + this.NL + "     * @return the unit index or -1." + this.NL + "     */" + this.NL + "    public int getLastUnit() {" + this.NL + "      return getUnit(getStackSize() - 1);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the segment index at the last position." + this.NL + "     * @return the segment index or -1." + this.NL + "     */" + this.NL + "    public int getLastSegment() {" + this.NL + "      return getSegment(getStackSize() - 1);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Get the microstep at the last position." + this.NL + "     * @return the microstep or -1." + this.NL + "     */" + this.NL + "    public int getLastMicrostep() {" + this.NL + "      return getMicrostep(getStackSize() - 1);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Create an extended version of this application stack." + this.NL + "     * @param unit The new unit index." + this.NL + "     * @param segment The new segment index." + this.NL + "     * @param microstep The new microstep." + this.NL + "     * @return The extended version of this application stack." + this.NL + "     */" + this.NL + "    public ApplicationStack append(int unit, int segment, int microstep) {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      bytes = Arrays.copyOf(bytes, bytes.length + (INT_LENGTH * 3));" + this.NL + "      IntBuffer intBuffer = ByteBuffer.wrap(bytes).asIntBuffer();" + this.NL + "      intBuffer.put((bytes.length / INT_LENGTH) - 3, unit);" + this.NL + "      intBuffer.put((bytes.length / INT_LENGTH) - 2, segment);" + this.NL + "      intBuffer.put((bytes.length / INT_LENGTH) - 1, microstep);" + this.NL + "      return new ApplicationStack(bytes);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Create a new version of this application stack without the last entry." + this.NL + "     * @return The new version of this application stack." + this.NL + "     */" + this.NL + "    public ApplicationStack removeLast() {" + this.NL + "      byte[] bytes = getBytes();" + this.NL + "      bytes = Arrays.copyOf(bytes," + this.NL + "        Math.max(0, bytes.length - (INT_LENGTH * 3)));" + this.NL + "      return new ApplicationStack(bytes);" + this.NL + "    }" + this.NL + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Aggregator class for application stacks." + this.NL + "   */" + this.NL + "  public static class ApplicationStackAggregator extends" + this.NL + "    BasicAggregator<ApplicationStack> {" + this.NL + this.NL + "    @Override" + this.NL + "    public void aggregate(ApplicationStack stack) {" + this.NL + "      setAggregatedValue(stack);" + this.NL + "    }" + this.NL + this.NL + "    @Override" + this.NL + "    public ApplicationStack createInitialValue() {" + this.NL + "      return new ApplicationStack();" + this.NL + "    }" + this.NL + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Henshin input format." + this.NL + "   */" + this.NL + "  public static class InputFormat extends" + this.NL + "    TextVertexInputFormat<VertexId, ByteWritable, ByteWritable> {" + this.NL + this.NL + "    @Override" + this.NL + "    public TextVertexReader createVertexReader(InputSplit split," + this.NL + "      TaskAttemptContext context) {" + this.NL + "      return new InputReader();" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Henshin input reader." + this.NL + "     */" + this.NL + "    class InputReader extends" + this.NL + "      TextVertexReaderFromEachLineProcessedHandlingExceptions<JSONArray," + this.NL + "        JSONException> {" + this.NL + this.NL + "      @Override" + this.NL + "      protected JSONArray preprocessLine(Text line) throws JSONException {" + this.NL + "        return new JSONArray(line.toString());" + this.NL + "      }" + this.NL + this.NL + "      @Override" + this.NL + "      protected VertexId getId(JSONArray jsonVertex)" + this.NL + "        throws JSONException, IOException {" + this.NL + "        return jsonArrayToVertexId(jsonVertex.getJSONArray(0));" + this.NL + "      }" + this.NL + this.NL + "      /**" + this.NL + "       * Convert a JSON array to a VertexId object." + this.NL + "       * @param jsonArray The JSON array to be converted." + this.NL + "       * @return The corresponding VertexId." + this.NL + "       */" + this.NL + "      private VertexId jsonArrayToVertexId(JSONArray jsonArray)" + this.NL + "        throws JSONException {" + this.NL + "        ByteArrayOutputStream out = new ByteArrayOutputStream();" + this.NL + "        for (int i = 0; i < jsonArray.length(); i++) {" + this.NL + "          int value = jsonArray.getInt(i);" + this.NL + "          if (value < 256) {" + this.NL + "            out.write(value);" + this.NL + "          } else {" + this.NL + "            out.write(value >> 24);" + this.NL + "            out.write(value >> 16);" + this.NL + "            out.write(value >> 8);" + this.NL + "            out.write(value);" + this.NL + "          }" + this.NL + "        }" + this.NL + "        return new VertexId(out.toByteArray());" + this.NL + "      }" + this.NL + this.NL + "      @Override" + this.NL + "      protected ByteWritable getValue(JSONArray jsonVertex)" + this.NL + "        throws JSONException, IOException {" + this.NL + "        return new ByteWritable((byte) jsonVertex.getInt(1));" + this.NL + "      }" + this.NL + this.NL + "      @Override" + this.NL + "      protected Iterable<Edge<VertexId, ByteWritable>> getEdges(" + this.NL + "        JSONArray jsonVertex) throws JSONException, IOException {" + this.NL + "        JSONArray jsonEdgeArray = jsonVertex.getJSONArray(2);" + this.NL + "        List<Edge<VertexId, ByteWritable>> edges =" + this.NL + "          Lists.newArrayListWithCapacity(jsonEdgeArray.length());" + this.NL + "        for (int i = 0; i < jsonEdgeArray.length(); ++i) {" + this.NL + "          JSONArray jsonEdge = jsonEdgeArray.getJSONArray(i);" + this.NL + "          edges.add(EdgeFactory.create(" + this.NL + "            jsonArrayToVertexId(jsonEdge.getJSONArray(0))," + this.NL + "            new ByteWritable((byte) jsonEdge.getInt(1))));" + this.NL + "        }" + this.NL + "        return edges;" + this.NL + "      }" + this.NL + this.NL + "      @Override" + this.NL + "      protected Vertex<VertexId, ByteWritable, ByteWritable>" + this.NL + "      handleException(Text line, JSONArray jsonVertex, JSONException e) {" + this.NL + "        throw new IllegalArgumentException(" + this.NL + "          \"Couldn't get vertex from line \" + line, e);" + this.NL + "      }" + this.NL + "    }" + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Henshin output format." + this.NL + "   */" + this.NL + "  public static class OutputFormat extends" + this.NL + "    TextVertexOutputFormat<VertexId, ByteWritable, ByteWritable> {" + this.NL + this.NL + "    @Override" + this.NL + "    public TextVertexWriter createVertexWriter(TaskAttemptContext context)" + this.NL + "      throws IOException, InterruptedException {" + this.NL + "      return new OutputWriter();" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Henshin output writer." + this.NL + "     */" + this.NL + "    class OutputWriter extends TextVertexWriterToEachLine {" + this.NL + this.NL + "      @Override" + this.NL + "      protected Text convertVertexToLine(" + this.NL + "        Vertex<VertexId, ByteWritable, ByteWritable> vertex)" + this.NL + "        throws IOException {" + this.NL + this.NL + "        JSONArray vertexArray = new JSONArray();" + this.NL + "        JSONArray idArray = new JSONArray();" + this.NL + "        byte[] id = vertex.getId().getBytes();" + this.NL + "        for (int i = 0; i < id.length; i++) {" + this.NL + "          idArray.put(id[i]);" + this.NL + "        }" + this.NL + "        vertexArray.put(idArray);" + this.NL + "        vertexArray.put(vertex.getValue().get());" + this.NL + "        JSONArray allEdgesArray = new JSONArray();" + this.NL + "        for (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {" + this.NL + "          JSONArray edgeArray = new JSONArray();" + this.NL + "          JSONArray targetIdArray = new JSONArray();" + this.NL + "          byte[] targetId = edge.getTargetVertexId().getBytes();" + this.NL + "          for (int i = 0; i < targetId.length; i++) {" + this.NL + "            targetIdArray.put(targetId[i]);" + this.NL + "          }" + this.NL + "          edgeArray.put(targetIdArray);" + this.NL + "          edgeArray.put(edge.getValue().get());" + this.NL + "          allEdgesArray.put(edgeArray);" + this.NL + "        }" + this.NL + "        vertexArray.put(allEdgesArray);" + this.NL + "        return new Text(vertexArray.toString());" + this.NL + "      }" + this.NL + "    }" + this.NL + "  }" + this.NL + this.NL + "}";
    protected final String TEXT_4 = this.NL;

    public static synchronized HenshinUtilTemplate create(String lineSeparator) {
        nl = lineSeparator;
        HenshinUtilTemplate result = new HenshinUtilTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Map args = (Map)argument;
        String packageName = (String)args.get("packageName");
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(this.TEXT_3);
        stringBuffer.append(this.TEXT_4);
        return stringBuffer.toString();
    }
}

