/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.tests;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.tests.ConstraintListener;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.emf.validation.service.AbstractConstraintProvider;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintListener;
import org.eclipse.emf.validation.tests.TestBase;

public class ConstraintRegistryTest
extends TestBase {
    private static final String TEST_ID = "test.registry";
    private static IConstraintDescriptor descriptor = new FixtureDescriptor("org.eclipse.emf.validation.tests.test.registry");

    static {
        try {
            ConstraintRegistry.getInstance().register(descriptor);
        }
        catch (ConstraintExistsException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public ConstraintRegistryTest(String name) {
        super(name);
    }

    public void testGetInstance() {
        ConstraintRegistry reg = ConstraintRegistry.getInstance();
        ConstraintRegistryTest.assertNotNull((String)"Registry is null", (Object)reg);
        ConstraintRegistryTest.assertSame((String)"Registry is not singleton", (Object)reg, (Object)ConstraintRegistry.getInstance());
    }

    public void test_getDescriptor_String() {
        IConstraintDescriptor found = ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests.test.registry");
        ConstraintRegistryTest.assertNotNull((String)"Test descriptor not found", (Object)found);
        ConstraintRegistryTest.assertSame((String)"Wrong test descriptor found", (Object)descriptor, (Object)found);
    }

    public void testGetDescriptorStringString() {
        IConstraintDescriptor found = ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests", TEST_ID);
        ConstraintRegistryTest.assertNotNull((String)"Test descriptor not found", (Object)found);
        ConstraintRegistryTest.assertSame((String)"Wrong test descriptor found", (Object)descriptor, (Object)found);
    }

    public void testGetAllDescriptors() {
        Collection allFound = ConstraintRegistry.getInstance().getAllDescriptors();
        ConstraintRegistryTest.assertNotNull((Object)allFound);
        ConstraintRegistryTest.assertTrue((String)"Test descriptor missing", (boolean)allFound.contains(descriptor));
        ConstraintRegistryTest.assertTrue((String)"Not enough descriptors found", (allFound.size() > 1 ? 1 : 0) != 0);
    }

    public void testRegister() {
        try {
            FixtureDescriptor duplicate = new FixtureDescriptor(descriptor.getId());
            ConstraintRegistry.getInstance().register((IConstraintDescriptor)duplicate);
            ConstraintRegistryTest.fail((String)"ConstraintRegistry.register() did not throw.");
        }
        catch (ConstraintExistsException duplicate) {
        }
        catch (Exception e) {
            ConstraintRegistryTest.fail((String)("Unexpected exception type thrown by register(): " + String.valueOf(e)));
        }
    }

    public void testUnregister() {
        ConstraintRegistry reg = ConstraintRegistry.getInstance();
        reg.unregister(descriptor);
        ConstraintRegistryTest.assertNull((String)"Descriptor not unregistered", (Object)reg.getDescriptor(descriptor.getId()));
        try {
            reg.register(descriptor);
        }
        catch (ConstraintExistsException e) {
            ConstraintRegistryTest.fail((String)"ConstraintRegistry.register() should not have thrown.");
        }
    }

    public void test_repeatedlyRegisterSameDescriptor() {
        try {
            ConstraintRegistry.getInstance().unregister(descriptor);
            ConstraintListener.getInstance().reset();
            ConstraintRegistry.getInstance().register(descriptor);
            ConstraintRegistry.getInstance().register(descriptor);
            ConstraintRegistry.getInstance().register(descriptor);
            ConstraintRegistryTest.assertEquals((int)1, (int)ConstraintListener.getInstance().getEventCount());
        }
        catch (ConstraintExistsException e) {
            ConstraintRegistryTest.fail((String)("ConstraintRegistry.register() should not have thrown: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            ConstraintRegistryTest.fail((String)("Unexpected exception type thrown by register(): " + String.valueOf(e)));
        }
    }

    public void test_repeatedlyUnregisterSameDescriptor() {
        ConstraintRegistry reg = ConstraintRegistry.getInstance();
        try {
            ConstraintListener.getInstance().reset();
            reg.unregister(descriptor);
            reg.unregister(descriptor);
            reg.unregister(descriptor);
            ConstraintRegistryTest.assertEquals((int)1, (int)ConstraintListener.getInstance().getEventCount());
        }
        finally {
            try {
                reg.register(descriptor);
            }
            catch (ConstraintExistsException e) {
                ConstraintRegistryTest.fail((String)"ConstraintRegistry.register() should not have thrown.");
            }
        }
    }

    public void test_bulkRegister() {
        ConstraintListener.getInstance().reset();
        ArrayList<FixtureConstraint> constraints = new ArrayList<FixtureConstraint>();
        constraints.add(new FixtureConstraint());
        constraints.add(new FixtureConstraint());
        constraints.add(new FixtureConstraint());
        constraints.add(new FixtureConstraint());
        try {
            class ProviderAccess
            extends AbstractConstraintProvider {
                ProviderAccess() {
                }

                public void registerConstraints(Collection<? extends IModelConstraint> constraints) throws ConstraintExistsException {
                    super.registerConstraints(constraints);
                }
            }
            new ProviderAccess().registerConstraints(constraints);
        }
        catch (ConstraintExistsException e) {
            ConstraintRegistryTest.fail((String)("Should not have thrown ConstraintExistsException: " + e.getLocalizedMessage()));
        }
        ConstraintRegistryTest.assertEquals((int)constraints.size(), (int)ConstraintListener.getInstance().getEventCount());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ConstraintListener listener = ConstraintListener.getInstance();
        ConstraintRegistry.getInstance().addConstraintListener((IConstraintListener)listener);
        listener.reset();
        listener.setEnabled(true);
    }

    protected void tearDown() throws Exception {
        ConstraintListener listener = ConstraintListener.getInstance();
        listener.setEnabled(false);
        listener.reset();
        ConstraintRegistry.getInstance().removeConstraintListener((IConstraintListener)listener);
        super.tearDown();
    }

    private static class FixtureConstraint
    implements IModelConstraint {
        private static int counter = 0;
        private final FixtureDescriptor desc = new FixtureDescriptor(descriptor.getId() + "$" + counter++);

        private FixtureConstraint() {
        }

        public IConstraintDescriptor getDescriptor() {
            return this.desc;
        }

        public IStatus validate(IValidationContext ctx) {
            return Status.OK_STATUS;
        }
    }

    private static class FixtureDescriptor
    extends AbstractConstraintDescriptor {
        private final String id;

        FixtureDescriptor(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getPluginId() {
            return "org.eclipse.emf.validation.tests";
        }

        public String getMessagePattern() {
            return null;
        }

        public String getBody() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public ConstraintSeverity getSeverity() {
            return null;
        }

        public int getStatusCode() {
            return 0;
        }

        public EvaluationMode<?> getEvaluationMode() {
            return null;
        }

        public boolean targetsTypeOf(EObject eObject) {
            return false;
        }

        public boolean targetsEvent(Notification notification) {
            return false;
        }
    }
}

