/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import ordersystem.Order;
import ordersystem.OrderSystemFactory;
import ordersystem.Product;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.ClientContextManager;
import org.eclipse.emf.validation.internal.service.IClientContext;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class ClientContextManagerTest
extends TestCase {
    private static final String JUNIT_CLIENT = "org.eclipse.emf.validation.tests.junit";
    private static final String TEST_CLIENT = "junit.bindings.testClient";
    private static final String TEST_CONSTRAINT = "org.eclipse.emf.validation.tests.junit.bindings.testConstraint";
    private static final ConstraintDescriptorTest.FixtureElement constraintElement = ConstraintDescriptorTest.FixtureElement.build("constraint", "true", new String[][]{{"id", "org.eclipse.emf.validation.tests.junit.bindings.testConstraint"}, {"lang", "OCL"}});
    private static final XmlConstraintDescriptor desc;
    private static final ClientContextManager mgr;
    private static final ConstraintDescriptorTest.FixtureElement clientElement;
    private static final ConstraintDescriptorTest.FixtureElement clientElement2;
    private IClientContext ctx;
    private IClientContext ctx2;
    private Product product;
    private Order order;

    static {
        try {
            desc = new XmlConstraintDescriptor((IConfigurationElement)constraintElement);
        }
        catch (ConstraintExistsException e) {
            throw new ExceptionInInitializerError(e);
        }
        mgr = ClientContextManager.getInstance();
        clientElement = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", TEST_CLIENT}});
        clientElement.addChild(ConstraintDescriptorTest.FixtureElement.build("selector", new String[][]{{"class", TestSelector.class.getName()}}));
        clientElement2 = ConstraintDescriptorTest.FixtureElement.build("clientContext", new String[][]{{"id", "junit.bindings.testClient2"}});
        clientElement2.addChild(ConstraintDescriptorTest.FixtureElement.build("selector", new String[][]{{"class", TestSelector.class.getName()}}));
    }

    protected void setUp() {
        ConstraintDescriptorTest.FixtureElement binding = ConstraintDescriptorTest.FixtureElement.build("binding", new String[][]{{"context", TEST_CLIENT}, {"constraint", TEST_CONSTRAINT}});
        ConstraintDescriptorTest.FixtureElement binding2 = ConstraintDescriptorTest.FixtureElement.build("binding", new String[][]{{"context", "junit.bindings.testClient2"}, {"constraint", "org.eclipse.emf.validation.tests.junit.bindings.testConstraint2"}});
        ClientContextManagerTest.configureConstraintBindings(mgr, new IConfigurationElement[]{clientElement, binding, clientElement2, binding2});
        this.ctx = mgr.getClientContext(TEST_CLIENT);
        this.ctx2 = mgr.getClientContext("junit.bindings.testClient2");
        this.product = OrderSystemFactory.eINSTANCE.createProduct();
        this.order = OrderSystemFactory.eINSTANCE.createOrder();
    }

    public void test_getClientContexts() {
        ClientContextManagerTest.assertTrue((String)"Test client not found", (boolean)mgr.getClientContexts().contains(this.ctx));
    }

    public void test_getClientContext() {
        ClientContextManagerTest.assertSame((String)"Test client not found", (Object)mgr.getClientContext(TEST_CLIENT), (Object)this.ctx);
    }

    public void test_getClientContextsFor() {
        ClientContextManagerTest.assertTrue((String)"Test client not found", (boolean)mgr.getClientContextsFor((EObject)this.product).contains(this.ctx));
        ClientContextManagerTest.assertFalse((String)"Test not found", (boolean)mgr.getClientContextsFor((EObject)this.order).contains(this.ctx));
    }

    public void test_getBindings_eobject() {
        TestConstraint constraint = new TestConstraint();
        Set<TestConstraint> constraints = Collections.singleton(constraint);
        ClientContextManagerTest.assertTrue((boolean)mgr.getBindings((EObject)this.product, constraints).contains(constraint));
        ClientContextManagerTest.assertFalse((boolean)mgr.getBindings((EObject)this.order, constraints).contains(constraint));
    }

    public void test_getBindings_eobject_none() {
        TestConstraint constraint = new TestConstraint();
        Set<TestConstraint> constraints = Collections.singleton(constraint);
        ClientContextManagerTest.assertTrue((boolean)mgr.getBindings((EObject)this.order, constraints).isEmpty());
    }

    public void test_getBindings_context() {
        TestConstraint constraint = new TestConstraint();
        Set<TestConstraint> constraints = Collections.singleton(constraint);
        ClientContextManagerTest.assertTrue((boolean)mgr.getBindings(this.ctx, constraints).contains(constraint));
        ClientContextManagerTest.assertFalse((boolean)mgr.getBindings(this.ctx2, constraints).contains(constraint));
    }

    public void test_getBindings_contexts() {
        TestConstraint constraint = new TestConstraint();
        Set<TestConstraint> constraints = Collections.singleton(constraint);
        ClientContextManagerTest.assertTrue((boolean)mgr.getBindings(Arrays.asList(this.ctx, this.ctx2), constraints).contains(constraint));
        ClientContextManagerTest.assertFalse((boolean)mgr.getBindings(Arrays.asList(this.ctx2, this.ctx2), constraints).contains(constraint));
    }

    public void test_defaultBindings_context() {
        ConstraintDescriptorTest.FixtureElement defaultElement = ConstraintDescriptorTest.FixtureElement.build("constraint", "true", new String[][]{{"id", "org.eclipse.emf.validation.tests.junit.bindings.testConstraint.default"}, {"lang", "OCL"}});
        try {
            final XmlConstraintDescriptor descr = new XmlConstraintDescriptor((IConfigurationElement)defaultElement);
            IModelConstraint constraint = new IModelConstraint(){

                public IStatus validate(IValidationContext c) {
                    return Status.OK_STATUS;
                }

                public IConstraintDescriptor getDescriptor() {
                    return descr;
                }
            };
            Set<1> constraints = Collections.singleton(constraint);
            IClientContext junitCtx = mgr.getClientContext(JUNIT_CLIENT);
            ClientContextManagerTest.assertFalse((boolean)mgr.getBindings(this.ctx, constraints).contains(constraint));
            ClientContextManagerTest.assertTrue((boolean)mgr.getBindings(junitCtx, constraints).contains(constraint));
        }
        catch (ConstraintExistsException e) {
            ClientContextManagerTest.fail((String)("Should not throw exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_defaultBindings_contexts() {
        ConstraintDescriptorTest.FixtureElement defaultElement = ConstraintDescriptorTest.FixtureElement.build("constraint", "true", new String[][]{{"id", "org.eclipse.emf.validation.tests.junit.bindings.testConstraint.default2"}, {"lang", "OCL"}});
        try {
            final XmlConstraintDescriptor descr = new XmlConstraintDescriptor((IConfigurationElement)defaultElement);
            IModelConstraint constraint = new IModelConstraint(){

                public IStatus validate(IValidationContext c) {
                    return Status.OK_STATUS;
                }

                public IConstraintDescriptor getDescriptor() {
                    return descr;
                }
            };
            ArrayList<IClientContext> contexts = new ArrayList<IClientContext>();
            contexts.add(this.ctx);
            contexts.add(this.ctx2);
            Set<2> constraints = Collections.singleton(constraint);
            IClientContext junitCtx = mgr.getClientContext(JUNIT_CLIENT);
            ClientContextManagerTest.assertFalse((boolean)mgr.getBindings(contexts, constraints).contains(constraint));
            contexts.add(junitCtx);
            ClientContextManagerTest.assertTrue((boolean)mgr.getBindings(contexts, constraints).contains(constraint));
        }
        catch (ConstraintExistsException e) {
            ClientContextManagerTest.fail((String)("Should not throw exception: " + e.getLocalizedMessage()));
        }
    }

    private static void configureConstraintBindings(ClientContextManager mgr, IConfigurationElement[] configs) {
        Class[] parameterTypes = new Class[]{configs.getClass()};
        try {
            Method configureMethod = mgr.getClass().getDeclaredMethod("configureClientContexts", parameterTypes);
            try {
                configureMethod.setAccessible(true);
                configureMethod.invoke((Object)mgr, new Object[]{configs});
            }
            finally {
                configureMethod.setAccessible(false);
            }
            configureMethod = mgr.getClass().getDeclaredMethod("configureBindings", parameterTypes);
            try {
                configureMethod.setAccessible(true);
                configureMethod.invoke((Object)mgr, new Object[]{configs});
            }
            finally {
                configureMethod.setAccessible(false);
            }
        }
        catch (Exception e) {
            ClientContextManagerTest.fail((String)("Could not configure client contexts: " + e.getLocalizedMessage()));
        }
    }

    private static final class TestConstraint
    implements IModelConstraint {
        private TestConstraint() {
        }

        public IStatus validate(IValidationContext c) {
            return Status.OK_STATUS;
        }

        public IConstraintDescriptor getDescriptor() {
            return desc;
        }
    }

    public static final class TestSelector
    implements IClientSelector {
        public boolean selects(Object object) {
            return object instanceof Product;
        }
    }
}

