/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server.store;

import javax.jms.Message;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.jms.internal.server.ServerConsumer;
import org.eclipse.net4j.jms.internal.server.ServerDestination;
import org.eclipse.net4j.jms.internal.server.bundle.OM;
import org.eclipse.net4j.jms.internal.server.store.AbstractStore;
import org.eclipse.net4j.jms.server.IDestination;
import org.eclipse.net4j.jms.server.IServerConsumer;
import org.eclipse.net4j.jms.server.IStoreTransaction;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class AbstractTransaction
implements IStoreTransaction {
    public static final String[] NO_DESTINATION_NAMES = new String[0];
    public static final long[] NO_CONSUMER_IDS = new long[0];
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_STORE, AbstractTransaction.class);
    private AbstractStore store;

    public AbstractTransaction(AbstractStore store) {
        this.store = store;
    }

    public AbstractStore getStore() {
        return this.store;
    }

    public String[] getDestinationNames() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Getting destination names");
        }
        String[] names = this.doGetDestinationNames();
        if (TRACER.isEnabled()) {
            TRACER.trace("Got destination names " + names);
        }
        return names;
    }

    public ServerDestination getDestination(String name) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Getting destination " + name);
        }
        ServerDestination destination = this.doGetDestination(name);
        if (TRACER.isEnabled()) {
            TRACER.trace("Got destination " + destination);
        }
        return destination;
    }

    public long[] getConsumerIDs() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Getting consumer IDs");
        }
        long[] ids = this.doGetConsumerIDs();
        if (TRACER.isEnabled()) {
            TRACER.trace("Got consumer IDs " + ids);
        }
        return ids;
    }

    public ServerConsumer getConsumer(long id) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Getting consumer " + id);
        }
        ServerConsumer consumer = this.doGetConsumer(id);
        if (TRACER.isEnabled()) {
            TRACER.trace("Got consumer " + consumer);
        }
        return consumer;
    }

    public void destinationAdded(IDestination destination) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Adding destination " + destination);
        }
        this.doDestinationAdded((ServerDestination)destination);
        if (TRACER.isEnabled()) {
            TRACER.trace("Added destination " + destination);
        }
    }

    public void destinationRemoved(IDestination destination) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Removing destination " + destination);
        }
        this.doDestinationRemoved((ServerDestination)destination);
        if (TRACER.isEnabled()) {
            TRACER.trace("Removed destination " + destination);
        }
    }

    public void consumerAdded(IServerConsumer consumer) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Adding consumer " + consumer);
        }
        this.doConsumerAdded((ServerConsumer)consumer);
        if (TRACER.isEnabled()) {
            TRACER.trace("Added consumer " + consumer);
        }
    }

    public void consumerRemoved(IServerConsumer consumer) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Removing consumer " + consumer);
        }
        this.doConsumerRemoved((ServerConsumer)consumer);
        if (TRACER.isEnabled()) {
            TRACER.trace("Removed consumer " + consumer);
        }
    }

    public void messageReceived(Message message) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Logging received message " + message);
        }
        this.doMessageReceived((MessageImpl)message);
        if (TRACER.isEnabled()) {
            TRACER.trace("Logged received message " + message);
        }
    }

    public void messageSent(Message message, long consumerID) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Logging sent message " + message);
        }
        this.doMessageSent((MessageImpl)message, consumerID);
        if (TRACER.isEnabled()) {
            TRACER.trace("Logged sent message " + message);
        }
    }

    public void messageAcknowledged(Message message, long consumerID) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Logging acknowledged message " + message);
        }
        this.doMessageAcknowledged((MessageImpl)message, consumerID);
        if (TRACER.isEnabled()) {
            TRACER.trace("Logged acknowledged message " + message);
        }
    }

    protected abstract String[] doGetDestinationNames();

    protected abstract ServerDestination doGetDestination(String var1);

    protected abstract long[] doGetConsumerIDs();

    protected abstract ServerConsumer doGetConsumer(long var1);

    protected abstract void doDestinationAdded(ServerDestination var1);

    protected abstract void doDestinationRemoved(ServerDestination var1);

    protected abstract void doConsumerAdded(ServerConsumer var1);

    protected abstract void doConsumerRemoved(ServerConsumer var1);

    protected abstract void doMessageReceived(MessageImpl var1);

    protected abstract void doMessageSent(MessageImpl var1, long var2);

    protected abstract void doMessageAcknowledged(MessageImpl var1, long var2);
}

