/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.CDOViewResourcesEvent;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.ui.CDOViewHistoryEvent;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;

public final class CDOViewHistory
extends Notifier {
    private CDOView view;
    private Set<Entry> entries = new HashSet<Entry>();
    private IListener viewListener = new IListener(){

        public void notifyEvent(IEvent event) {
            CDOViewResourcesEvent e;
            if (event instanceof CDOViewResourcesEvent && (e = (CDOViewResourcesEvent)event).getView() == CDOViewHistory.this.view && e.getKind() == CDOViewResourcesEvent.Kind.ADDED) {
                CDOViewHistory.this.addResource(e.getResourcePath());
            }
        }
    };

    public CDOViewHistory(CDOView view) {
        this.view = view;
        view.addListener(this.viewListener);
    }

    public void dispose() {
        this.view.removeListener(this.viewListener);
        this.entries.clear();
    }

    public CDOView getView() {
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getEntries() {
        Set<Entry> set = this.entries;
        synchronized (set) {
            return this.entries.toArray(new Entry[this.entries.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntries() {
        Set<Entry> set = this.entries;
        synchronized (set) {
            return !this.entries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        boolean changed;
        HashSet<Entry> openResources = new HashSet<Entry>();
        for (Resource resource : this.view.getResourceSet().getResources()) {
            if (!(resource instanceof CDOResource)) continue;
            CDOResource cdoResource = (CDOResource)resource;
            openResources.add(new Entry(cdoResource.getPath()));
        }
        Set<Entry> set = this.entries;
        synchronized (set) {
            changed = this.entries.retainAll(openResources);
        }
        if (changed) {
            this.fireEvent(new ViewHistoryEvent(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResource(String resourcePath) {
        boolean changed;
        Entry entry = new Entry(resourcePath);
        Set<Entry> set = this.entries;
        synchronized (set) {
            changed = this.entries.add(entry);
        }
        if (changed) {
            this.fireEvent(new ViewHistoryEvent(entry));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Entry
    implements Comparable<Entry> {
        private String resourcePath;

        public Entry(String resourcePath) {
            if (resourcePath == null) {
                throw new IllegalArgumentException("resourcePath == null");
            }
            this.resourcePath = resourcePath;
        }

        public CDOView getView() {
            return CDOViewHistory.this.view;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.resourcePath.compareTo(entry.resourcePath);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry that = (Entry)obj;
                return CDOViewHistory.this.view == that.getView() && this.resourcePath.equals(that.resourcePath);
            }
            return false;
        }

        public int hashCode() {
            return this.resourcePath.hashCode();
        }

        public String toString() {
            return this.resourcePath;
        }
    }

    private final class ViewHistoryEvent
    extends Event
    implements CDOViewHistoryEvent {
        private static final long serialVersionUID = 1L;
        Entry addedEntry;

        public ViewHistoryEvent(Entry addedEntry) {
            super((INotifier)CDOViewHistory.this);
            this.addedEntry = addedEntry;
        }

        public CDOViewHistory getViewHistory() {
            return CDOViewHistory.this;
        }

        public Entry getAddedEntry() {
            return this.addedEntry;
        }

        public String toString() {
            return MessageFormat.format("CDOViewHistoryEvent[source={0}, addedEntry={1}]", this.getSource(), this.getAddedEntry());
        }
    }
}

