/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryFactory;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfigurator {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REPOSITORY, RepositoryConfigurator.class);
    private IManagedContainer container;

    public RepositoryConfigurator(IManagedContainer container) {
        this.container = container;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public IRepository[] configure(File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring CDO server from " + configFile.getAbsolutePath());
        }
        ArrayList<IRepository> repositories = new ArrayList<IRepository>();
        Document document = this.getDocument(configFile);
        NodeList elements = document.getElementsByTagName("repository");
        int i = 0;
        while (i < elements.getLength()) {
            Element repositoryConfig = (Element)elements.item(i);
            IRepository repository = this.configureRepository(repositoryConfig);
            repositories.add(repository);
            CDOServerUtil.addRepository(this.container, repository);
            ++i;
        }
        return repositories.toArray(new IRepository[repositories.size()]);
    }

    protected IRepository configureRepository(Element repositoryConfig) throws CoreException {
        String repositoryName = repositoryConfig.getAttribute("name");
        if (StringUtil.isEmpty((String)repositoryName)) {
            throw new IllegalArgumentException("Repository name is missing or empty");
        }
        String repositoryType = repositoryConfig.getAttribute("type");
        if (StringUtil.isEmpty((String)repositoryType)) {
            repositoryType = "default";
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Configuring repository {0} (type={1})", new Object[]{repositoryName, repositoryType});
        }
        IRepository repository = this.createRepository(repositoryType);
        repository.setName(repositoryName);
        Element storeConfig = this.getStoreConfig(repositoryConfig);
        IStore store = this.configureStore(storeConfig);
        repository.setStore(store);
        Map<String, String> properties = RepositoryConfigurator.getProperties(repositoryConfig, 1);
        repository.setProperties(properties);
        return repository;
    }

    protected IRepository createRepository(String repositoryType) throws CoreException {
        IRepositoryFactory factory = this.getRepositoryFactory(repositoryType);
        return factory.createRepository();
    }

    protected IStore configureStore(Element storeConfig) throws CoreException {
        String type = storeConfig.getAttribute("type");
        IStoreFactory storeFactory = this.getStoreFactory(type);
        return storeFactory.createStore(storeConfig);
    }

    protected IStoreFactory getStoreFactory(String type) throws CoreException {
        IStoreFactory factory = (IStoreFactory)RepositoryConfigurator.createExecutableExtension("storeFactories", "storeFactory", "storeType", type);
        if (factory == null) {
            throw new IllegalStateException("Store factory not found: " + type);
        }
        return factory;
    }

    protected IRepositoryFactory getRepositoryFactory(String type) throws CoreException {
        IRepositoryFactory factory = (IRepositoryFactory)RepositoryConfigurator.createExecutableExtension("repositoryFactories", "repositoryFactory", "repositoryType", type);
        if (factory == null) {
            throw new IllegalStateException("Repository factory not found: " + type);
        }
        return factory;
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected Element getStoreConfig(Element repositoryConfig) {
        NodeList storeConfigs = repositoryConfig.getElementsByTagName("store");
        if (storeConfigs.getLength() != 1) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("Exactly one store must be configured for repository " + repositoryName);
        }
        return (Element)storeConfigs.item(0);
    }

    public static Map<String, String> getProperties(Element element, int levels) {
        HashMap<String, String> properties = new HashMap<String, String>();
        RepositoryConfigurator.collectProperties(element, "", properties, levels);
        return properties;
    }

    private static void collectProperties(Element element, String prefix, Map<String, String> properties, int levels) {
        if ("property".equals(element.getNodeName())) {
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.put(String.valueOf(prefix) + name, value);
            prefix = String.valueOf(prefix) + name + ".";
        }
        if (levels > 0) {
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    RepositoryConfigurator.collectProperties((Element)childNode, prefix, properties, levels - 1);
                }
                ++i;
            }
        }
    }

    private static Object createExecutableExtension(String extPointName, String elementName, String attributeName, String type) throws CoreException {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", extPointName);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String storeType;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ObjectUtil.equals((Object)element.getName(), (Object)elementName) && ObjectUtil.equals((Object)(storeType = element.getAttribute(attributeName)), (Object)type)) {
                return element.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }
}

