/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import org.eclipse.emf.cdo.internal.server.MEMStore;
import org.eclipse.emf.cdo.internal.server.NOOPStore;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreReader;

public final class StoreUtil {
    private static final ThreadLocal<IStoreReader> THREAD_LOCAL = new InheritableThreadLocal<IStoreReader>();

    private StoreUtil() {
    }

    public static IStore createNOOPStore() {
        return new NOOPStore();
    }

    public static IStore createMEMStore() {
        return new MEMStore();
    }

    public static void setReader(IStoreReader reader) {
        THREAD_LOCAL.set(reader);
    }

    public static IStoreReader getReader() {
        IStoreReader reader = THREAD_LOCAL.get();
        if (reader == null) {
            throw new IllegalStateException("reader == null");
        }
        return reader;
    }
}

