/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.EObjectLabelProviderHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.PatternFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;

public class TreePatternFilter
extends PatternFilter {
    private boolean _ignoreMatching;
    private Set<Object> _matchingParents;

    public TreePatternFilter() {
        this.setUseCache(true);
        this._matchingParents = new HashSet<Object>(0);
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement_p, Object element_p) {
        boolean result = false;
        Object parent = parentElement_p;
        if (parentElement_p instanceof TreePath) {
            parent = ((TreePath)parentElement_p).getLastSegment();
        }
        if (this._matchingParents.contains(parent)) {
            result = true;
            this._matchingParents.add(element_p);
        } else {
            result = this.isElementVisible(viewer, parent, element_p);
        }
        return result;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this._matchingParents.clear();
    }

    @Override
    protected boolean isLeafMatch(Viewer viewer_p, Object parentElement_p, Object element_p) {
        if (this._ignoreMatching) {
            return true;
        }
        return this.doIsLeafMatch(viewer_p, parentElement_p, element_p);
    }

    protected boolean doIsLeafMatch(Viewer viewer_p, Object parentElement_p, Object element_p) {
        boolean result = false;
        if (element_p instanceof EObject) {
            String textToMatch = this.getTextFromModelElement((EObject)element_p);
            if (textToMatch != null) {
                result = this.wordMatches(textToMatch);
            }
        } else {
            result = super.isLeafMatch(viewer_p, parentElement_p, element_p);
        }
        if (result) {
            result = !this.isLeafAlreadyFilteredOutByOtherFilters((StructuredViewer)viewer_p, parentElement_p, element_p);
        }
        return result;
    }

    protected String getTextFromModelElement(EObject element_p) {
        return EObjectLabelProviderHelper.getText(element_p);
    }

    @Override
    public boolean isElementVisible(Viewer viewer_p, Object parentElement_p, Object element_p) {
        boolean leafMatch = this.isLeafMatch(viewer_p, parentElement_p, element_p);
        boolean ignoreMatchingEnabled = false;
        if (leafMatch) {
            this._ignoreMatching = true;
            ignoreMatchingEnabled = true;
            this._matchingParents.add(element_p);
        }
        boolean parentMatch = this.isParentMatch(viewer_p, parentElement_p, element_p);
        if (ignoreMatchingEnabled) {
            this._ignoreMatching = false;
        }
        return leafMatch || parentMatch;
    }
}

