/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.WorskpaceMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class WorkspaceMetamodelRegistryProvider
implements IMetamodelRegistryProvider {
    private ResourceSet resolutionRSet;
    private Map<String, MetamodelRegistry> perProjectRegs;

    public WorkspaceMetamodelRegistryProvider() {
        this((ResourceSet)new ResourceSetImpl());
    }

    public WorkspaceMetamodelRegistryProvider(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException();
        }
        this.resolutionRSet = resourceSet;
    }

    public ResourceSet getResolutionResourceSet() {
        return this.resolutionRSet;
    }

    public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        IPath wsLocation = Path.fromOSString((String)context.getURI().toFileString());
        IFile wsResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(wsLocation);
        if (wsResource == null) {
            wsResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(wsLocation);
        }
        if (wsResource != null) {
            IProject project = wsResource.getProject();
            IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
            String namespace = null;
            namespace = pluginModel != null ? pluginModel.getPluginBase().getId() : project.getName();
            if (MetamodelURIMappingHelper.hasMappingResource((IProject)project)) {
                String projectKey;
                MetamodelRegistry reg;
                if (this.perProjectRegs == null) {
                    this.perProjectRegs = new HashMap<String, MetamodelRegistry>();
                }
                if ((reg = this.perProjectRegs.get(projectKey = project.getFullPath().toString())) == null) {
                    try {
                        reg = this.createRegistry(MetamodelURIMappingHelper.loadMappings((IProject)project), namespace);
                        this.perProjectRegs.put(projectKey, reg);
                        return reg;
                    }
                    catch (IOException e) {
                        CommonPlugin.log(e);
                    }
                } else {
                    return reg;
                }
            }
        }
        return MetamodelRegistry.getInstance();
    }

    private MetamodelRegistry createRegistry(MappingContainer mappings, String namespace) {
        WorskpaceMetamodelProvider metamodelProvider = new WorskpaceMetamodelProvider(this.resolutionRSet);
        for (URIMapping nextMapping : mappings.getMapping()) {
            URI uri = null;
            IllegalArgumentException error = null;
            try {
                uri = URI.createURI((String)nextMapping.getTargetURI());
            }
            catch (IllegalArgumentException e) {
                error = e;
            }
            if (uri != null && nextMapping.getSourceURI() != null) {
                metamodelProvider.addMetamodel(nextMapping.getSourceURI(), uri, namespace);
                continue;
            }
            String message = NLS.bind((String)"Invalid metamodel uri mapping. nsUri:''{0}'' modelUri:''{1}''", (Object)nextMapping.getSourceURI(), (Object)nextMapping.getTargetURI());
            CommonPlugin.log((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.common", message, (Throwable)error));
        }
        return new MetamodelRegistry((IMetamodelProvider)metamodelProvider);
    }
}

