/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.atl.common.AtlNbCharFile;
import org.eclipse.m2m.atl.core.ui.launch.AtlLaunchConfigurationDelegate;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class ATLConsoleTracker
implements IPatternMatchListenerDelegate {
    private static final String ATL_EDITOR_ID = "org.eclipse.m2m.atl.adt.editor.AtlEditor";
    TextConsole console;

    public void connect(TextConsole atlConsole) {
        this.console = atlConsole;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            IFile file;
            int offset = event.getOffset() + 1;
            int length = event.getLength() - 2;
            IDocument document = this.console.getDocument();
            String info = document.get(offset, length);
            String moduleName = "";
            if (info.contains(".atl") && (file = AtlLaunchConfigurationDelegate.getFileFromModuleName(moduleName = info.split(".atl")[0])) != null && file.isAccessible()) {
                String location;
                int lineNumber = -1;
                int fileOffset = -1;
                int fileLength = -1;
                if (info.contains(".atl[") && (location = info.split(".atl")[1]).matches("\\[[0-9]*:[0-9]*-[0-9]*:[0-9]*\\]")) {
                    location = location.substring(1, location.length() - 1);
                    lineNumber = Integer.valueOf(location.split(":")[0]);
                    AtlNbCharFile help = new AtlNbCharFile(file.getContents());
                    int[] index = help.getIndexChar(location);
                    fileOffset = index[0];
                    fileLength = index[1] - index[0];
                }
                this.console.addHyperlink((IHyperlink)new FileLink(file, ATL_EDITOR_ID, fileOffset, fileLength, lineNumber), offset, length);
            }
        }
        catch (Exception exception) {}
    }
}

