/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.TypeUtil;

public class ModelOperations
extends AbstractContextualOperations {
    public static final String OBJECTS_NAME = "objects";
    public static final String ROOT_OBJECTS_NAME = "rootObjects";
    public static final String OBJECTS_OF_TYPE_NAME = "objectsOfType";
    public static final String REMOVE_ELEMENT_NAME = "removeElement";
    private static final CallHandler OBJECTS = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            LinkedHashSet<Object> instances = new LinkedHashSet<Object>();
            instances.addAll(((ModelParameterExtent)source).getAllObjects());
            return instances;
        }
    };
    private static final CallHandler ROOT_OBJECTS = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            LinkedHashSet<EObject> instances = new LinkedHashSet<EObject>();
            instances.addAll(((ModelParameterExtent)source).getRootObjects());
            return instances;
        }
    };
    private static final CallHandler OBJECTS_OF_TYPE = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            LinkedHashSet<Object> instances = new LinkedHashSet<Object>();
            List<Object> objects = ((ModelParameterExtent)source).getAllObjects();
            for (Object obj : objects) {
                if (!AbstractQVTStdlib.clsFilter.matches(obj, args[0])) continue;
                instances.add(obj);
            }
            return instances;
        }
    };
    private static final CallHandler REMOVE_ELEMENT = new CallHandler(){

        public Object invoke(Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv, IContext context) {
            if (!(source instanceof ModelParameterExtent)) {
                throw new IllegalArgumentException();
            }
            ModelParameterExtent modelParam = (ModelParameterExtent)source;
            Object elementObject = args[0];
            if (elementObject instanceof EObject) {
                modelParam.removeElement((EObject)elementObject);
            }
            return null;
        }
    };

    public ModelOperations(AbstractQVTStdlib library) {
        super(library, library.getModelClass());
    }

    public EOperation defineGenericObjectsOfType(EcoreEnvironment env, EClassifier actualType) {
        return new AbstractContextualOperations.OperationProvider(OBJECTS_OF_TYPE, OBJECTS_OF_TYPE_NAME, (EClassifier)TypeUtil.resolveSetType((Environment)env, (Object)actualType), (EClassifier)env.getOCLStandardLibrary().getOclType()).define(env);
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        EClassifier setOfElements = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getElementType());
        OCLStandardLibrary oclStdLib = this.getStdlib().getEnvironment().getOCLStandardLibrary();
        return new AbstractContextualOperations.OperationProvider[]{new AbstractContextualOperations.OperationProvider(OBJECTS, OBJECTS_NAME, setOfElements, new EClassifier[0]), new AbstractContextualOperations.OperationProvider(ROOT_OBJECTS, ROOT_OBJECTS_NAME, setOfElements, new EClassifier[0]), new AbstractContextualOperations.OperationProvider(OBJECTS_OF_TYPE, OBJECTS_OF_TYPE_NAME, setOfElements, (EClassifier)oclStdLib.getOclType()), new AbstractContextualOperations.OperationProvider(REMOVE_ELEMENT, REMOVE_ELEMENT_NAME, (EClassifier)oclStdLib.getOclVoid(), this.getStdlib().getElementType())};
    }
}

