/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

public class PropagationHelper {
    public static final String BAGGAGE_VALUE = "test.baggage.value";
    public static final String BAGGAGE_METADATA = "test.baggage.metadata";
    public static final AttributeKey<List<String>> PROPAGATION_HEADERS_ATTR = AttributeKey.stringArrayKey((String)"test.propagation.headers");
    public static final String BAGGAGE_KEY = "test.baggage.key";
    public static final AttributeKey<String> BAGGAGE_VALUE_ATTR = AttributeKey.stringKey((String)"test.baggage");
    public static final AttributeKey<String> BAGGAGE_METADATA_ATTR = AttributeKey.stringKey((String)"test.baggage.metadata");
    public static final List<String> PROPAGATION_HEADER_NAMES = Arrays.asList("baggage", "traceparent", "b3", "X-B3-TraceId", "X-B3-SpanId", "X-B3-ParentSpanId", "X-B3-Sampled", "uber-trace-id");

    private PropagationHelper() {
    }

    public static boolean isPropagationHeader(String header) {
        return PROPAGATION_HEADER_NAMES.contains(header) || header.startsWith("uberctx-");
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @RegisterRestClient(configKey="client")
    @Path(value="/")
    public static interface SpanResourceClient {
        @GET
        @Path(value="/span")
        public Response span();
    }

    @Path(value="/")
    public static class SpanResource {
        @GET
        @Path(value="/span")
        public String get(@Context HttpHeaders headers) {
            Span span = Span.current();
            List propagationHeaders = headers.getRequestHeaders().keySet().stream().filter(h -> PROPAGATION_HEADER_NAMES.contains(h) || h.startsWith("uberctx-")).collect(Collectors.toList());
            span.setAttribute(AttributeKey.stringArrayKey((String)"test.propagation.headers"), propagationHeaders);
            BaggageEntry baggageEntry = (BaggageEntry)Baggage.current().asMap().get(PropagationHelper.BAGGAGE_KEY);
            if (baggageEntry != null) {
                span.setAttribute(BAGGAGE_VALUE_ATTR, (Object)baggageEntry.getValue());
                span.setAttribute(BAGGAGE_METADATA_ATTR, (Object)baggageEntry.getMetadata().getValue());
            }
            return "OK";
        }
    }
}

