/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.async;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.inject.Inject;
import java.net.URL;
import java.util.List;
import org.eclipse.microprofile.telemetry.tracing.tck.BasicHttpClient;
import org.eclipse.microprofile.telemetry.tracing.tck.ConfigAsset;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.async.MpRestClientAsyncTestEndpoint;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MpRestClientAsyncTest
extends Arquillian {
    private BasicHttpClient basicClient;
    @ArquillianResource
    private URL url;
    public static final String TEST_PASSED = "Test Passed";
    @Inject
    private InMemorySpanExporter spanExporter;

    @Deployment
    public static WebArchive createDeployment() {
        ConfigAsset config = new ConfigAsset().add("otel.bsp.schedule.delay", "100").add("otel.sdk.disabled", "false").add("otel.metrics.exporter", "none").add("otel.traces.exporter", "in-memory");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, BasicHttpClient.class, MpRestClientAsyncTestEndpoint.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
            this.basicClient = new BasicHttpClient(this.url);
        }
    }

    @Test
    public void testIntegrationWithMpRestClient() throws Exception {
        this.basicClient.get("/MpRestClientAsyncTestEndpoint/mpclient");
        this.readSpans();
    }

    @Test
    public void testIntegrationWithMpRestClientAsyncError() throws Exception {
        this.basicClient.get("/MpRestClientAsyncTestEndpoint/mpclientasyncerror");
        this.readSpansError();
    }

    @Test
    public void testIntegrationWithMpRestClientAsync() throws Exception {
        this.basicClient.get("/MpRestClientAsyncTestEndpoint/mpclientasync");
        this.readSpans();
    }

    public void readSpans() {
        this.spanExporter.assertSpanCount(3);
        List<SpanData> serverSpans = this.spanExporter.getSpansWithKind(SpanKind.SERVER);
        SpanData firstURL = null;
        SpanData secondURL = null;
        SpanData httpGet = this.spanExporter.getFirst(SpanKind.CLIENT);
        for (SpanData span : serverSpans) {
            if (((String)span.getAttributes().get(SemanticAttributes.URL_PATH)).contains("MpRestClientAsyncTestEndpoint/mpclient")) {
                firstURL = span;
                continue;
            }
            secondURL = span;
        }
        Assert.assertNotNull(firstURL);
        Assert.assertNotNull(secondURL);
        Assert.assertEquals((String)httpGet.getSpanId(), (String)secondURL.getParentSpanId());
        Assert.assertEquals((String)firstURL.getSpanId(), (String)httpGet.getParentSpanId());
        Assert.assertEquals((int)((Long)firstURL.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)200);
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(SemanticAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(SemanticAttributes.URL_SCHEME)), (String)"http");
        Assert.assertEquals((int)((Long)httpGet.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)200);
        Assert.assertEquals((String)((String)httpGet.getAttributes().get(SemanticAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertTrue((boolean)((String)httpGet.getAttributes().get(SemanticAttributes.URL_FULL)).contains("MpRestClientAsyncTestEndpoint"));
    }

    public void readSpansError() {
        this.spanExporter.assertSpanCount(3);
        List<SpanData> serverSpans = this.spanExporter.getSpansWithKind(SpanKind.SERVER);
        SpanData firstURL = null;
        SpanData secondURL = null;
        SpanData httpGet = this.spanExporter.getFirst(SpanKind.CLIENT);
        for (SpanData span : serverSpans) {
            if (((String)span.getAttributes().get(SemanticAttributes.URL_PATH)).contains("MpRestClientAsyncTestEndpoint/mpclient")) {
                firstURL = span;
                continue;
            }
            secondURL = span;
        }
        Assert.assertNotNull(firstURL);
        Assert.assertNotNull(secondURL);
        Assert.assertEquals((String)httpGet.getSpanId(), (String)secondURL.getParentSpanId());
        Assert.assertEquals((String)firstURL.getSpanId(), (String)httpGet.getParentSpanId());
        Assert.assertEquals((int)((Long)secondURL.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)400);
        Assert.assertEquals((String)((String)secondURL.getAttributes().get(SemanticAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)secondURL.getAttributes().get(SemanticAttributes.URL_SCHEME)), (String)"http");
        Assert.assertEquals((int)((Long)httpGet.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)400);
        Assert.assertEquals((String)((String)httpGet.getAttributes().get(SemanticAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertTrue((boolean)((String)httpGet.getAttributes().get(SemanticAttributes.URL_FULL)).contains("MpRestClientAsyncTestEndpoint"));
        Assert.assertEquals((int)((Long)firstURL.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)200);
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(SemanticAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(SemanticAttributes.URL_SCHEME)), (String)"http");
    }
}

