/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RestClientSpanDisabledTest
extends Arquillian {
    @ArquillianResource
    private URL url;
    @Inject
    private InMemorySpanExporter spanExporter;
    private SpanResourceClient client;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=true\notel.traces.exporter=in-memory\notel.metrics.exporter=none"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
            try {
                this.client = (SpanResourceClient)RestClientBuilder.newBuilder().baseUri(this.url.toURI()).build(SpanResourceClient.class);
            }
            catch (IllegalStateException | URISyntaxException | RestClientDefinitionException e) {
                Assert.fail((String)"Failed to create rest client", (Throwable)e);
            }
        }
    }

    @Test
    void span() {
        Response response = this.client.span();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanName() {
        Response response = this.client.spanName("1");
        Assert.assertEquals((int)response.getStatus(), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanNameQuery() {
        Response response = this.client.spanNameQuery("1", "query");
        Assert.assertEquals((int)response.getStatus(), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanError() {
        WebTarget target = ClientBuilder.newClient().target(this.url.toString() + "span/error");
        Response response = target.request().get();
        Assert.assertEquals((int)response.getStatus(), (int)500);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanChild() {
        Response response = this.client.spanChild();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanCurrent() {
        Response response = this.client.spanCurrent();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @Test
    void spanNew() {
        Response response = this.client.spanNew();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        this.spanExporter.getFinishedSpanItems(0);
    }

    @RegisterRestClient(configKey="client")
    @Path(value="/")
    public static interface SpanResourceClient {
        @GET
        @Path(value="/span")
        public Response span();

        @GET
        @Path(value="/span/{name}")
        public Response spanName(@PathParam(value="name") String var1);

        @GET
        @Path(value="/span/{name}")
        public Response spanNameQuery(@PathParam(value="name") String var1, @QueryParam(value="query") String var2);

        @GET
        @Path(value="/span/child")
        public Response spanChild();

        @GET
        @Path(value="/span/current")
        public Response spanCurrent();

        @GET
        @Path(value="/span/new")
        public Response spanNew();
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @ApplicationScoped
    public static class SpanBean {
        @WithSpan
        void spanChild() {
        }
    }

    @RequestScoped
    @Path(value="/")
    public static class SpanResource {
        @Inject
        private SpanBean spanBean;
        @Inject
        private Span span;
        @Inject
        private Tracer tracer;

        @GET
        @Path(value="/span")
        public Response span() {
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/{name}")
        public Response spanName(@PathParam(value="name") String name, @QueryParam(value="query") String query) {
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/error")
        public Response spanError() {
            return Response.serverError().build();
        }

        @GET
        @Path(value="/span/child")
        public Response spanChild() {
            this.spanBean.spanChild();
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/current")
        public Response spanCurrent() {
            this.span.setAttribute("tck.current.key", "tck.current.value");
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/new")
        public Response spanNew() {
            Span span = this.tracer.spanBuilder("span.new").setSpanKind(SpanKind.INTERNAL).setParent(Context.current().with((ImplicitContextKeyed)this.span)).setAttribute("tck.new.key", "tck.new.value").startSpan();
            span.end();
            return Response.ok().build();
        }
    }
}

