/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.TimedClassBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimedClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "TimedClassBean";
    private static final String CONSTRUCTOR_TIMER_NAME = MetricsUtil.absoluteMetricName(TimedClassBean.class, "timedClass", "TimedClassBean");
    private static MetricID constructorMID;
    private static final String[] METHOD_NAMES;
    private static final Set<String> METHOD_TIMER_NAMES;
    private static final MetricFilter METHOD_TIMERS;
    private static final Set<String> TIMER_NAMES;
    private static Set<MetricID> timerMIDs;
    private static Set<MetricID> timerMIDsIncludingToString;
    private static final AtomicLong METHOD_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private TimedClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{TimedClassBean.class, MetricsUtil.class})).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.toString();
        constructorMID = new MetricID(CONSTRUCTOR_TIMER_NAME);
        timerMIDs = MetricsUtil.createMetricIDs(TIMER_NAMES);
        timerMIDsIncludingToString = new HashSet<MetricID>();
        timerMIDsIncludingToString.addAll(timerMIDs);
        timerMIDsIncludingToString.addAll(MetricsUtil.createMetricIDs(MetricsUtil.absoluteMetricNames(TimedClassBean.class, "timedClass", new String[]{"toString"})));
    }

    @Test
    @InSequence(value=1)
    public void timedMethodsNotCalledYet() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(timerMIDsIncludingToString)));
        Assert.assertThat((String)"Constructor timer count is incorrect", (Object)this.registry.getTimer(constructorMID).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Method timer counts are incorrect", this.registry.getTimers(METHOD_TIMERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.get()))));
    }

    @Test
    @InSequence(value=2)
    public void callTimedMethodsOnce() {
        Assert.assertThat((String)"Timers are not registered correctly", this.registry.getTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(timerMIDsIncludingToString)));
        Assert.assertThat((String)"Constructor timer count is incorrect", (Object)this.registry.getTimer(constructorMID).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        this.bean.timedMethodOne();
        this.bean.timedMethodTwo();
        this.bean.timedMethodProtected();
        this.bean.timedMethodPackagedPrivate();
        Assert.assertThat((String)"Method timer counts are incorrect", this.registry.getTimers(METHOD_TIMERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.incrementAndGet()))));
    }

    static {
        METHOD_NAMES = new String[]{"timedMethodOne", "timedMethodTwo", "timedMethodProtected", "timedMethodPackagedPrivate"};
        METHOD_TIMER_NAMES = MetricsUtil.absoluteMetricNames(TimedClassBean.class, "timedClass", METHOD_NAMES);
        METHOD_TIMERS = new MetricFilter(){

            public boolean matches(MetricID metricID, Metric metric) {
                return METHOD_TIMER_NAMES.contains(metricID.getName());
            }
        };
        TIMER_NAMES = MetricsUtil.absoluteMetricNames(TimedClassBean.class, "timedClass", METHOD_NAMES, new String[]{CONSTRUCTOR_NAME});
        METHOD_COUNT = new AtomicLong();
    }
}

