/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.util;

import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.CounterMetric;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.GaugeMetric;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricRegistryProxy;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.RegistryTypeLiteral;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;

public class MetricGetter {
    private MetricRegistryProxy registry;
    private final Tag methodTag;
    private Map<MetricID, CounterMetric> counterMetrics = new HashMap<MetricID, CounterMetric>();
    private Map<MetricID, GaugeMetric> gaugeMetrics = new HashMap<MetricID, GaugeMetric>();

    public MetricGetter(Class<?> clazz, String methodName) {
        this.validateClassAndMethodName(clazz, methodName);
        this.methodTag = new Tag("method", clazz.getCanonicalName() + "." + methodName);
        this.registry = (MetricRegistryProxy)CDI.current().select(MetricRegistryProxy.class, new Annotation[]{RegistryTypeLiteral.BASE}).get();
    }

    public CounterMetric getInvocations(MetricDefinition.InvocationResult result, MetricDefinition.InvocationFallback fallbackUsed) {
        return this.getCounterMetric(this.getMetricId(MetricDefinition.INVOCATIONS, result, fallbackUsed));
    }

    public CounterMetric getRetryCalls(MetricDefinition.RetryRetried retried, MetricDefinition.RetryResult result) {
        return this.getCounterMetric(this.getMetricId(MetricDefinition.RETRY_CALLS, retried, result));
    }

    public CounterMetric getRetryRetries() {
        return this.getCounterMetric(this.getMetricId(MetricDefinition.RETRY_RETRIES, new MetricDefinition.TagValue[0]));
    }

    public CounterMetric getTimeoutCalls(MetricDefinition.TimeoutTimedOut timedOut) {
        return this.getCounterMetric(this.getMetricId(MetricDefinition.TIMEOUT_CALLS, timedOut));
    }

    public Optional<Histogram> getTimeoutExecutionDuration() {
        return this.getMetric(this.getMetricId(MetricDefinition.TIMEOUT_EXECUTION_DURATION, new MetricDefinition.TagValue[0]), Histogram.class);
    }

    public CounterMetric getCircuitBreakerCalls(MetricDefinition.CircuitBreakerResult cbResult) {
        return this.getCounterMetric(this.getMetricId(MetricDefinition.CIRCUITBREAKER_CALLS, cbResult));
    }

    public CounterMetric getCircuitBreakerOpened() {
        return this.getCounterMetric(this.getMetricId(MetricDefinition.CIRCUITBREAKER_OPENED, new MetricDefinition.TagValue[0]));
    }

    public GaugeMetric getCircuitBreakerState(MetricDefinition.CircuitBreakerState cbState) {
        return this.getGaugeMetric(this.getMetricId(MetricDefinition.CIRCUITBREAKER_STATE, cbState));
    }

    public CounterMetric getBulkheadCalls(MetricDefinition.BulkheadResult bulkheadResult) {
        return this.getCounterMetric(this.getMetricId(MetricDefinition.BULKHEAD_CALLS, bulkheadResult));
    }

    public GaugeMetric getBulkheadExecutionsRunning() {
        return this.getGaugeMetric(this.getMetricId(MetricDefinition.BULKHEAD_EXECUTIONS_RUNNING, new MetricDefinition.TagValue[0]));
    }

    public GaugeMetric getBulkheadExecutionsWaiting() {
        return this.getGaugeMetric(this.getMetricId(MetricDefinition.BULKHEAD_EXECUTIONS_WAITING, new MetricDefinition.TagValue[0]));
    }

    public Optional<Histogram> getBulkheadRunningDuration() {
        return this.getMetric(this.getMetricId(MetricDefinition.BULKHEAD_RUNNING_DURATION, new MetricDefinition.TagValue[0]), Histogram.class);
    }

    public Optional<Histogram> getBulkheadWaitingDuration() {
        return this.getMetric(this.getMetricId(MetricDefinition.BULKHEAD_WAITING_DURATION, new MetricDefinition.TagValue[0]), Histogram.class);
    }

    public void baselineMetrics() {
        for (MetricDefinition definition : MetricDefinition.values()) {
            for (MetricDefinition.TagValue[] tags : MetricGetter.getTagCombinations(definition.getTagClasses())) {
                MetricID id = this.getMetricId(definition, tags);
                if (definition.getMetricClass() == Counter.class) {
                    this.getCounterMetric(id).baseline();
                }
                if (definition.getMetricClass() != Gauge.class) continue;
                this.getGaugeMetric(id).baseline();
            }
        }
    }

    @SafeVarargs
    public static final MetricDefinition.TagValue[][] getTagCombinations(Class<? extends MetricDefinition.TagValue> ... tagValueClazzes) {
        int combinations = 1;
        for (Class<? extends MetricDefinition.TagValue> clazz : tagValueClazzes) {
            combinations *= clazz.getEnumConstants().length;
        }
        MetricDefinition.TagValue[][] result = new MetricDefinition.TagValue[combinations][];
        List<List<MetricDefinition.TagValue>> tagLists = MetricGetter.getTagCombinations(Arrays.asList(tagValueClazzes));
        for (int i = 0; i < tagLists.size(); ++i) {
            List<MetricDefinition.TagValue> tagList = tagLists.get(i);
            result[i] = tagList.toArray(new MetricDefinition.TagValue[tagList.size()]);
        }
        return result;
    }

    private static List<List<MetricDefinition.TagValue>> getTagCombinations(List<Class<? extends MetricDefinition.TagValue>> tagValueClazzes) {
        if (tagValueClazzes.isEmpty()) {
            return Collections.singletonList(Collections.emptyList());
        }
        ArrayList<List<MetricDefinition.TagValue>> result = new ArrayList<List<MetricDefinition.TagValue>>();
        Class<? extends MetricDefinition.TagValue> firstClazz = tagValueClazzes.get(0);
        for (MetricDefinition.TagValue value : firstClazz.getEnumConstants()) {
            for (List<MetricDefinition.TagValue> tagList : MetricGetter.getTagCombinations(tagValueClazzes.subList(1, tagValueClazzes.size()))) {
                ArrayList<MetricDefinition.TagValue> newList = new ArrayList<MetricDefinition.TagValue>();
                newList.add(value);
                newList.addAll(tagList);
                result.add(newList);
            }
        }
        return result;
    }

    private MetricID getMetricId(MetricDefinition metricDefinition, MetricDefinition.TagValue ... metricTags) {
        if (metricDefinition.getTagClasses().length != metricTags.length) {
            throw new IllegalArgumentException("Wrong number of arguments passed for " + (Object)((Object)metricDefinition));
        }
        Tag[] tags = new Tag[metricTags.length + 1];
        tags[0] = this.methodTag;
        for (int i = 0; i < metricTags.length; ++i) {
            Class<? extends MetricDefinition.TagValue> argClazz = metricDefinition.getTagClasses()[i];
            if (!argClazz.isInstance(metricTags[i])) {
                throw new IllegalArgumentException("Argument " + i + " has the wrong type. Was " + metricTags[i].getClass() + " but expected " + argClazz);
            }
            tags[i + 1] = metricTags[i].getTag();
        }
        return new MetricID(metricDefinition.getName(), tags);
    }

    private CounterMetric getCounterMetric(MetricID metricId) {
        return this.counterMetrics.computeIfAbsent(metricId, m -> new CounterMetric(this.registry, (MetricID)m));
    }

    private GaugeMetric getGaugeMetric(MetricID metricId) {
        return this.gaugeMetrics.computeIfAbsent(metricId, m -> new GaugeMetric(this.registry, (MetricID)m));
    }

    private <T> Optional<T> getMetric(MetricID id, Class<T> metricType) {
        Metric m = this.registry.getMetrics().get(id);
        if (m != null) {
            MatcherAssert.assertThat((String)("Metric " + id), (Object)m, (Matcher)Matchers.instanceOf(metricType));
            return Optional.of(metricType.cast(m));
        }
        return Optional.empty();
    }

    private void validateClassAndMethodName(Class<?> clazz, String methodName) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return;
        }
        Assert.fail((String)("Couldn't find method " + methodName + " on class " + clazz.getCanonicalName()));
    }
}

