/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.util;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.testng.Assert;

public class Barrier {
    public static final long BARRIER_WAIT_TIME_MS = TCKConfig.getConfig().getTimeoutInMillis(30000L);
    public static final long EXPECTED_FAIL_TIME_MS = TCKConfig.getConfig().getTimeoutInMillis(500L);
    public static final long WAIT_TIME_MS = TCKConfig.getConfig().getTimeoutInMillis(3000L);
    private final CompletableFuture<Void> future = new CompletableFuture();
    private final AtomicInteger counter = new AtomicInteger(0);
    private final CompletableFuture<Void> isWaitingFuture = new CompletableFuture();

    public void await() {
        try {
            this.awaitInterruptably();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while awaiting barrier", (Throwable)e);
        }
    }

    public void awaitInterruptably() throws InterruptedException {
        this.counter.incrementAndGet();
        this.isWaitingFuture.complete(null);
        try {
            this.future.get(BARRIER_WAIT_TIME_MS, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Unexpected exception while awaiting barrier", (Throwable)e);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timed out while awaiting barrier", (Throwable)e);
        }
    }

    public void open() {
        this.future.complete(null);
        this.counter.set(0);
    }

    public int countWaiting() {
        return this.counter.get();
    }

    public void assertAwaits() {
        try {
            this.isWaitingFuture.get(WAIT_TIME_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while checking task is awaiting");
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Unexpected exception while checking task is awaiting", (Throwable)e);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timed out while checking task is awaiting");
        }
    }

    public void assertNotAwaiting() {
        try {
            this.isWaitingFuture.get(EXPECTED_FAIL_TIME_MS, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Task is awaiting");
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while checking task is not awaiting");
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Unexpected exception while checking task is awaiting", (Throwable)e);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void assertAllNotAwaiting(Collection<? extends Barrier> barriers) {
        try {
            Thread.sleep(EXPECTED_FAIL_TIME_MS);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while checking tasks are not awaiting", (Throwable)e);
        }
        for (Barrier barrier : barriers) {
            Assert.assertFalse((boolean)barrier.isWaitingFuture.isDone(), (String)"Task is waiting");
        }
    }
}

