/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import jakarta.inject.Inject;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.AllMetricsBean;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.PullExporterAutoConfigurationCustomizerProvider;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class AllAnnotationTelemetryTest
extends Arquillian {
    @Inject
    private AllMetricsBean allMetricsBean;

    @Deployment
    public static WebArchive deploy() {
        Properties props = new Properties();
        props.put("otel.sdk.disabled", "false");
        props.put("otel.traces.exporter", "none");
        ConfigAnnotationAsset allMetricsBeanConfig = new ConfigAnnotationAsset().autoscaleMethod(AllMetricsBean.class, "doWork").mergeProperties(props);
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftMetricAll.jar")).addClass(AllMetricsBean.class)).addPackage(Packages.UTILS)).addPackage(Packages.TELEMETRY_METRIC_UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)allMetricsBeanConfig, "microprofile-config.properties")).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{PullExporterAutoConfigurationCustomizerProvider.class});
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricAll.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @Test
    public void testAllMetrics() throws InterruptedException, ExecutionException {
        TelemetryMetricGetter m = new TelemetryMetricGetter(AllMetricsBean.class, "doWork");
        m.baselineMetrics();
        this.allMetricsBean.doWork().get();
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"value returned, no retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.VALUE_RETURNED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"exception thrown, no retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max retries reached, no retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.MAX_RETRIES_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max duration reached, no retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.MAX_DURATION_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"value returned after retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.VALUE_RETURNED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"exception thrown after retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max retries reached after retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.MAX_RETRIES_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"max duration reached after retry", (Object)m.getRetryCalls(TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.MAX_DURATION_REACHED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"timeout execution duration histogram present", (Object)m.getTimeoutExecutionDuration().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"timed out calls", (Object)m.getTimeoutCalls(TelemetryMetricDefinition.TimeoutTimedOut.TRUE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"non timed out calls", (Object)m.getTimeoutCalls(TelemetryMetricDefinition.TimeoutTimedOut.FALSE).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuitbreaker succeeded calls", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.SUCCESS).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"circuitbreaker failed calls", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.FAILURE).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker prevented calls", (Object)m.getCircuitBreakerCalls(TelemetryMetricDefinition.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker closed time", (Object)m.getCircuitBreakerState(TelemetryMetricDefinition.CircuitBreakerState.CLOSED).delta(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((String)"circuitbreaker half open time", (Object)m.getCircuitBreakerState(TelemetryMetricDefinition.CircuitBreakerState.HALF_OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker open time", (Object)m.getCircuitBreakerState(TelemetryMetricDefinition.CircuitBreakerState.OPEN).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"circuitbreaker times opened", (Object)m.getCircuitBreakerOpened().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead accepted calls", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.ACCEPTED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"bulkhead rejected calls", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.REJECTED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead executions running present", (Object)m.getBulkheadExecutionsRunning().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"bulkhead executions running value", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead running duration histogram present", (Object)m.getBulkheadRunningDuration().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"bulkhead executions waiting present", (Object)m.getBulkheadExecutionsWaiting().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"bulkhead executions waiting value", (Object)m.getBulkheadExecutionsWaiting().value(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead queue wait time histogram present", (Object)m.getBulkheadRunningDuration().isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

