/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.sdk.metrics.data.LongPointData;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricID;

public class TelemetryGaugeMetric {
    private TelemetryMetricID metricId;
    private long baseline;

    public TelemetryGaugeMetric(TelemetryMetricID metricId) {
        this.metricId = metricId;
        this.baseline = 0L;
    }

    public long value() {
        InMemoryMetricReader reader = (InMemoryMetricReader)CDI.current().select(InMemoryMetricReader.class, new Annotation[0]).get();
        Optional<LongPointData> latest = reader.getGaugueMetricLatestValue(this.metricId);
        if (latest.isPresent()) {
            return latest.get().getValue();
        }
        return 0L;
    }

    public boolean isPresent() {
        InMemoryMetricReader exporter = (InMemoryMetricReader)CDI.current().select(InMemoryMetricReader.class, new Annotation[0]).get();
        Optional<LongPointData> latest = exporter.getGaugueMetricLatestValue(this.metricId);
        return latest.isPresent();
    }

    public void baseline() {
        this.baseline = this.value();
    }

    public long delta() {
        return this.value() - this.baseline;
    }
}

