/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.BulkheadMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.util.TimeUtils;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.PullExporterAutoConfigurationCustomizerProvider;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class BulkheadTelemetryTest
extends Arquillian {
    @Inject
    private BulkheadMetricBean bulkheadBean;
    @Inject
    private AsyncCaller async;
    private TCKConfig config = TCKConfig.getConfig();
    private List<CompletableFuture<Void>> waitingFutures = new ArrayList<CompletableFuture<Void>>();

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricBulkhead.war")).addClasses(new Class[]{BulkheadMetricBean.class, TimeUtils.class})).addPackage(Packages.UTILS)).addPackage(Packages.TELEMETRY_METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=none"), "META-INF/microprofile-config.properties")).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{PullExporterAutoConfigurationCustomizerProvider.class});
        return war;
    }

    @AfterMethod
    public void completeWaitingFutures() {
        for (CompletableFuture<Void> future : this.waitingFutures) {
            future.complete(null);
        }
        this.waitingFutures.clear();
    }

    private CompletableFuture<Void> newWaitingFuture() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.waitingFutures.add(result);
        return result;
    }

    @Test(groups={"main"})
    public void bulkheadMetricTest() throws InterruptedException, ExecutionException, TimeoutException {
        System.out.println("GREP + bulkheadMetricTest start");
        TelemetryMetricGetter m = new TelemetryMetricGetter(BulkheadMetricBean.class, "waitFor");
        m.baselineMetrics();
        System.out.println("GREP + bulkheadMetricTest after baseline");
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        Future<Void> f2 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        System.out.println("GREP + bulkheadMetricTest before fail");
        this.bulkheadBean.waitForRunningExecutions(2);
        MatcherAssert.assertThat((String)"executions running", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)2L));
        waitingFuture.complete(null);
        f1.get(1L, TimeUnit.MINUTES);
        f2.get(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((String)"executions running", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"accepted calls", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.ACCEPTED).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"rejected calls", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.REJECTED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"bulkhead executions waiting present", (Object)m.getBulkheadExecutionsWaiting().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"bulkhead waiting duration present", (Object)m.getBulkheadWaitingDuration().isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"successful invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test(groups={"main"})
    public void bulkheadMetricRejectionTest() throws InterruptedException, ExecutionException, TimeoutException {
        TelemetryMetricGetter m = new TelemetryMetricGetter(BulkheadMetricBean.class, "waitFor");
        m.baselineMetrics();
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        Future<Void> f2 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        this.bulkheadBean.waitForRunningExecutions(2);
        Future<Void> f3 = this.async.run(() -> this.bulkheadBean.waitFor(waitingFuture));
        Exceptions.expectBulkheadException(f3);
        MatcherAssert.assertThat((String)"executions running", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)2L));
        waitingFuture.complete(null);
        f1.get(1L, TimeUnit.MINUTES);
        f2.get(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((String)"executions running", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"accepted calls", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.ACCEPTED).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"rejected calls", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.REJECTED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(groups={"main"})
    public void bulkheadMetricHistogramTest() throws InterruptedException, ExecutionException, TimeoutException {
        TelemetryMetricGetter m = new TelemetryMetricGetter(BulkheadMetricBean.class, "waitForHistogram");
        m.baselineMetrics();
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.async.run(() -> this.bulkheadBean.waitForHistogram(waitingFuture));
        Future<Void> f2 = this.async.run(() -> this.bulkheadBean.waitForHistogram(waitingFuture));
        this.bulkheadBean.waitForRunningExecutions(2);
        Future<Void> f3 = this.async.run(() -> this.bulkheadBean.waitForHistogram(waitingFuture));
        Exceptions.expectBulkheadException(f3);
        Thread.sleep(this.config.getTimeoutInMillis(1000L));
        waitingFuture.complete(null);
        f1.get(1L, TimeUnit.MINUTES);
        f2.get(1L, TimeUnit.MINUTES);
        Long executionTimesCount = m.getBulkheadRunningDuration().getHistogramCount().get();
        MatcherAssert.assertThat((String)"histogram count", (Object)executionTimesCount, (Matcher)Matchers.is((Object)2L));
        Collection<HistogramPointData> executionTimesPoints = m.getBulkheadRunningDuration().getHistogramPoints();
        double time = executionTimesPoints.stream().mapToDouble(points -> points.getSum()).sum();
        long count = executionTimesPoints.stream().mapToLong(points -> points.getCount()).sum();
        MatcherAssert.assertThat((String)"mean", (Object)Math.round(time / (double)count), TimeUtils.approxMillis(1000L));
        this.bulkheadBean.waitForHistogram(CompletableFuture.completedFuture(null));
        this.bulkheadBean.waitForHistogram(CompletableFuture.completedFuture(null));
        executionTimesCount = m.getBulkheadRunningDuration().getHistogramCount().get();
        MatcherAssert.assertThat((String)"histogram count", (Object)executionTimesCount, (Matcher)Matchers.is((Object)4L));
    }

    @Test(groups={"main"})
    public void bulkheadMetricAsyncTest() throws InterruptedException, ExecutionException, TimeoutException {
        TelemetryMetricGetter m = new TelemetryMetricGetter(BulkheadMetricBean.class, "waitForAsync");
        m.baselineMetrics();
        CompletableFuture<Void> waitingFuture = this.newWaitingFuture();
        Future<Void> f1 = this.bulkheadBean.waitForAsync(waitingFuture);
        Future<Void> f2 = this.bulkheadBean.waitForAsync(waitingFuture);
        this.bulkheadBean.waitForRunningExecutions(2);
        Future<Void> f3 = this.bulkheadBean.waitForAsync(waitingFuture);
        Future<Void> f4 = this.bulkheadBean.waitForAsync(waitingFuture);
        this.waitForQueuePopulation(m, 2, this.config.getTimeoutInMillis(2000L));
        Exceptions.expectBulkheadException(this.bulkheadBean.waitForAsync(waitingFuture));
        MatcherAssert.assertThat((String)"executions running", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"executions waiting", (Object)m.getBulkheadExecutionsWaiting().value(), (Matcher)Matchers.is((Object)2L));
        Thread.sleep(this.config.getTimeoutInMillis(1000L));
        waitingFuture.complete(null);
        f1.get(1L, TimeUnit.MINUTES);
        f2.get(1L, TimeUnit.MINUTES);
        f3.get(1L, TimeUnit.MINUTES);
        f4.get(1L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((String)"executions running", (Object)m.getBulkheadExecutionsRunning().value(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"accepted calls", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.ACCEPTED).delta(), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((String)"rejections", (Object)m.getBulkheadCalls(TelemetryMetricDefinition.BulkheadResult.REJECTED).delta(), (Matcher)Matchers.is((Object)1L));
        Long queueWaits = m.getBulkheadWaitingDuration().getHistogramCount().get();
        MatcherAssert.assertThat((String)"waiting duration histogram counts", (Object)queueWaits, (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((String)"successful invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dependsOnGroups={"main"})
    public void testMetricUnits() throws InterruptedException, ExecutionException {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        for (TelemetryMetricDefinition metric : TelemetryMetricDefinition.values()) {
            if (!metric.getName().startsWith("ft.bulkhead")) continue;
            String unit = reader.getUnit(metric.getName());
            if (metric.getUnit() == null) {
                Assert.assertTrue((boolean)unit.isEmpty(), (String)("Unexpected metadata for metric " + metric.getName()));
                continue;
            }
            Assert.assertFalse((boolean)unit.isEmpty(), (String)("Missing metadata for metric " + metric.getName()));
            Assert.assertEquals((String)unit, (String)metric.getUnit(), (String)("Incorrect unit for metric " + metric.getName()));
        }
    }

    private void waitForQueuePopulation(TelemetryMetricGetter m, int expectedQueuePopulation, long timeoutInMs) throws InterruptedException {
        long timeoutTime = System.currentTimeMillis() + timeoutInMs;
        while (System.currentTimeMillis() < timeoutTime) {
            if (m.getBulkheadExecutionsWaiting().value() == (long)expectedQueuePopulation) {
                return;
            }
            Thread.sleep(100L);
        }
    }
}

