/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithTimeout;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class CircuitBreakerTimeoutTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientWithTimeout timeoutClient;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(CircuitBreakerClientWithTimeout.class, "serviceWithTimeout").autoscaleMethod(CircuitBreakerClientWithTimeout.class, "serviceWithTimeoutWithoutFailOn");
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerTimeout.jar")).addClasses(new Class[]{CircuitBreakerClientWithTimeout.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerTimeout.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testTimeout() {
        for (int i = 0; i < 2; ++i) {
            Exceptions.expectTimeout(() -> this.timeoutClient.serviceWithTimeout());
        }
        Exceptions.expectCbOpen(() -> this.timeoutClient.serviceWithTimeout());
    }

    @Test
    public void testTimeoutWithoutFailOn() {
        for (int i = 0; i < 2; ++i) {
            Exceptions.expectTimeout(() -> this.timeoutClient.serviceWithTimeoutWithoutFailOn());
        }
        Exceptions.expectTimeout(() -> this.timeoutClient.serviceWithTimeoutWithoutFailOn());
    }
}

