/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.Arrays;
import java.util.Map;

public class TelemetryMetricID {
    public final String name;
    public final Attributes attributes;

    public TelemetryMetricID(String classMethodName, Attributes attributes) {
        this.name = classMethodName;
        this.attributes = attributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name + " Attributes:");
        for (AttributeKey key : this.attributes.asMap().keySet()) {
            sb.append("[" + key.toString() + "=" + this.attributes.asMap().get(key).toString() + "]");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        TelemetryMetricID other = (TelemetryMetricID)o;
        if (this.name != other.name) {
            return false;
        }
        if (this.attributes.size() != other.attributes.size()) {
            return false;
        }
        for (AttributeKey key : this.attributes.asMap().keySet()) {
            if (this.attributes.get(key) == other.attributes.get(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        Map map = this.attributes.asMap();
        Object[] names = map.entrySet().toArray();
        Object[] value = map.keySet().toArray();
        int namesHash = Arrays.deepHashCode(names);
        int valuesHash = Arrays.deepHashCode(value);
        int hash = 17;
        hash = hash * 31 + namesHash;
        hash = hash * 31 + valuesHash;
        hash = hash * 31 + this.name.hashCode();
        return hash;
    }
}

