/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.browser.QueryContextHelp;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsTable;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsWizard;
import org.eclipse.mat.ui.internal.query.arguments.LinkEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ArgumentsWizardPage
extends WizardPage
implements ArgumentsTable.ITableListener {
    public static final String HIDE_QUERY_HELP = "pref:HideQueryHelp";
    private IQueryContext context;
    private ArgumentSet argumentSet;
    private ArgumentsTable table;
    private QueryContextHelp helpPopup;

    public ArgumentsWizardPage(IQueryContext context, ArgumentSet argumentSet) {
        super(Messages.ArgumentsWizardPage_QueryArguments, argumentSet.getQueryDescriptor().getName(), null);
        this.setDescription(argumentSet.getQueryDescriptor().getShortDescription());
        this.context = context;
        this.argumentSet = argumentSet;
    }

    public void createControl(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 2816);
        composite.setLayout((Layout)new GridLayout());
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite tableComposite = new Composite((Composite)composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 0).applyTo((Control)tableComposite);
        LinkEditor.Mode mode = LinkEditor.Mode.SIMPLE_MODE;
        if (this.getDialogSettings().get(ArgumentsWizard.class.getName()) != null && LinkEditor.Mode.ADVANCED_MODE.getModeType().equals(this.getDialogSettings().get(ArgumentsWizard.class.getName()))) {
            mode = LinkEditor.Mode.ADVANCED_MODE;
        }
        Dialog.applyDialogFont((Control)composite);
        this.table = new ArgumentsTable(tableComposite, 65540, this.context, this.argumentSet, mode);
        this.table.addListener(this);
        tableComposite.layout();
        tableComposite.pack();
        composite.setContent((Control)tableComposite);
        this.setControl((Control)composite);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ArgumentsWizardPage.this.relocateHelp(false);
            }
        };
        this.getShell().addListener(11, listener);
        this.getShell().addListener(10, listener);
        IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
        if (!prefs.getBoolean(HIDE_QUERY_HELP)) {
            this.relocateHelp(true);
        }
    }

    public boolean isPageComplete() {
        return this.argumentSet.isExecutable() && this.getErrorMessage() == null;
    }

    @Override
    public void onInputChanged() {
        this.getContainer().updateButtons();
    }

    @Override
    public void onError(String message) {
        this.setErrorMessage(message);
        this.onFocus(null);
    }

    @Override
    public void onFocus(String message) {
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage(), 3);
        } else if (message != null) {
            this.setMessage(message, 1);
        } else {
            this.setMessage(this.argumentSet.getQueryDescriptor().getShortDescription());
        }
        if (this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
    }

    @Override
    public void onModeChange(LinkEditor.Mode mode) {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(ArgumentsWizard.class.getName(), mode.getModeType());
    }

    public void relocateHelp(boolean create) {
        if (this.argumentSet.getQueryDescriptor().isHelpAvailable() && (create || this.helpPopup != null && this.helpPopup.getShell() != null)) {
            if (this.getShell() == null) {
                if (this.helpPopup != null) {
                    this.helpPopup.close();
                    this.helpPopup = null;
                }
                return;
            }
            this.getShell().getDisplay().timerExec(100, new Runnable(){

                @Override
                public void run() {
                    if (ArgumentsWizardPage.this.getShell() != null && !ArgumentsWizardPage.this.getShell().isDisposed()) {
                        Rectangle myBounds = ArgumentsWizardPage.this.getShell().getBounds();
                        Rectangle helpBounds = new Rectangle(myBounds.x, myBounds.y + myBounds.height, myBounds.width, -1);
                        if (ArgumentsWizardPage.this.helpPopup != null && ArgumentsWizardPage.this.helpPopup.getShell() != null) {
                            ArgumentsWizardPage.this.helpPopup.resize(helpBounds);
                            return;
                        }
                        ArgumentsWizardPage.this.helpPopup = new QueryContextHelp(ArgumentsWizardPage.this.getShell(), (IAnnotatedObjectDescriptor)ArgumentsWizardPage.this.argumentSet.getQueryDescriptor(), helpBounds);
                        ArgumentsWizardPage.this.helpPopup.open();
                    }
                }
            });
        }
    }

    public void performHelp() {
        String helpUrl = this.argumentSet.getQueryDescriptor().getHelpUrl();
        if (helpUrl != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpUrl);
        }
        this.relocateHelp(true);
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.mat.ui.help.query_arguments");
    }
}

