/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.lsp4mp.commons.MicroProfileJavaProjectLabelsParams;
import org.eclipse.lsp4mp.commons.ProjectLabelInfoEntry;
import org.eclipse.lsp4mp.jdt.core.ProjectLabelDefinition;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.core.ProjectLabelRegistry;

public class ProjectLabelManager {
    private static final ProjectLabelManager INSTANCE = new ProjectLabelManager();

    public static ProjectLabelManager getInstance() {
        return INSTANCE;
    }

    private ProjectLabelManager() {
    }

    public List<ProjectLabelInfoEntry> getProjectLabelInfo() {
        IProject[] projects;
        ArrayList<ProjectLabelInfoEntry> results = new ArrayList<ProjectLabelInfoEntry>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ProjectLabelInfoEntry info = this.getProjectLabelInfo(project, null);
            if (info != null) {
                results.add(info);
            }
            ++n2;
        }
        return results;
    }

    private ProjectLabelInfoEntry getProjectLabelInfo(IProject project, List<String> types) {
        String uri = JDTMicroProfileUtils.getProjectURI(project);
        if (uri != null) {
            return new ProjectLabelInfoEntry(uri, project.getName(), this.getProjectLabels(project, types));
        }
        return null;
    }

    public ProjectLabelInfoEntry getProjectLabelInfo(MicroProfileJavaProjectLabelsParams params, IJDTUtils utils, IProgressMonitor monitor) {
        IFile file = utils.findFile(params.getUri());
        if (file == null || file.getProject() == null) {
            return ProjectLabelInfoEntry.EMPTY_PROJECT_INFO;
        }
        return this.getProjectLabelInfo(file.getProject(), params.getTypes());
    }

    private List<String> getProjectLabels(IProject project, List<String> types) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return Collections.emptyList();
        }
        ArrayList<String> projectLabels = new ArrayList<String>();
        List<ProjectLabelDefinition> definitions = ProjectLabelRegistry.getInstance().getProjectLabelDefinitions();
        for (ProjectLabelDefinition definition : definitions) {
            projectLabels.addAll(definition.getProjectLabels(javaProject));
        }
        if (types != null) {
            for (String type : types) {
                if (JDTTypeUtils.findType(javaProject, type) == null) continue;
                projectLabels.add(type);
            }
        }
        return projectLabels;
    }
}

