/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.reactivemessaging.java;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.reactivemessaging.java.MicroProfileReactiveMessagingErrorCode;

public class MicroProfileReactiveMessagingASTValidator
extends JavaASTValidator {
    private static final String BLANK_CHANNEL_NAME_MESSAGE = "The name of the consumed channel must not be blank.";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final Logger LOGGER = Logger.getLogger(MicroProfileReactiveMessagingASTValidator.class.getName());

    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        boolean adapted = JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.reactive.messaging.Incoming") != null || JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.reactive.messaging.Outgoing") != null;
        return adapted;
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.validateIncomingOutgoingAnnotation((Annotation)node);
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        this.validateIncomingOutgoingAnnotation((Annotation)node);
        return false;
    }

    private void validateIncomingOutgoingAnnotation(Annotation node) {
        try {
            Expression expression = AnnotationUtils.getAnnotationMemberValueExpression(node, ATTRIBUTE_VALUE);
            if (expression != null && expression.getNodeType() == 45 && ((StringLiteral)expression).getLiteralValue().isBlank()) {
                super.addDiagnostic(BLANK_CHANNEL_NAME_MESSAGE, "microprofile-reactive-messaging", (ASTNode)expression, MicroProfileReactiveMessagingErrorCode.BLANK_CHANNEL_NAME, DiagnosticSeverity.Error);
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.WARNING, "Exception when trying to validate @Incoming/@Outgoing annotation", e);
        }
    }
}

