/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.beanvalidation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.TypeHierarchyUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.beanvalidation.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.beanvalidation.ErrorCode;
import org.eclipse.lsp4jakarta.jdt.internal.core.java.ManagedBean;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;

public class BeanValidationDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        String uri = context.getUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            Range range;
            String matchedAnnotation;
            IAnnotation annotation;
            int n3;
            int n4;
            IAnnotation[] iAnnotationArray;
            IAnnotation[] annotations;
            IField[] allFields;
            IType type = iTypeArray[n2];
            IField[] iFieldArray = allFields = type.getFields();
            int n5 = allFields.length;
            int n6 = 0;
            while (n6 < n5) {
                IField field = iFieldArray[n6];
                iAnnotationArray = annotations = field.getAnnotations();
                n4 = annotations.length;
                n3 = 0;
                while (n3 < n4) {
                    annotation = iAnnotationArray[n3];
                    matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), Constants.SET_OF_ANNOTATIONS.toArray(new String[0]));
                    if (matchedAnnotation != null) {
                        range = PositionUtils.toNameRange(field, context.getUtils());
                        this.validAnnotation(context, uri, (IMember)field, range, annotation, matchedAnnotation, diagnostics);
                    }
                    ++n3;
                }
                ++n6;
            }
            IMethod[] allMethods = type.getMethods();
            iFieldArray = allMethods;
            n5 = allMethods.length;
            n6 = 0;
            while (n6 < n5) {
                IField method = iFieldArray[n6];
                iAnnotationArray = annotations = method.getAnnotations();
                n4 = annotations.length;
                n3 = 0;
                while (n3 < n4) {
                    annotation = iAnnotationArray[n3];
                    matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), Constants.SET_OF_ANNOTATIONS.toArray(new String[0]));
                    if (matchedAnnotation != null) {
                        range = PositionUtils.toNameRange((IMethod)method, context.getUtils());
                        this.validAnnotation(context, uri, (IMember)method, range, annotation, matchedAnnotation, diagnostics);
                    }
                    ++n3;
                }
                ++n6;
            }
            ++n2;
        }
        return diagnostics;
    }

    private void validAnnotation(JavaDiagnosticsContext context, String uri, IMember element, Range range, IAnnotation annotation, String matchedAnnotation, List<Diagnostic> diagnostics) throws CoreException {
        IType declaringType = element.getDeclaringType();
        if (declaringType != null) {
            String annotationName = annotation.getElementName();
            boolean isMethod = element instanceof IMethod;
            if (Flags.isStatic((int)element.getFlags())) {
                String message = isMethod ? Messages.getMessage("ConstraintAnnotationsMethod", new Object[0]) : Messages.getMessage("ConstraintAnnotationsField", new Object[0]);
                diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidConstrainAnnotationOnStaticMethodOrField, DiagnosticSeverity.Error));
            } else {
                String type;
                String string = type = isMethod ? ((IMethod)element).getReturnType() : ((IField)element).getTypeSignature();
                if (matchedAnnotation.equals("jakarta.validation.constraints.AssertFalse") || matchedAnnotation.equals("jakarta.validation.constraints.AssertTrue")) {
                    String message;
                    String dataTypeFQName = DiagnosticUtils.getMatchedJavaElementName(declaringType, BeanValidationDiagnosticsParticipant.getDataTypeName(type), new String[]{"java.lang.Boolean"});
                    String string2 = message = isMethod ? Messages.getMessage("AnnotationBooleanMethods", "@" + annotationName) : Messages.getMessage("AnnotationBooleanFields", "@" + annotationName);
                    if (dataTypeFQName == null && !type.equals("Z")) {
                        diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidAnnotationOnNonBooleanMethodOrField, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.DecimalMax") || matchedAnnotation.equals("jakarta.validation.constraints.DecimalMin") || matchedAnnotation.equals("jakarta.validation.constraints.Digits")) {
                    String dataTypeFQName = DiagnosticUtils.getMatchedJavaElementName(declaringType, BeanValidationDiagnosticsParticipant.getDataTypeName(type), Constants.NUMERIC_AND_CHAR_WRAPPER_TYPES);
                    if (!(dataTypeFQName != null || type.equals("B") || type.equals("S") || type.equals("I") || type.equals("J"))) {
                        String message = isMethod ? Messages.getMessage("AnnotationBigDecimalMethods", "@" + annotationName) : Messages.getMessage("AnnotationBigDecimalFields", "@" + annotationName);
                        diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidAnnotationOnNonBigDecimalCharByteShortIntLongMethodOrField, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Email")) {
                    this.checkStringOnly(context, uri, range, diagnostics, annotationName, isMethod, type, matchedAnnotation, declaringType);
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.NotBlank")) {
                    this.checkStringOnly(context, uri, range, diagnostics, annotationName, isMethod, type, matchedAnnotation, declaringType);
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Pattern")) {
                    this.checkStringOnly(context, uri, range, diagnostics, annotationName, isMethod, type, matchedAnnotation, declaringType);
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Future") || matchedAnnotation.equals("jakarta.validation.constraints.FutureOrPresent") || matchedAnnotation.equals("jakarta.validation.constraints.Past") || matchedAnnotation.equals("jakarta.validation.constraints.PastOrPresent")) {
                    String dataType = BeanValidationDiagnosticsParticipant.getDataTypeName(type);
                    String dataTypeFQName = DiagnosticUtils.getMatchedJavaElementName(declaringType, dataType, Constants.SET_OF_DATE_TYPES.toArray(new String[0]));
                    if (dataTypeFQName == null) {
                        String message = isMethod ? Messages.getMessage("AnnotationDateMethods", "@" + annotationName) : Messages.getMessage("AnnotationDateFields", "@" + annotationName);
                        diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidAnnotationOnNonDateTimeMethodOrField, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Min") || matchedAnnotation.equals("jakarta.validation.constraints.Max")) {
                    String dataTypeFQName = DiagnosticUtils.getMatchedJavaElementName(declaringType, BeanValidationDiagnosticsParticipant.getDataTypeName(type), Constants.NUMERIC_WRAPPER_TYPES);
                    if (!(dataTypeFQName != null || type.equals("B") || type.equals("S") || type.equals("I") || type.equals("J"))) {
                        String message = isMethod ? Messages.getMessage("AnnotationMinMaxMethods", "@" + annotationName) : Messages.getMessage("AnnotationMinMaxFields", "@" + annotationName);
                        diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidAnnotationOnNonMinMaxMethodOrField, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Negative") || matchedAnnotation.equals("jakarta.validation.constraints.NegativeOrZero") || matchedAnnotation.equals("jakarta.validation.constraints.Positive") || matchedAnnotation.equals("jakarta.validation.constraints.PositiveOrZero")) {
                    String dataTypeFQName = DiagnosticUtils.getMatchedJavaElementName(declaringType, BeanValidationDiagnosticsParticipant.getDataTypeName(type), Constants.NUMERIC_AND_DECIMAL_WRAPPER_TYPES);
                    if (!(dataTypeFQName != null || type.equals("B") || type.equals("S") || type.equals("I") || type.equals("J") || type.equals("F") || type.equals("D"))) {
                        String message = isMethod ? Messages.getMessage("AnnotationPositiveMethods", "@" + annotationName) : Messages.getMessage("AnnotationPositiveFields", "@" + annotationName);
                        diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidAnnotationOnNonPositiveMethodOrField, DiagnosticSeverity.Error));
                    }
                } else if ((matchedAnnotation.equals("jakarta.validation.constraints.NotEmpty") || matchedAnnotation.equals("jakarta.validation.constraints.Size")) && !this.isSizeOrNonEmptyAllowed(declaringType, type)) {
                    String message = isMethod ? Messages.getMessage("SizeOrNonEmptyAnnotationsMethod", new Object[0]) : Messages.getMessage("SizeOrNonEmptyAnnotationsField", new Object[0]);
                    diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidAnnotationOnNonSizeMethodOrField, DiagnosticSeverity.Error));
                }
            }
        }
    }

    boolean isSizeOrNonEmptyAllowed(IType parentType, String childTypeString) throws CoreException {
        if (BeanValidationDiagnosticsParticipant.isArrayType(childTypeString)) {
            return true;
        }
        if (Constants.PRIMITIVE_TYPES.contains(childTypeString)) {
            return false;
        }
        IType fieldType = ManagedBean.getChildITypeByName(parentType, BeanValidationDiagnosticsParticipant.getDataTypeName(childTypeString));
        return fieldType != null && (this.doesITypeHaveSuperType(fieldType, "java.lang.CharSequence") || this.doesITypeHaveSuperType(fieldType, "java.util.Collection") || this.doesITypeHaveSuperType(fieldType, "java.util.Map"));
    }

    private void checkStringOnly(JavaDiagnosticsContext context, String uri, Range range, List<Diagnostic> diagnostics, String annotationName, boolean isMethod, String type, String matchedAnnotation, IType declaringType) throws JavaModelException {
        String dataTypeFQName = DiagnosticUtils.getMatchedJavaElementName(declaringType, BeanValidationDiagnosticsParticipant.getDataTypeName(type), new String[]{"java.lang.String", "java.lang.CharSequence"});
        if (dataTypeFQName == null) {
            String message = isMethod ? Messages.getMessage("AnnotationStringMethods", "@" + annotationName) : Messages.getMessage("AnnotationStringFields", "@" + annotationName);
            diagnostics.add(context.createDiagnostic(uri, message, range, "jakarta-bean-validation", matchedAnnotation, ErrorCode.InvalidAnnotationOnNonStringMethodOrField, DiagnosticSeverity.Error));
        }
    }

    private static String getDataTypeName(String type) {
        int length = type.length();
        if (length > 0 && type.charAt(0) == 'Q' && type.charAt(length - 1) == ';') {
            return type.substring(1, length - 1);
        }
        return type;
    }

    private boolean doesITypeHaveSuperType(IType fieldType, String superType) throws CoreException {
        return TypeHierarchyUtils.doesITypeHaveSuperType(fieldType, superType) == 1;
    }

    public static boolean isArrayType(String childTypeString) {
        return childTypeString != null && childTypeString.startsWith("[");
    }
}

