/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.InsertAnnotationProposal;

public class ModifyAnnotationProposal
extends InsertAnnotationProposal {
    private final List<String> attributesToAdd;
    private final List<String> attributesToRemove;

    public ModifyAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, String annotation, List<String> attributesToAdd, List<String> attributesToRemove) {
        super(label, targetCU, invocationNode, binding, relevance, annotation);
        this.attributesToAdd = attributesToAdd;
        this.attributesToRemove = attributesToRemove;
    }

    public ModifyAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, String annotation, List<String> attributesToAdd) {
        super(label, targetCU, invocationNode, binding, relevance, annotation);
        this.attributesToAdd = attributesToAdd;
        this.attributesToRemove = new ArrayList<String>();
    }

    public ModifyAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, List<String> attributesToAdd, String ... annotations) {
        super(label, targetCU, invocationNode, binding, relevance, annotations);
        this.attributesToAdd = attributesToAdd;
        this.attributesToRemove = new ArrayList<String>();
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit fInvocationNode = this.getInvocationNode();
        IBinding fBinding = this.getBinding();
        String[] annotations = this.getAnnotations();
        String[] annotationShortNames = new String[annotations.length];
        int i = 0;
        while (i < annotations.length) {
            String shortName;
            annotationShortNames[i] = shortName = annotations[i].substring(annotations[i].lastIndexOf(".") + 1, annotations[i].length());
            ++i;
        }
        ASTNode declNode = null;
        ASTNode boundNode = fInvocationNode.findDeclaringNode(fBinding);
        CompilationUnit newRoot = fInvocationNode;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(fBinding.getKey());
        }
        ImportRewrite imports = this.createImportRewrite(newRoot);
        boolean isField = declNode instanceof VariableDeclarationFragment;
        boolean isSingleVarDecl = declNode instanceof SingleVariableDeclaration;
        boolean cfr_ignored_0 = declNode instanceof SingleMemberAnnotation;
        if (isField) {
            declNode = declNode.getParent();
        }
        if (declNode.getNodeType() == 23) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(declNode, imports);
            ArrayList<Annotation> existingAnnotations = new ArrayList<Annotation>();
            List children = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS2_PROPERTY);
            for (ASTNode child : children) {
                if (!(child instanceof Annotation)) continue;
                Annotation annotation = (Annotation)child;
                boolean containsAnnotation = Arrays.stream(annotationShortNames).anyMatch(annotation.getTypeName().toString()::contains);
                if (!containsAnnotation || !(child instanceof NormalAnnotation)) continue;
                List existingValues = ((NormalAnnotation)child).values().stream().map(mvp -> ((MemberValuePair)mvp).getName().toString()).collect(Collectors.toList());
                boolean containsAllToAdd = this.attributesToAdd.stream().allMatch(attr -> existingValues.stream().anyMatch(v -> v.equals(attr)));
                boolean containsAnyToRemove = this.attributesToRemove.stream().anyMatch(attr -> existingValues.stream().anyMatch(v -> v.equals(attr)));
                if (containsAllToAdd && !containsAnyToRemove) continue;
                existingAnnotations.add(annotation);
                rewrite.remove(child, null);
            }
            for (Annotation a : existingAnnotations) {
                if (!(a instanceof NormalAnnotation)) continue;
                NormalAnnotation marker = null;
                marker = this.processNormalAnnotation(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, annotations, (NormalAnnotation)a);
                rewrite.getListRewrite(declNode, isField ? FieldDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
            }
            return rewrite;
        }
        if (declNode instanceof TypeDeclaration || isField || isSingleVarDecl) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(declNode, imports);
            ArrayList<Annotation> existingAnnotations = new ArrayList<Annotation>();
            ChildListPropertyDescriptor property = isSingleVarDecl ? SingleVariableDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY;
            List children = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)property);
            for (ASTNode child : children) {
                if (!(child instanceof Annotation)) continue;
                Annotation annotation = (Annotation)child;
                boolean containsAnnotation = Arrays.stream(annotationShortNames).anyMatch(annotation.getTypeName().toString()::contains);
                if (!containsAnnotation) continue;
                existingAnnotations.add(annotation);
                rewrite.remove(child, null);
            }
            String[] stringArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                NormalAnnotation newAnnotationToWrite = null;
                if (!existingAnnotations.isEmpty()) {
                    for (Annotation a : existingAnnotations) {
                        if (a instanceof SingleMemberAnnotation) {
                            newAnnotationToWrite = this.processSingleMemberAnnotation(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, annotations, (SingleMemberAnnotation)a);
                            continue;
                        }
                        if (!(a instanceof NormalAnnotation)) continue;
                        newAnnotationToWrite = this.processNormalAnnotation(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, annotations, (NormalAnnotation)a);
                    }
                } else {
                    newAnnotationToWrite = this.createNewAnnotation(ast, imports, (ImportRewrite.ImportRewriteContext)importRewriteContext, annotation);
                }
                ChildListPropertyDescriptor newRewrite = isSingleVarDecl ? SingleVariableDeclaration.MODIFIERS2_PROPERTY : (isField ? FieldDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY);
                rewrite.getListRewrite(declNode, newRewrite).insertFirst((ASTNode)newAnnotationToWrite, null);
                ++n2;
            }
            return rewrite;
        }
        return null;
    }

    private SingleMemberAnnotation processSingleMemberAnnotation(AST ast, ImportRewrite imports, ImportRewrite.ImportRewriteContext importRWCtx, String[] annotations, SingleMemberAnnotation annotationToProcess) {
        SingleMemberAnnotation newSingleMemberAnnotation = ast.newSingleMemberAnnotation();
        ArrayInitializer newAIInstance = (ArrayInitializer)ast.createInstance(ArrayInitializer.class);
        newSingleMemberAnnotation.setTypeName(ast.newName(imports.addImport(annotationToProcess.getTypeName().toString(), importRWCtx)));
        List newCompositeAnnotationContents = newAIInstance.expressions();
        ArrayInitializer ai = (ArrayInitializer)annotationToProcess.getValue();
        List normalAnnotations = ai.expressions();
        if (normalAnnotations.isEmpty()) {
            NormalAnnotation newChildDefaultAnnotation = this.processNormalAnnotation(ast, imports, importRWCtx, annotations, null);
            newCompositeAnnotationContents.add(newChildDefaultAnnotation);
        } else {
            for (NormalAnnotation na : normalAnnotations) {
                NormalAnnotation newNormalAnnotation = this.processNormalAnnotation(ast, imports, importRWCtx, annotations, na);
                newCompositeAnnotationContents.add(newNormalAnnotation);
            }
        }
        newSingleMemberAnnotation.setValue((Expression)newAIInstance);
        return newSingleMemberAnnotation;
    }

    private NormalAnnotation processNormalAnnotation(AST ast, ImportRewrite imports, ImportRewrite.ImportRewriteContext importRWCtx, String[] annotations, NormalAnnotation annotationToProcess) {
        NormalAnnotation newNormalAnnotation = ast.newNormalAnnotation();
        String[] stringArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            newNormalAnnotation.setTypeName(ast.newName(imports.addImport(annotation, importRWCtx)));
            List<MemberValuePair> values = newNormalAnnotation.values();
            if (annotationToProcess == null) {
                this.addNewAttributes(ast, values);
            } else {
                List existingValues = annotationToProcess.values();
                for (MemberValuePair mvp : existingValues) {
                    boolean containsAttributeToAdd = this.attributesToAdd.contains(mvp.getName().getFullyQualifiedName());
                    boolean containsAllToAdd = this.attributesToAdd.stream().allMatch(attr -> existingValues.stream().anyMatch(v -> v.equals(attr)));
                    boolean removeAttribute = this.attributesToRemove.contains(mvp.getName().getFullyQualifiedName());
                    if (!containsAttributeToAdd || !containsAllToAdd) {
                        if (removeAttribute) continue;
                        MemberValuePair newMemberValuePair = ast.newMemberValuePair();
                        newMemberValuePair.setName(ast.newSimpleName(mvp.getName().getFullyQualifiedName()));
                        if (mvp.getValue() instanceof StringLiteral) {
                            mvp.getValue();
                            newMemberValuePair.setValue((Expression)((StringLiteral)Expression.copySubtree((AST)ast, (ASTNode)mvp.getValue())));
                        } else if (mvp.getValue() instanceof TypeLiteral) {
                            mvp.getValue();
                            newMemberValuePair.setValue((Expression)((TypeLiteral)Expression.copySubtree((AST)ast, (ASTNode)mvp.getValue())));
                        }
                        values.add(newMemberValuePair);
                        continue;
                    }
                    newNormalAnnotation = (NormalAnnotation)NormalAnnotation.copySubtree((AST)ast, (ASTNode)annotationToProcess);
                    return newNormalAnnotation;
                }
                values = this.addNewAttributes(ast, values);
            }
            ++n2;
        }
        return newNormalAnnotation;
    }

    private NormalAnnotation createNewAnnotation(AST ast, ImportRewrite imports, ImportRewrite.ImportRewriteContext importRWCtx, String annotation) {
        NormalAnnotation marker = ast.newNormalAnnotation();
        marker.setTypeName(ast.newName(imports.addImport(annotation, importRWCtx)));
        List<MemberValuePair> values = marker.values();
        values = this.addNewAttributes(ast, values);
        return marker;
    }

    private List<MemberValuePair> addNewAttributes(AST ast, List<MemberValuePair> values) {
        for (String newAttr : this.attributesToAdd) {
            if (!values.stream().noneMatch(v -> v.getName().toString().equals(newAttr))) continue;
            MemberValuePair newMemberValuePair = ast.newMemberValuePair();
            newMemberValuePair.setName(ast.newSimpleName(newAttr));
            if ("type".equals(newAttr)) {
                TypeLiteral typeLiteral = ast.newTypeLiteral();
                typeLiteral.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("Object")));
                newMemberValuePair.setValue((Expression)typeLiteral);
            } else {
                StringLiteral stringValue = ast.newStringLiteral();
                stringValue.setLiteralValue("");
                newMemberValuePair.setValue((Expression)stringValue);
            }
            values.add(newMemberValuePair);
        }
        return values;
    }
}

