/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.nodiagnostics;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NoDiagnosticsTest
extends BaseJakartaTest {
    @Parameterized.Parameter
    public String filePath;
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void checkForNoDiagnostics() throws Exception {
        IJavaProject javaProject = NoDiagnosticsTest.loadJavaProject("demo-servlet-no-diagnostics", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path(this.filePath));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, new Diagnostic[0]);
    }

    @Parameterized.Parameters
    public static List<String> projectFileProvider() throws Exception {
        String packagePath = "/src/main/java/io/openliberty/sample/jakarta/";
        String basePath = String.valueOf(System.getProperty("user.dir")) + "/projects/demo-servlet-no-diagnostics/";
        File dir = new File(String.valueOf(basePath) + packagePath);
        String[] extensions = new String[]{"java"};
        ArrayList<String> results = new ArrayList<String>();
        Collection files = FileUtils.listFiles((File)dir, (String[])extensions, (boolean)true);
        for (File file : files) {
            results.add(file.getAbsolutePath().substring(basePath.length()));
        }
        return results;
    }
}

