/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.core;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.junit.Assert;

public class JakartaForJavaAssert {
    public static JakartaJavaCodeActionParams createCodeActionParams(String uri, Diagnostic d) {
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        Range range = d.getRange();
        CodeActionContext context = new CodeActionContext();
        context.setDiagnostics(Arrays.asList(d));
        JakartaJavaCodeActionParams codeActionParams = new JakartaJavaCodeActionParams(textDocument, range, context);
        codeActionParams.setResourceOperationSupported(true);
        return codeActionParams;
    }

    public static void assertJavaCodeAction(JakartaJavaCodeActionParams params, IJDTUtils utils, CodeAction ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().codeAction(params, utils, (IProgressMonitor)new NullProgressMonitor());
        JakartaForJavaAssert.assertCodeActions(actual != null && actual.size() > 0 ? actual : Collections.emptyList(), expected);
    }

    /*
     * WARNING - void declaration
     */
    public static void assertCodeActions(List<? extends CodeAction> actual, CodeAction ... expected) {
        void var2_5;
        actual.stream().forEach(ca -> {
            ca.setCommand(null);
            ca.setKind(null);
            if (ca.getDiagnostics() != null) {
                ca.getDiagnostics().forEach(d -> {
                    d.setSeverity(null);
                    d.setMessage("");
                    d.setSource(null);
                });
            }
        });
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (CodeAction codeAction : actual) {
            codeAction.setTitle(JakartaForJavaAssert.replaceNewLineCharacters(codeAction.getTitle()));
            List tdes = codeAction.getEdit().getDocumentChanges();
            for (Either tde : tdes) {
                List tes = ((TextDocumentEdit)tde.getLeft()).getEdits();
                for (TextEdit te : tes) {
                    te.setNewText(JakartaForJavaAssert.replaceNewLineCharacters(te.getNewText()));
                }
            }
        }
        boolean bl = false;
        while (var2_5 < expected.length) {
            Assert.assertEquals((String)("Assert title [" + (int)var2_5 + "]"), (Object)expected[var2_5].getTitle(), (Object)actual.get((int)var2_5).getTitle());
            Assert.assertEquals((String)("Assert edit [" + (int)var2_5 + "]"), (Object)expected[var2_5].getEdit(), (Object)actual.get((int)var2_5).getEdit());
            ++var2_5;
        }
    }

    public static CodeAction ca(String uri, String title, Diagnostic d, TextEdit ... te) {
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(title);
        codeAction.setDiagnostics(Arrays.asList(d));
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Arrays.asList(te));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Arrays.asList(Either.forLeft((Object)textDocumentEdit)));
        workspaceEdit.setChanges(Collections.emptyMap());
        codeAction.setEdit(workspaceEdit);
        return codeAction;
    }

    public static TextEdit te(int startLine, int startCharacter, int endLine, int endCharacter, String newText) {
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText(newText);
        textEdit.setRange(JakartaForJavaAssert.r(startLine, startCharacter, endLine, endCharacter));
        return textEdit;
    }

    public static Diagnostic d(int line, int startCharacter, int endCharacter, String message, DiagnosticSeverity severity, String source, String code, Object data) {
        Diagnostic d = new Diagnostic(JakartaForJavaAssert.r(line, startCharacter, line, endCharacter), message, severity, source, code != null ? code : null);
        d.setData(data);
        return d;
    }

    public static Diagnostic d(int line, int startCharacter, int endCharacter, String message, DiagnosticSeverity severity, String source, String code) {
        return JakartaForJavaAssert.d(line, startCharacter, line, endCharacter, message, severity, source, code);
    }

    public static Diagnostic d(int startLine, int startCharacter, int endLine, int endCharacter, String message, DiagnosticSeverity severity, String source, String code) {
        return new Diagnostic(JakartaForJavaAssert.r(startLine, startCharacter, endLine, endCharacter), message, severity, source, code != null ? code : null);
    }

    public static Range r(int line, int startCharacter, int endCharacter) {
        return JakartaForJavaAssert.r(line, startCharacter, line, endCharacter);
    }

    public static Range r(int startLine, int startCharacter, int endLine, int endCharacter) {
        return new Range(JakartaForJavaAssert.p(startLine, startCharacter), JakartaForJavaAssert.p(endLine, endCharacter));
    }

    public static Position p(int line, int character) {
        return new Position(line, character);
    }

    public static void assertJavaDiagnostics(JakartaJavaDiagnosticsParams params, IJDTUtils utils, Diagnostic ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().diagnostics(params, utils, (IProgressMonitor)new NullProgressMonitor());
        JakartaForJavaAssert.assertDiagnostics(actual != null && actual.size() > 0 ? ((PublishDiagnosticsParams)actual.get(0)).getDiagnostics() : Collections.emptyList(), expected);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, Diagnostic ... expected) {
        JakartaForJavaAssert.assertDiagnostics(actual, Arrays.asList(expected), false);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, List<Diagnostic> expected, boolean filter) {
        Comparator posOrder = (a, b) -> a.getLine() == b.getLine() ? b.getCharacter() - a.getCharacter() : b.getLine() - a.getLine();
        Comparator rangePosOrder = (a, b) -> posOrder.compare(a.getStart(), b.getStart()) == 0 ? posOrder.compare(a.getEnd(), b.getEnd()) : posOrder.compare(a.getStart(), b.getStart());
        Comparator diagnosticRangeOrder = (a, b) -> rangePosOrder.compare(a.getRange(), b.getRange());
        actual.sort(diagnosticRangeOrder);
        expected.sort(diagnosticRangeOrder);
        for (Diagnostic dia : actual) {
            dia.setMessage(JakartaForJavaAssert.replaceNewLineCharacters(dia.getMessage()));
        }
        List<Object> received = actual;
        boolean filterMessage = expected != null && !expected.isEmpty() && (expected.get(0).getMessage() == null || expected.get(0).getMessage().isEmpty());
        if (filter) {
            received = actual.stream().map(d -> {
                Diagnostic simpler = new Diagnostic(d.getRange(), "");
                simpler.setCode(d.getCode());
                if (filterMessage) {
                    simpler.setMessage(d.getMessage());
                }
                return simpler;
            }).collect(Collectors.toList());
        }
        Assert.assertEquals((String)("Unexpected diagnostics:\n" + actual), expected, received);
    }

    public static String fixURI(URI uri) {
        String uriString = uri.toString();
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }

    public static String replaceNewLineCharacters(String source) {
        return source.replaceAll("\r\n", "\n");
    }
}

