/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.annotations;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class PostConstructAnnotationTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void GeneratedAnnotation() throws Exception {
        IJavaProject javaProject = PostConstructAnnotationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/annotations/PostConstructAnnotation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(19, 16, 28, "A method with the @PostConstruct annotation must be void.", DiagnosticSeverity.Error, "jakarta-annotations", "PostConstructReturnType");
        Diagnostic d2 = JakartaForJavaAssert.d(24, 13, 25, "A method with the @PostConstruct annotation must not have any parameters.", DiagnosticSeverity.Error, "jakarta-annotations", "PostConstructParams");
        Diagnostic d3 = JakartaForJavaAssert.d(29, 13, 25, "A method with the annotation '@PostConstruct' must not throw checked exceptions.", DiagnosticSeverity.Error, "jakarta-annotations", "PostConstructException");
        Diagnostic d4 = JakartaForJavaAssert.d(44, 13, 29, "A method with the annotation '@PostConstruct' must not throw checked exceptions.", DiagnosticSeverity.Error, "jakarta-annotations", "PostConstructException");
        Diagnostic d5 = JakartaForJavaAssert.d(49, 13, 40, "A method with the annotation '@PostConstruct' must not throw checked exceptions.", DiagnosticSeverity.Error, "jakarta-annotations", "PostConstructException");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2, d3, d4, d5);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te1 = JakartaForJavaAssert.te(23, 1, 24, 1, "");
        TextEdit te2 = JakartaForJavaAssert.te(24, 26, 24, 37, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove @PostConstruct", d2, te1);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove all parameters", d2, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, IJDT_UTILS, ca1, ca2);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te3 = JakartaForJavaAssert.te(19, 8, 19, 15, "void");
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Change return type to void", d1, te3);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, IJDT_UTILS, ca3);
    }
}

