/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.cdi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.cdi.ManagedBeanConstants;

public class ManagedBeanDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-cdi";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit == null) {
            return;
        }
        try {
            IType[] types = unit.getAllTypes();
            String[] scopeFQNames = (String[])ManagedBeanConstants.SCOPE_FQ_NAMES.toArray(String[]::new);
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                int isProducerMethod;
                Object[] annotationNames;
                IField[] fields;
                boolean isManagedBean;
                IType type = iTypeArray[n2];
                List<String> managedBeanAnnotations = ManagedBeanDiagnosticsCollector.getMatchedJavaElementNames(type, (String[])Stream.of(type.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), scopeFQNames);
                boolean bl = isManagedBean = managedBeanAnnotations.size() > 0;
                if (managedBeanAnnotations.size() > 1) {
                    List diagnosticData = managedBeanAnnotations.stream().map(annotation -> ManagedBeanDiagnosticsCollector.getSimpleName(annotation)).collect(Collectors.toList());
                    diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "Scope type annotations must be specified by a managed bean class at most once.", "InvalidScopeDecl", (JsonArray)new Gson().toJsonTree(diagnosticData), DiagnosticSeverity.Error));
                }
                String[] injectAnnotations = new String[]{"jakarta.enterprise.inject.Produces", "jakarta.inject.Inject"};
                IField[] iFieldArray = fields = type.getFields();
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField field = iFieldArray[n4];
                    int fieldFlags = field.getFlags();
                    annotationNames = (String[])Stream.of(field.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new);
                    List<String> fieldScopes = ManagedBeanDiagnosticsCollector.getMatchedJavaElementNames(type, (String[])annotationNames, scopeFQNames);
                    if (isManagedBean && Flags.isPublic((int)fieldFlags) && !Flags.isStatic((int)fieldFlags) && (fieldScopes.size() != 1 || !fieldScopes.get(0).equals("jakarta.enterprise.context.Dependent"))) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)field, unit, this.createAnnotationDiagnostic("Dependent", "be the only scope defined by a managed bean with a non-static public field."), "InvalidManagedBeanAnnotation", null, DiagnosticSeverity.Error));
                    }
                    List<String> fieldInjects = ManagedBeanDiagnosticsCollector.getMatchedJavaElementNames(type, (String[])annotationNames, injectAnnotations);
                    boolean isProducerField = false;
                    boolean isInjectField = false;
                    for (String annotation2 : fieldInjects) {
                        if ("jakarta.enterprise.inject.Produces".equals(annotation2)) {
                            isProducerField = true;
                            continue;
                        }
                        if (!"jakarta.inject.Inject".equals(annotation2)) continue;
                        isInjectField = true;
                    }
                    if (isProducerField && fieldScopes.size() > 1) {
                        List diagnosticData = fieldScopes.stream().map(annotation -> ManagedBeanDiagnosticsCollector.getSimpleName(annotation)).collect(Collectors.toList());
                        diagnosticData.add("Produces");
                        diagnostics.add(this.createDiagnostic((IJavaElement)field, unit, "Scope type annotations must be specified by a producer field at most once.", "InvalidScopeDecl", (JsonArray)new Gson().toJsonTree(diagnosticData), DiagnosticSeverity.Error));
                    }
                    if (isProducerField && isInjectField) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)field, unit, "The annotations @Produces and @Inject must not be used on the same field or property.", "RemoveProducesOrInject", null, DiagnosticSeverity.Error));
                    }
                    ++n4;
                }
                IMethod[] methods = type.getMethods();
                ArrayList<IMethod> constructorMethods = new ArrayList<IMethod>();
                annotationNames = methods;
                int n5 = methods.length;
                int n6 = 0;
                while (n6 < n5) {
                    IMethod method = annotationNames[n6];
                    if (ManagedBeanDiagnosticsCollector.isConstructorMethod(method)) {
                        constructorMethods.add(method);
                    }
                    String[] annotationNames2 = (String[])Stream.of(method.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new);
                    List<String> methodScopes = ManagedBeanDiagnosticsCollector.getMatchedJavaElementNames(type, annotationNames2, scopeFQNames);
                    List<String> methodInjects = ManagedBeanDiagnosticsCollector.getMatchedJavaElementNames(type, annotationNames2, injectAnnotations);
                    isProducerMethod = 0;
                    boolean isInjectMethod = false;
                    for (String annotation3 : methodInjects) {
                        if ("jakarta.enterprise.inject.Produces".equals(annotation3)) {
                            isProducerMethod = 1;
                            continue;
                        }
                        if (!"jakarta.inject.Inject".equals(annotation3)) continue;
                        isInjectMethod = true;
                    }
                    if (isProducerMethod != 0 && methodScopes.size() > 1) {
                        List diagnosticData = methodScopes.stream().map(annotation -> ManagedBeanDiagnosticsCollector.getSimpleName(annotation)).collect(Collectors.toList());
                        diagnosticData.add("Produces");
                        diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "Scope type annotations must be specified by a producer method at most once.", "InvalidScopeDecl", (JsonArray)new Gson().toJsonTree(diagnosticData), DiagnosticSeverity.Error));
                    }
                    if (isProducerMethod != 0 && isInjectMethod) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "The annotations @Produces and @Inject must not be used on the same field or property.", "RemoveProducesOrInject", null, DiagnosticSeverity.Error));
                    }
                    ++n6;
                }
                if (isManagedBean && constructorMethods.size() > 0) {
                    ArrayList<IMethod> methodsNeedingDiagnostics = new ArrayList<IMethod>();
                    for (IMethod m : constructorMethods) {
                        if (m.getNumberOfParameters() == 0) {
                            methodsNeedingDiagnostics.clear();
                            break;
                        }
                        IAnnotation[] annotations = m.getAnnotations();
                        boolean hasParameterizedInjectConstructor = false;
                        IAnnotation[] iAnnotationArray = annotations;
                        isProducerMethod = annotations.length;
                        int methodInjects = 0;
                        while (methodInjects < isProducerMethod) {
                            IAnnotation annotation4 = iAnnotationArray[methodInjects];
                            if (ManagedBeanDiagnosticsCollector.isMatchedJavaElement(type, annotation4.getElementName(), "jakarta.inject.Inject")) {
                                hasParameterizedInjectConstructor = true;
                                break;
                            }
                            ++methodInjects;
                        }
                        if (hasParameterizedInjectConstructor) {
                            methodsNeedingDiagnostics.clear();
                            break;
                        }
                        methodsNeedingDiagnostics.add(m);
                    }
                    for (IMethod m : methodsNeedingDiagnostics) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)m, unit, this.createAnnotationDiagnostic("Inject", "define a managed bean constructor that takes parameters, or the managed bean must resolve to having a no-arg constructor instead."), "InvalidManagedBeanConstructor", null, DiagnosticSeverity.Error));
                    }
                }
                if (isManagedBean) {
                    boolean isClassGeneric = type.getTypeParameters().length != 0;
                    boolean isDependent = managedBeanAnnotations.stream().anyMatch(annotation -> "jakarta.enterprise.context.Dependent".equals(annotation));
                    if (isClassGeneric && !isDependent) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "Managed bean class of generic type must have scope @Dependent", "InvalidManagedBeanAnnotation", null, DiagnosticSeverity.Error));
                    }
                }
                this.invalidParamsCheck(unit, diagnostics, type, "jakarta.inject.Inject", "RemoveInjectOrConflictedAnnotations");
                if (isManagedBean) {
                    this.invalidParamsCheck(unit, diagnostics, type, "jakarta.enterprise.inject.Produces", "RemoveProducesOrConflictedAnnotations");
                    IMethod[] iMethodArray = methods;
                    int n7 = methods.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        ILocalVariable[] params;
                        IMethod method = iMethodArray[n8];
                        int numDisposes = 0;
                        TreeSet<String> invalidAnnotations = new TreeSet<String>();
                        ILocalVariable[] iLocalVariableArray = params = method.getParameters();
                        int n9 = params.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            IAnnotation[] annotations;
                            ILocalVariable param = iLocalVariableArray[n10];
                            IAnnotation[] iAnnotationArray = annotations = param.getAnnotations();
                            int n11 = annotations.length;
                            int n12 = 0;
                            while (n12 < n11) {
                                IAnnotation annotation5 = iAnnotationArray[n12];
                                String matchedAnnotation = ManagedBeanDiagnosticsCollector.getMatchedJavaElementName(type, annotation5.getElementName(), ManagedBeanConstants.INVALID_INJECT_PARAMS_FQ);
                                if ("jakarta.enterprise.inject.Disposes".equals(matchedAnnotation)) {
                                    ++numDisposes;
                                } else if ("jakarta.enterprise.event.Observes".equals(matchedAnnotation) || "jakarta.enterprise.event.ObservesAsync".equals(matchedAnnotation)) {
                                    invalidAnnotations.add("@" + annotation5.getElementName());
                                }
                                ++n12;
                            }
                            ++n10;
                        }
                        if (numDisposes != 0) {
                            if (numDisposes > 1) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, this.createAnnotationDiagnostic("Disposes", "not be defined on more than one parameter of a method."), "RemoveExtraDisposes", null, DiagnosticSeverity.Error));
                            }
                            if (!invalidAnnotations.isEmpty()) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, this.createInvalidDisposesLabel(invalidAnnotations), "RemoveDisposesOrConflictedAnnotations", null, DiagnosticSeverity.Error));
                            }
                        }
                        ++n8;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
        }
    }

    private void invalidParamsCheck(ICompilationUnit unit, List<Diagnostic> diagnostics, IType type, String target, String diagnosticCode) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IAnnotation targetAnnotation = null;
            IAnnotation[] iAnnotationArray = method.getAnnotations();
            int n3 = iAnnotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation2 = iAnnotationArray[n4];
                if (ManagedBeanDiagnosticsCollector.isMatchedJavaElement(type, annotation2.getElementName(), target)) {
                    targetAnnotation = annotation2;
                    break;
                }
                ++n4;
            }
            if (targetAnnotation != null) {
                ILocalVariable[] params;
                TreeSet<String> invalidAnnotations = new TreeSet<String>();
                ILocalVariable[] iLocalVariableArray = params = method.getParameters();
                int n5 = params.length;
                int n6 = 0;
                while (n6 < n5) {
                    ILocalVariable param = iLocalVariableArray[n6];
                    List<String> paramScopes = ManagedBeanDiagnosticsCollector.getMatchedJavaElementNames(type, (String[])Stream.of(param.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), ManagedBeanConstants.INVALID_INJECT_PARAMS_FQ);
                    for (String annotation3 : paramScopes) {
                        invalidAnnotations.add("@" + ManagedBeanDiagnosticsCollector.getSimpleName(annotation3));
                    }
                    ++n6;
                }
                if (!invalidAnnotations.isEmpty()) {
                    String label = "jakarta.enterprise.inject.Produces".equals(target) ? this.createInvalidProducesLabel(invalidAnnotations) : this.createInvalidInjectLabel(invalidAnnotations);
                    diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, label, diagnosticCode, null, DiagnosticSeverity.Error));
                }
            }
            ++n2;
        }
    }

    private String createInvalidInjectLabel(Set<String> invalidAnnotations) {
        String label = "A bean constructor or a method annotated with @Inject cannot have parameter(s) annotated with ";
        label = String.valueOf(label) + String.join((CharSequence)", ", invalidAnnotations);
        return label;
    }

    private String createInvalidProducesLabel(Set<String> invalidAnnotations) {
        String label = "A producer method cannot have parameter(s) annotated with ";
        label = String.valueOf(label) + String.join((CharSequence)", ", invalidAnnotations);
        return label;
    }

    private String createInvalidDisposesLabel(Set<String> invalidAnnotations) {
        String label = "A disposer method cannot have parameter(s) annotated with ";
        label = String.valueOf(label) + String.join((CharSequence)", ", invalidAnnotations);
        return label;
    }

    private String createAnnotationDiagnostic(String annotation, String message) {
        return "The annotation @" + annotation + " must " + message;
    }
}

