/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.operations.codelens;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.command.LSPCommandHandler;
import org.eclipse.lsp4e.operations.codelens.CodeLensProvider;
import org.eclipse.lsp4e.operations.codelens.LSPCodeMining;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LSPCodeMiningTest
extends AbstractTestWithProject {
    private static final String MOCK_SERVER_ID = "org.eclipse.lsp4e.test.server";

    @Test
    public void testLSPCodeMiningActionClientSideHandling() throws Exception {
        String commandID = "test.command";
        CodeLens lens = LSPCodeMiningTest.createCodeLens("test.command");
        final AtomicReference<Object> actualCommand = new AtomicReference<Object>(null);
        final AtomicReference<Object> actualPath = new AtomicReference<Object>(null);
        LSPCommandHandler handler = new LSPCommandHandler(){

            public Object execute(ExecutionEvent event, Command command, IPath context) throws ExecutionException {
                actualCommand.set(command);
                actualPath.set(context);
                return null;
            }
        };
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        handlerService.activateHandler("test.command", (IHandler)handler);
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt", "test content");
        IDocument document = TestUtils.openTextViewer(file).getDocument();
        CodeLensProvider provider = new CodeLensProvider();
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper((IProject)this.project, (LanguageServersRegistry.LanguageServerDefinition)LanguageServersRegistry.getInstance().getDefinition(MOCK_SERVER_ID));
        LSPCodeMining sut = new LSPCodeMining(lens, document, wrapper, provider);
        MouseEvent mouseEvent = LSPCodeMiningTest.createMouseEvent();
        sut.getAction().accept(mouseEvent);
        Assertions.assertEquals((Object)lens.getCommand(), actualCommand.get());
        Assertions.assertEquals((Object)file.getFullPath(), actualPath.get());
    }

    @Test
    public void testLSPCodeMiningActionServerSideHandling() throws Exception {
        CodeLens lens = LSPCodeMiningTest.createCodeLens("mock.command");
        Command command = lens.getCommand();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("bar", (Number)42);
        command.setArguments(List.of(new JsonPrimitive("Foo"), jsonObject));
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt", "test content");
        IDocument document = TestUtils.openTextViewer(file).getDocument();
        MockLanguageServer languageServer = MockLanguageServer.INSTANCE;
        CodeLensProvider provider = new CodeLensProvider();
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper((IProject)this.project, (LanguageServersRegistry.LanguageServerDefinition)LanguageServersRegistry.getInstance().getDefinition(MOCK_SERVER_ID));
        LSPCodeMining sut = new LSPCodeMining(lens, document, wrapper, provider);
        MouseEvent mouseEvent = LSPCodeMiningTest.createMouseEvent();
        sut.getAction().accept(mouseEvent);
        ExecuteCommandParams executedCommand = (ExecuteCommandParams)languageServer.getWorkspaceService().getExecutedCommand().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"mock.command", (Object)executedCommand.getCommand());
        Assertions.assertEquals((Object)command.getArguments(), (Object)executedCommand.getArguments());
    }

    private static MouseEvent createMouseEvent() {
        Event event = new Event();
        event.button = 524288;
        Display display = Display.getCurrent();
        event.widget = display.getSystemTray();
        return new MouseEvent(event);
    }

    private static CodeLens createCodeLens(String commandID) {
        CodeLens lens = new CodeLens();
        Position zero = new Position(0, 0);
        lens.setRange(new Range(zero, zero));
        Command command = new Command("TestCommand", commandID);
        lens.setCommand(command);
        return lens;
    }
}

