/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Triple;
import org.eclipse.lsat.common.ludus.backend.games.algorithms.DoubleFunctions;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.MeanPayoffGame;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick.ZwickPatersonDouble;

public class ZPSolverDouble {
    private ZPSolverDouble() {
    }

    public static <V, E> Triple<Set<V>, Set<V>, Set<V>> getThreeWayPartition(MeanPayoffGame<V, E, Double> game, Double payoffValue) {
        return ZPSolverDouble.getThreeWayPartition(game, payoffValue, 1.0E-4);
    }

    public static <V, E> Triple<Set<V>, Set<V>, Set<V>> getThreeWayPartition(MeanPayoffGame<V, E, Double> game, Double payoffValue, Double epsilon) {
        Map estimateMap = ZwickPatersonDouble.computeEstimate(game, epsilon);
        HashSet smaller = new HashSet();
        HashSet equal = new HashSet();
        HashSet larger = new HashSet();
        game.getVertices().forEach(v -> {
            Double vertexValue = (Double)estimateMap.get(v);
            if (DoubleFunctions.lessThan(vertexValue, payoffValue, epsilon)) {
                smaller.add(v);
            } else if (DoubleFunctions.greaterThan(vertexValue, payoffValue, epsilon)) {
                larger.add(v);
            } else {
                equal.add(v);
            }
        });
        return Triple.of(smaller, equal, larger);
    }

    public static <V, E> Map<V, Double> getValues(MeanPayoffGame<V, E, Double> game, Double epsilon) {
        return ZwickPatersonDouble.solve(game, epsilon);
    }

    public static <V, E> Map<V, Double> getValues(MeanPayoffGame<V, E, Double> game) {
        return ZwickPatersonDouble.solve(game, 1.0E-4);
    }
}

