/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.semanticTokens;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyleRange;

public class StyleRangeHolder
implements ITextListener {
    private final List<StyleRange> previousRanges = new ArrayList<StyleRange>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStyles(List<StyleRange> styleRanges) {
        List<StyleRange> list = this.previousRanges;
        synchronized (list) {
            this.previousRanges.clear();
            this.previousRanges.addAll(styleRanges);
            this.previousRanges.sort(Comparator.comparing(s -> s.start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleRange[] overlappingRanges(IRegion region) {
        List<StyleRange> list = this.previousRanges;
        synchronized (list) {
            return (StyleRange[])this.previousRanges.stream().filter(r -> TextUtilities.overlaps((IRegion)region, (IRegion)new Region(r.start, r.length))).map(this::clone).toArray(StyleRange[]::new);
        }
    }

    private StyleRange clone(StyleRange styleRange) {
        StyleRange clonedStyleRange = new StyleRange(styleRange.start, styleRange.length, styleRange.foreground, styleRange.background, styleRange.fontStyle);
        clonedStyleRange.strikeout = styleRange.strikeout;
        return clonedStyleRange;
    }

    private boolean isContained(int offset, IRegion region) {
        return offset >= region.getOffset() && offset < region.getOffset() + region.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textChanged(TextEvent event) {
        if (event.getDocumentEvent() != null) {
            String replacedText = event.getReplacedText();
            String text = event.getText();
            int delta = (text != null ? text.length() : 0) - (replacedText != null ? replacedText.length() : 0);
            List<StyleRange> list = this.previousRanges;
            synchronized (list) {
                this.previousRanges.removeIf(r -> this.isContained(event.getOffset(), (IRegion)new Region(r.start, r.length)));
                this.previousRanges.stream().filter(r -> r.start >= event.getOffset()).forEach(r -> {
                    int n2 = r.start = r.start + delta;
                });
            }
        }
    }
}

